/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.constant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.ShortMessageInfo;
import kd.bos.servicehelper.message.MessageServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.isc.iscb.platform.core.sf.ExprGetter;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;

public enum MessageType {
    COSMIC(new Pair((Object)"COSMIC", (Object)new MultiLangEnumBridge("\u5f53\u524d\u82cd\u7a79", "MessageType_0", "isc-iscb-platform-core")), new Pair[]{new Pair((Object)"system_message", (Object)new MultiLangEnumBridge("\u7cfb\u7edf\u6d88\u606f", "MessageType_1", "isc-iscb-platform-core"))}){

        @Override
        public void send(Message message) {
            if ("system_message".equals(message.noticeMethod)) {
                Set recipients = message.recipients;
                String msgContent = message.getFinalMsgContent();
                ArrayList<String> recipient_phone = new ArrayList<String>(recipients.size());
                ArrayList<Long> recipient_sys = new ArrayList<Long>(recipients.size());
                for (Long recipient : recipients) {
                    if (String.valueOf(recipient).matches(MessageType.PHONE_REGEX)) {
                        recipient_phone.add(String.valueOf(recipient));
                        continue;
                    }
                    recipient_sys.add(recipient);
                }
                if (recipient_phone.size() > 0) {
                    ShortMessageInfo shortMessageInfo = new ShortMessageInfo();
                    shortMessageInfo.setMessage(msgContent);
                    shortMessageInfo.setPhone(recipient_phone);
                    log.info(message.getContext().text + " \u5f85\u53d1\u9001\u7684\u77ed\u4fe1\u6d88\u606f\u4f53\uff1a" + shortMessageInfo);
                    shortMessageInfo.setMessage(StringUtil.trim((String)msgContent, (int)400));
                    MessageServiceHelper.sendShortMessage((ShortMessageInfo)shortMessageInfo);
                }
                if (recipient_sys.size() > 0) {
                    MessageInfo messageInfo = new MessageInfo();
                    messageInfo.setType("message");
                    messageInfo.setUserIds(recipient_sys);
                    messageInfo.setTag(ResManager.loadKDString((String)"\u96c6\u6210\u4e91", (String)"MessageType_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
                    messageInfo.setTitle(message.getFinalMsgTitle());
                    messageInfo.setContent(msgContent);
                    messageInfo.setContentUrl(message.getContentUrl());
                    log.info(message.getContext().text + " \u5f85\u53d1\u9001\u7684\u6d88\u606f\u4f53\uff1a" + messageInfo);
                    messageInfo.setContent(StringUtil.trim((String)msgContent, (int)1200));
                    long id = MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
                    log.info(message.getContext().text + "\u6d88\u606f\u4e2d\u5fc3\u8fd4\u56de\u7684\u6d88\u606fid:" + id);
                }
            }
        }
    };

    private Pair<String, MultiLangEnumBridge> name;
    private Map<String, MultiLangEnumBridge> types;
    private static final String PHONE_REGEX = "^1[3-9]\\d{9}$";
    private static final Log log;

    public Pair<String, MultiLangEnumBridge> getName() {
        return this.name;
    }

    public Map<String, MultiLangEnumBridge> getTypes() {
        return this.types;
    }

    private MessageType(Pair<String, MultiLangEnumBridge> name, Pair<String, MultiLangEnumBridge>[] typeArray) {
        this.name = name;
        this.types = new HashMap<String, MultiLangEnumBridge>(typeArray.length);
        for (Pair<String, MultiLangEnumBridge> type : typeArray) {
            this.types.put((String)type.getA(), (MultiLangEnumBridge)type.getB());
        }
    }

    public abstract void send(Message var1);

    static {
        log = LogFactory.getLog(MessageType.class);
    }

    public static class Message {
        private String noticeMethod;
        private Set<Long> recipients;
        private List<ExprGetter> recipientsVar;
        private String finalMsgTitle;
        private String finalMsgContent;
        private Context context = Context.FLOW_MESSAGE;
        private String contentUrl;

        public String getNoticeMethod() {
            return this.noticeMethod;
        }

        public void setNoticeMethod(String noticeMethod) {
            this.noticeMethod = noticeMethod;
        }

        public Set<Long> getRecipients() {
            return this.recipients;
        }

        public void setRecipients(List<Long> recipients) {
            if (this.recipients == null) {
                this.recipients = new HashSet<Long>();
            }
            this.recipients.addAll(recipients);
        }

        public void resetRecipients(List<Long> recipients) {
            this.recipients = new HashSet<Long>(recipients);
        }

        public List<ExprGetter> getRecipientsVar() {
            return this.recipientsVar;
        }

        public void setRecipientsVar(List<ExprGetter> recipients_var) {
            this.recipientsVar = recipients_var;
        }

        public String getFinalMsgTitle() {
            return this.finalMsgTitle;
        }

        public void setFinalMsgTitle(String finalMsgTitle) {
            this.finalMsgTitle = finalMsgTitle;
        }

        public String getFinalMsgContent() {
            return this.finalMsgContent;
        }

        public Context getContext() {
            return this.context;
        }

        public void setContext(Context context) {
            this.context = context;
        }

        public void setFinalMsgContent(String finalMsgContent) {
            this.finalMsgContent = finalMsgContent;
        }

        public String getContentUrl() {
            return this.contentUrl;
        }

        public void setContentUrl(String contentUrl) {
            this.contentUrl = contentUrl;
        }

        public Message clone() {
            Message message = new Message();
            message.noticeMethod = this.noticeMethod;
            message.recipients = new HashSet<Long>(this.recipients);
            message.recipientsVar = new ArrayList<ExprGetter>(this.recipientsVar);
            message.finalMsgTitle = this.finalMsgTitle;
            message.finalMsgContent = this.finalMsgContent;
            message.context = this.context;
            message.contentUrl = this.contentUrl;
            return message;
        }

        private static enum Context {
            ISC_MESSAGE(new MultiLangEnumBridge("\u542f\u52a8\u65b9\u6848", "MessageType_3", "isc-iscb-platform-core")),
            FLOW_MESSAGE(new MultiLangEnumBridge("\u670d\u52a1\u6d41\u7a0b", "MessageType_4", "isc-iscb-platform-core")),
            LINK_MESSAGE(new MultiLangEnumBridge("\u8fde\u63a5\u914d\u7f6e", "MessageType_5", "isc-iscb-platform-core"));

            private MultiLangEnumBridge text;

            private Context(MultiLangEnumBridge text) {
                this.text = text;
            }
        }
    }
}

