/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.consume;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.consume.res.ResConsumeItem;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.task.LightTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.misc.Triple;

public class IscConsumeInfo {
    private static final ConcurrentHashMap<String, Map<Triple<String, Object, String>, ResConsumeItem>> cache = new ConcurrentHashMap();
    private static Log logger = LogFactory.getLog(DataCopyTask.class);

    public static Map<Triple<String, Object, String>, ResConsumeItem> get() {
        String account = RequestContext.get().getAccountId();
        Map<Triple<String, Object, String>, ResConsumeItem> map = cache.get(account);
        if (map != null) {
            return map;
        }
        cache.putIfAbsent(account, new ConcurrentHashMap());
        return cache.get(account);
    }

    public static void initConsumeRecordJob() {
        ScheduleManager.submit((Task)IscConsumeInfo.createJob(), 3600);
    }

    public static LightTask createJob() {
        return new LightTask(){
            private String id = RequestContext.get().getAccountId() + this.getClass().getName();

            @Override
            public String getId() {
                return this.id;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String accountId = RequestContext.get().getAccountId();
                Map current = cache.put(accountId, new ConcurrentHashMap());
                try {
                    if (current != null) {
                        IscConsumeInfo.update(current);
                    }
                }
                catch (Exception e) {
                    logger.warn("\u4fdd\u5b58\u96c6\u6210\u4e91\u811a\u672c/\u503c\u8f6c\u6362\u89c4\u5219\u8017\u65f6\u4fe1\u606f\u5931\u8d25", (Throwable)e);
                }
                finally {
                    ScheduleManager.submit((Task)this, 3600);
                }
            }
        };
    }

    private static void update(Map<Triple<String, Object, String>, ResConsumeItem> itemMap) {
        String sql = "INSERT INTO t_isc_res_consume_stat (fid,fres_type,fres_number,fremark,ftotal_consume_time,ftotal_invoke_count,favg_consume_time,frecord_time) VALUES(?,?,?,?,?,?,?,?)";
        List<List<Object>> insertParams = IscConsumeInfo.getInsertParams(itemMap);
        List<Integer> types = Arrays.asList(-5, 12, 12, 12, -5, 4, 4, 93);
        IscConsumeInfo.saveConsumeStat(sql, insertParams, types);
    }

    private static List<List<Object>> getInsertParams(Map<Triple<String, Object, String>, ResConsumeItem> itemMap) {
        ArrayList<List<Object>> insertParams = new ArrayList<List<Object>>(itemMap.size());
        for (Map.Entry<Triple<String, Object, String>, ResConsumeItem> itemEntry : itemMap.entrySet()) {
            ResConsumeItem item = itemEntry.getValue();
            List<Object> values = IscConsumeInfo.innerGetItemParams(item);
            if (values == null) continue;
            insertParams.add(values);
        }
        return insertParams;
    }

    private static List<Object> innerGetItemParams(ResConsumeItem item) {
        long millis = System.currentTimeMillis();
        int invokeTimes = D.i((Object)item.getInvokeTimes());
        if (invokeTimes <= 0) {
            return null;
        }
        Timestamp now = new Timestamp(millis);
        long id = IDService.get().genLongId();
        String res_type = D.s((Object)item.getEntityType());
        String res_number = item.getEntityNummber();
        String r = D.s((Object)item.getResRemark());
        String res_remark = r == null ? "" : r;
        long totalTimeSpan = D.l((Object)item.getTotalTimeSpan());
        long avgTime = totalTimeSpan / (long)invokeTimes;
        return Arrays.asList(id, res_type, res_number, res_remark, totalTimeSpan, invokeTimes, avgTime, now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveConsumeStat(String sql, List<List<Object>> insertParams, List<Integer> types) {
        if (!insertParams.isEmpty()) {
            Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
            try {
                DbUtil.executeBatch((Connection)cn, (String)sql, insertParams, types);
            }
            finally {
                DbUtil.close((Connection)cn, (boolean)true);
            }
        }
    }

    public static void recordOnce(long start, DynamicObject entity, String title) {
        Map<Triple<String, Object, String>, ResConsumeItem> map = IscConsumeInfo.get();
        IscConsumeInfo.innerRecord(start, entity.getDataEntityType().getName(), entity.getString("number"), title, entity.getPkValue(), map);
    }

    public static void recordOnce(long start, Flow flow, String title) {
        Map<Triple<String, Object, String>, ResConsumeItem> map = IscConsumeInfo.get();
        Map attributes = flow.getAttributes();
        IscConsumeInfo.innerRecord(start, "isc_service_flow", D.s(attributes.get("flow_number")), title, attributes.get("flow_id"), map);
    }

    private static void innerRecord(long start, String entityType, String flowNumber, String title, Object pkValue, Map<Triple<String, Object, String>, ResConsumeItem> map) {
        Triple triple = new Triple((Object)entityType, pkValue, (Object)title);
        ResConsumeItem item = map.get(triple);
        if (item == null) {
            map.putIfAbsent((Triple<String, Object, String>)triple, new ResConsumeItem(entityType, flowNumber, title));
            item = map.get(triple);
        }
        item.recordOnce(start);
    }

    public static void clear() {
        String account = RequestContext.get().getAccountId();
        cache.remove(account);
    }
}

