/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.content;

import java.util.ArrayList;
import java.util.List;

public abstract class BatchWriter<T> {
    private int batchSize;
    private List<T> list;

    public BatchWriter(int batchSize) {
        this.batchSize = batchSize;
        this.list = new ArrayList<T>(batchSize);
    }

    public void write(T item) {
        this.list.add(item);
        if (this.list.size() >= this.batchSize) {
            this.flush();
            this.list = new ArrayList<T>(this.batchSize);
        }
    }

    public void flush() {
        if (!this.list.isEmpty()) {
            this.flushBatch(this.list);
        }
    }

    protected abstract void flushBatch(List<T> var1);
}

