/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.content;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.content.ResourceType;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class SearchItem {
    private long id = ID.genLongId();
    private ResourceType resourceType;
    private Object resourceId;
    private List<Map<String, Object>> locations;
    private boolean matched;
    private String keyword;

    public SearchItem(ResourceType resourceType, Object resourceId, String keyword) {
        this.resourceType = resourceType;
        this.resourceId = resourceId;
        this.locations = new ArrayList<Map<String, Object>>();
        this.matched = false;
        this.keyword = keyword;
    }

    public void addLocation(Map<String, Object> location) {
        this.locations.add(location);
        this.matched = true;
    }

    public boolean addLocation(DataRow dataRow, String fieldNumber) {
        String s = D.s((Object)dataRow.get((Object)fieldNumber));
        if (s != null && s.contains(this.keyword)) {
            HashMap<String, Object> location = new HashMap<String, Object>();
            location.put("fieldNumber", fieldNumber);
            location.put("fieldName", this.resourceType.searcher().getFieldMap().get(fieldNumber));
            this.addLocation(location);
            return true;
        }
        return false;
    }

    public String getLocationDesc() {
        String desc = this.resourceType.searcher().makeLocationDesc(this.locations);
        return StringUtil.trim((String)desc, (int)80);
    }

    public List<Object> values() {
        return Arrays.asList(this.id, this.resourceType.name(), this.resourceId, "D", this.getLocationDesc(), this.makeLocationTag(), this.keyword, RequestContext.get().getCurrUserId());
    }

    private String makeLocationTag() {
        String tag = Json.toString(this.locations);
        if (tag.length() > 1000) {
            String multi = ResManager.loadKDString((String)"\u6839\u636e\u5173\u952e\u8bcd\u3010%1$s\u3011\u68c0\u7d22%2$s\u3010%3$s(%4$s)\u3011\u547d\u4e2d\u7684\u4f4d\u7f6e\u8fc7\u591a\uff0c\u5df2\u7ec8\u6b62\u68c0\u7d22\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u5173\u952e\u8bcd\u4ee5\u4f7f\u547d\u4e2d\u4f4d\u7f6e\u4fe1\u606f\u66f4\u7cbe\u786e\u3002", (String)"SearchItem_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            QFilter qFilter = new QFilter("id", "=", this.resourceId);
            DynamicObject obj = QueryServiceHelper.queryOne((String)this.resourceType.name(), (String)"number,name", (QFilter[])new QFilter[]{qFilter});
            String tips = String.format(multi, this.keyword, this.resourceType.getTitle(), obj.get("name"), obj.get("number"));
            throw new IscBizException(tips);
        }
        return tag;
    }

    public boolean isMatched() {
        return this.matched;
    }

    public Object getResourceId() {
        return this.resourceId;
    }

    public String getKeyword() {
        return this.keyword;
    }
}

