/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.content.searcher;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.content.ContentSearcher;
import kd.isc.iscb.platform.core.content.ResourceType;
import kd.isc.iscb.platform.core.content.SearchItem;
import kd.isc.iscb.platform.core.content.SearchUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.dt.D;

public class DataCompSearcher
implements ContentSearcher {
    private static final String SRC_FILTER_VALUE = "select ffilter_value_fixed from t_isc_data_comp_filter where fid = ?";
    private Map<String, String> fieldMap;
    private ResourceType resourceType;

    public DataCompSearcher(ResourceType resourceType) {
        this.resourceType = resourceType;
        this.fieldMap = new HashMap<String, String>(16);
        this.fieldMap.put("ffilter_value_fixed", ResManager.loadKDString((String)"\u56fa\u5b9a\u6bd4\u8f83\u503c", (String)"DataCompSearcher_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.fieldMap.put("fts_expr", ResManager.loadKDString((String)"\u5224\u65ad\u8868\u8fbe\u5f0f", (String)"DataCompSearcher_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public SearchItem convert(DataRow data, String keyword) {
        long fid = D.l((Object)data.get((Object)"fid"));
        SearchItem searchItem = new SearchItem(this.resourceType, fid, keyword);
        searchItem.addLocation(data, "fts_expr");
        this.searchSrcFilter(searchItem);
        return searchItem;
    }

    private void searchSrcFilter(SearchItem searchItem) {
        List<DataRow> list = SearchUtil.query(SRC_FILTER_VALUE, Collections.singletonList(searchItem.getResourceId()), Collections.singletonList(-5));
        for (DataRow row : list) {
            if (searchItem.addLocation(row, "ffilter_value_fixed")) break;
        }
    }

    @Override
    public String getQuerySql() {
        return "select fid,fnumber,fts_expr from t_isc_data_comp";
    }

    @Override
    public Map<String, String> getFieldMap() {
        return Collections.unmodifiableMap(this.fieldMap);
    }
}

