/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.content.searcher;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.content.ContentSearcher;
import kd.isc.iscb.platform.core.content.ResourceType;
import kd.isc.iscb.platform.core.content.SearchItem;
import kd.isc.iscb.platform.core.content.SearchUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.dt.D;

public class DataCopySearcher
implements ContentSearcher {
    private static final String QUERY_MAPPING_FIX_VALUE = "select ffixed_value from t_iscb_data_copy_mapping where fid = ?";
    private static final String QUERY_FILTER_FIX_VALUE = "select fvalue_fixed from t_iscb_data_copy_filters where fid = ?";
    private Map<String, String> fieldMap;
    private ResourceType resourceType;

    public DataCopySearcher(ResourceType resourceType) {
        this.resourceType = resourceType;
        this.fieldMap = new HashMap<String, String>(16);
        this.fieldMap.put("fsrc_retrieve_script_tag", ResManager.loadKDString((String)"\u6765\u6e90\u6570\u636e\u67e5\u8be2\u811a\u672c", (String)"DataCopySearcher_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.fieldMap.put("freader_script_tag", ResManager.loadKDString((String)"\u6765\u6e90\u6570\u636e\u5904\u7406\u811a\u672c", (String)"DataCopySearcher_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.fieldMap.put("fmapping_script_tag", ResManager.loadKDString((String)"\u8f6c\u6362\u811a\u672c", (String)"DataCopySearcher_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.fieldMap.put("ftarget_script_tag", ResManager.loadKDString((String)"\u76ee\u6807\u6570\u636e\u5904\u7406\u811a\u672c", (String)"DataCopySearcher_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.fieldMap.put("fparent_field", ResManager.loadKDString((String)"\u5c42\u6b21\u7ed3\u6784", (String)"DataCopySearcher_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.fieldMap.put("fdefault_root_parent", ResManager.loadKDString((String)"\u5c42\u6b21\u7ed3\u6784", (String)"DataCopySearcher_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.fieldMap.put("froot_node_creteria", ResManager.loadKDString((String)"\u5c42\u6b21\u7ed3\u6784", (String)"DataCopySearcher_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.fieldMap.put("ffixed_value", ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04-\u76f4\u63a5\u8d4b\u503c", (String)"DataCopySearcher_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.fieldMap.put("fvalue_fixed", ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6-\u56fa\u5b9a\u6bd4\u8f83\u503c", (String)"DataCopySearcher_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public SearchItem convert(DataRow dataRow, String keyword) {
        long fid = D.l((Object)dataRow.get((Object)"fid"));
        SearchItem searchItem = new SearchItem(this.resourceType, fid, keyword);
        this.searchLevelFields(dataRow, searchItem);
        this.searchMappingFixedValue(searchItem);
        this.searchFilterFixedValue(searchItem);
        this.searchScriptFields(dataRow, searchItem);
        return searchItem;
    }

    private void searchFilterFixedValue(SearchItem searchItem) {
        List<DataRow> list = SearchUtil.query(QUERY_FILTER_FIX_VALUE, Collections.singletonList(searchItem.getResourceId()), Collections.singletonList(-5));
        for (DataRow row : list) {
            if (searchItem.addLocation(row, "fvalue_fixed")) break;
        }
    }

    private void searchScriptFields(DataRow dataRow, SearchItem searchItem) {
        searchItem.addLocation(dataRow, "fsrc_retrieve_script_tag");
        searchItem.addLocation(dataRow, "freader_script_tag");
        searchItem.addLocation(dataRow, "fmapping_script_tag");
        searchItem.addLocation(dataRow, "ftarget_script_tag");
    }

    private void searchLevelFields(DataRow dataRow, SearchItem searchItem) {
        searchItem.addLocation(dataRow, "fparent_field");
        searchItem.addLocation(dataRow, "fdefault_root_parent");
        searchItem.addLocation(dataRow, "froot_node_creteria");
    }

    private void searchMappingFixedValue(SearchItem searchItem) {
        List<DataRow> list = SearchUtil.query(QUERY_MAPPING_FIX_VALUE, Collections.singletonList(searchItem.getResourceId()), Collections.singletonList(-5));
        for (DataRow row : list) {
            if (searchItem.addLocation(row, "ffixed_value")) break;
        }
    }

    @Override
    public String getQuerySql() {
        return "select fid , fnumber, freader_script_tag, fsrc_retrieve_script_tag,  fmapping_script_tag,  ftarget_script_tag,  fparent_field,  fdefault_root_parent,  froot_node_creteria  from t_iscb_data_copy ";
    }

    @Override
    public Map<String, String> getFieldMap() {
        return Collections.unmodifiableMap(this.fieldMap);
    }
}

