/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.content.searcher;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.content.ContentSearcher;
import kd.isc.iscb.platform.core.content.ResourceType;
import kd.isc.iscb.platform.core.content.SearchItem;
import kd.isc.iscb.platform.core.content.SearchUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.dt.D;

public class DataCopyTriggerSearcher
implements ContentSearcher {
    private Map<String, String> fieldMap;
    private ResourceType resourceType;
    private static final String QUERY_PARAMS_VALUE = "select fparams_value from t_isc_dc_trigger_params where fid = ?";
    private static final String QUERY_FILTER_FIXED = "select fvalue_fixed from t_isc_data_copy_trigger_f where fid = ?";

    public DataCopyTriggerSearcher(ResourceType resourceType) {
        this.resourceType = resourceType;
        this.fieldMap = new HashMap<String, String>(2);
        this.fieldMap.put("fparams_value", ResManager.loadKDString((String)"\u53c2\u6570\u503c", (String)"DataCopyTriggerSearcher_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.fieldMap.put("fvalue_fixed", ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6-\u56fa\u5b9a\u6bd4\u8f83\u503c", (String)"DataCopyTriggerSearcher_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public SearchItem convert(DataRow dataRow, String keyword) {
        long fid = D.l((Object)dataRow.get((Object)"fid"));
        SearchItem searchItem = new SearchItem(this.resourceType, fid, keyword);
        this.searchParamsValue(searchItem);
        this.searchFilterValueFixed(searchItem);
        return searchItem;
    }

    private void searchFilterValueFixed(SearchItem searchItem) {
        this.searchListField(QUERY_FILTER_FIXED, searchItem, "fvalue_fixed");
    }

    private void searchParamsValue(SearchItem searchItem) {
        this.searchListField(QUERY_PARAMS_VALUE, searchItem, "fparams_value");
    }

    @Override
    public String getQuerySql() {
        return "select fid from t_isc_data_copy_trigger";
    }

    @Override
    public Map<String, String> getFieldMap() {
        return Collections.unmodifiableMap(this.fieldMap);
    }

    private void searchListField(String sql, SearchItem searchItem, String fieldNumber) {
        List<DataRow> list = SearchUtil.query(sql, Collections.singletonList(searchItem.getResourceId()), Collections.singletonList(-5));
        for (DataRow row : list) {
            if (searchItem.addLocation(row, fieldNumber)) break;
        }
    }
}

