/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.content.searcher;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.content.ContentSearcher;
import kd.isc.iscb.platform.core.content.ResourceType;
import kd.isc.iscb.platform.core.content.SearchItem;
import kd.isc.iscb.platform.core.content.SearchUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.dt.D;

public class ExternalApiSearcher
implements ContentSearcher {
    private static final String QUERY_INPUT_DEFAULT_VALUE = "select fdefault_value from t_iscb_external_api_in where fid = ?";
    private Map<String, String> fieldMap;
    private ResourceType resourceType;

    public ExternalApiSearcher(ResourceType resourceType) {
        this.resourceType = resourceType;
        this.fieldMap = new HashMap<String, String>(16);
        this.fieldMap.put("fdefault_value", ResManager.loadKDString((String)"\u8f93\u5165\u9ed8\u8ba4\u503c", (String)"ScriptApiSearcher_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public SearchItem convert(DataRow data, String keyword) {
        long fid = D.l((Object)data.get((Object)"fid"));
        SearchItem searchItem = new SearchItem(this.resourceType, fid, keyword);
        this.searchInputDefault(searchItem);
        return searchItem;
    }

    private void searchInputDefault(SearchItem searchItem) {
        List<DataRow> list = SearchUtil.query(QUERY_INPUT_DEFAULT_VALUE, Collections.singletonList(searchItem.getResourceId()), Collections.singletonList(-5));
        for (DataRow row : list) {
            if (searchItem.addLocation(row, "fdefault_value")) break;
        }
    }

    @Override
    public String getQuerySql() {
        return "select fid,fnumber from t_iscb_external_api";
    }

    @Override
    public Map<String, String> getFieldMap() {
        return Collections.unmodifiableMap(this.fieldMap);
    }
}

