/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.content.searcher;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.content.ContentSearcher;
import kd.isc.iscb.platform.core.content.ResourceType;
import kd.isc.iscb.platform.core.content.SearchItem;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.dt.D;

public class MetaSchemaSearcher
implements ContentSearcher {
    private ResourceType resourceType;
    private Map<String, String> fieldMap;

    public MetaSchemaSearcher(ResourceType resourceType) {
        this.resourceType = resourceType;
        this.fieldMap = new HashMap<String, String>(8);
        this.fieldMap.put("fview_sql_tag", ResManager.loadKDString((String)"\u89c6\u56feSQL", (String)"MetaSchemaSearcher_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.fieldMap.put("fparam_jst_tag", ResManager.loadKDString((String)"\u53c2\u6570\u8f6c\u6362\u811a\u672c", (String)"MetaSchemaSearcher_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.fieldMap.put("fresult_jst_tag", ResManager.loadKDString((String)"\u7ed3\u679c\u8f6c\u6362\u811a\u672c", (String)"MetaSchemaSearcher_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public SearchItem convert(DataRow dataRow, String keyword) {
        long fid = D.l((Object)dataRow.get((Object)"fid"));
        SearchItem searchItem = new SearchItem(this.resourceType, fid, keyword);
        String ftype = D.s((Object)dataRow.get((Object)"ftype"));
        if ("VIEW".equals(ftype)) {
            searchItem.addLocation(dataRow, "fview_sql_tag");
        } else if ("SERVICE".equals(ftype)) {
            searchItem.addLocation(dataRow, "fparam_jst_tag");
            searchItem.addLocation(dataRow, "fresult_jst_tag");
        } else if ("QUERY".equals(ftype)) {
            searchItem.addLocation(dataRow, "fparam_jst_tag");
            searchItem.addLocation(dataRow, "fresult_jst_tag");
        }
        return searchItem;
    }

    @Override
    public String getQuerySql() {
        return "select fid, fnumber, ftype, fview_sql_tag, fparam_jst_tag, fresult_jst_tag from t_isc_dataschema where ftype in ('VIEW', 'SERVICE','QUERY');";
    }

    @Override
    public Map<String, String> getFieldMap() {
        return Collections.unmodifiableMap(this.fieldMap);
    }
}

