/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.content.searcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.content.ContentSearcher;
import kd.isc.iscb.platform.core.content.ResourceType;
import kd.isc.iscb.platform.core.content.SearchItem;
import kd.isc.iscb.platform.core.content.SearchUtil;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;

public class ServiceFlowSearcher
implements ContentSearcher {
    private Map<String, String> fieldMap;
    private ResourceType resourceType;

    public ServiceFlowSearcher(ResourceType resourceType) {
        this.resourceType = resourceType;
        this.fieldMap = new HashMap<String, String>(1);
        this.fieldMap.put("fdefault_value", ResManager.loadKDString((String)"\u6d41\u7a0b\u53d8\u91cf-\u9ed8\u8ba4\u503c", (String)"ServiceFlowSearcher_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public SearchItem convert(DataRow dataRow, String keyword) {
        long fid = D.l((Object)dataRow.get((Object)"fid"));
        SearchItem item = new SearchItem(this.resourceType, fid, keyword);
        this.checkParamDefaultValue(item, fid);
        this.checkFlowDefine(item, D.s((Object)dataRow.get((Object)"fdefine_json_tag")));
        return item;
    }

    private void checkParamDefaultValue(SearchItem item, long fid) {
        String sql = "select fdefault_value from t_isc_service_flow_var where fid = ?";
        List<DataRow> values = SearchUtil.query(sql, Collections.singletonList(fid), Collections.singletonList(-5));
        for (DataRow row : values) {
            if (item.addLocation(row, "fdefault_value")) break;
        }
    }

    private void checkFlowDefine(SearchItem item, String fdefineJsonTag) {
        if (fdefineJsonTag != null && fdefineJsonTag.contains(item.getKeyword())) {
            this.searchServiceFlowDiagram(item, fdefineJsonTag);
        }
    }

    @Override
    public String makeLocationDesc(List<Map<String, Object>> locations) {
        ArrayList<Map<String, Object>> nodeLocations = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> linkLocations = new ArrayList<Map<String, Object>>();
        StringBuilder desc = this.initDesc(locations, nodeLocations, linkLocations);
        this.appendNodesDesc(nodeLocations, desc);
        this.appendLinksDesc(linkLocations, desc);
        return desc.toString();
    }

    private void appendLinksDesc(List<Map<String, Object>> linkLocations, StringBuilder desc) {
        if (!CollectionUtils.isEmpty(linkLocations)) {
            if (desc.length() > 0) {
                desc.append("\r\n");
            }
            desc.append(this.getLinkTag());
            this.appendLinkDesc(linkLocations, desc);
            desc.append('\u3011');
        }
    }

    private String getLinkTag() {
        String tag = ResManager.loadKDString((String)"\u8f6c\u79fb", (String)"ServiceFlowSearcher_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        return String.format("%1$s\u3010", tag);
    }

    private void appendNodesDesc(List<Map<String, Object>> nodeLocations, StringBuilder desc) {
        if (!CollectionUtils.isEmpty(nodeLocations)) {
            if (desc.length() > 0) {
                desc.append("\r\n");
            }
            desc.append(this.getNodeTag());
            this.appendNodeDesc(nodeLocations, desc);
            desc.append('\u3011');
        }
    }

    private String getNodeTag() {
        String tag = ResManager.loadKDString((String)"\u8282\u70b9", (String)"ServiceFlowSearcher_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        return String.format("%1$s\u3010", tag);
    }

    private StringBuilder initDesc(List<Map<String, Object>> locations, List<Map<String, Object>> nodeLocations, List<Map<String, Object>> linkLocations) {
        StringBuilder desc = new StringBuilder();
        for (Map<String, Object> location : locations) {
            if (D.x((Object)location.get("isMeta"))) {
                if (D.x((Object)location.get("isNode"))) {
                    nodeLocations.add(location);
                    continue;
                }
                linkLocations.add(location);
                continue;
            }
            desc.append(location.get("fieldName"));
        }
        return desc;
    }

    @Override
    public String getQuerySql() {
        return "select fid, fnumber, fdefine_json_tag from t_isc_service_flow ";
    }

    @Override
    public Map<String, String> getFieldMap() {
        return Collections.unmodifiableMap(this.fieldMap);
    }

    private void appendNodeDesc(List<Map<String, Object>> nodeLocations, StringBuilder desc) {
        for (int i = 0; i < nodeLocations.size(); ++i) {
            if (i > 0) {
                desc.append('\uff1b');
            }
            Map<String, Object> nodeLocation = nodeLocations.get(i);
            desc.append(nodeLocation.get("title"));
        }
    }

    private void appendLinkDesc(List<Map<String, Object>> linkLocations, StringBuilder desc) {
        for (int i = 0; i < linkLocations.size(); ++i) {
            if (i > 0) {
                desc.append('\uff1b');
            }
            Map<String, Object> linkLocation = linkLocations.get(i);
            desc.append(linkLocation.get("title")).append('\uff08').append(linkLocation.get("source_title")).append("->").append(linkLocation.get("target_title")).append('\uff09');
        }
    }

    private void searchServiceFlowDiagram(SearchItem item, String defineStr) {
        Map links;
        Map define = (Map)Json.toObject((String)defineStr);
        Map nodes = (Map)define.get("nodes");
        if (!CollectionUtils.isEmpty(nodes)) {
            this.addNodeLocations(item, nodes);
        }
        if (!CollectionUtils.isEmpty(links = (Map)define.get("links"))) {
            this.addLinkLocations(item, nodes, links);
        }
    }

    private void addLinkLocations(SearchItem item, Map<String, Map<String, Object>> nodes, Map<String, Map<String, Object>> links) {
        for (Map.Entry<String, Map<String, Object>> link : links.entrySet()) {
            Map<String, Object> linkDefine = link.getValue();
            String LinkDefineStr = D.s(linkDefine);
            if (LinkDefineStr == null || !LinkDefineStr.contains(item.getKeyword())) continue;
            this.addLinkLocation(item, nodes, linkDefine);
        }
    }

    private void addLinkLocation(SearchItem item, Map<String, Map<String, Object>> nodes, Map<String, Object> linkDefine) {
        HashMap<String, Object> location = new HashMap<String, Object>();
        location.put("id", linkDefine.get("id"));
        location.put("title", linkDefine.get("title"));
        location.put("type", linkDefine.get("type"));
        location.put("isNode", Boolean.FALSE);
        location.put("isMeta", Boolean.TRUE);
        String sourceId = D.s((Object)linkDefine.get("source"));
        location.put("source_id", sourceId);
        location.put("source_title", this.getTitle(nodes, sourceId));
        String targetId = D.s((Object)linkDefine.get("target"));
        location.put("target_id", targetId);
        location.put("target_title", this.getTitle(nodes, targetId));
        item.addLocation(location);
    }

    private void addNodeLocations(SearchItem item, Map<String, Map<String, Object>> nodes) {
        for (Map.Entry<String, Map<String, Object>> node : nodes.entrySet()) {
            Map<String, Object> nodeDefine = node.getValue();
            String nodeDefineStr = D.s(nodeDefine);
            if (nodeDefineStr == null || !nodeDefineStr.contains(item.getKeyword())) continue;
            this.addNodeLocation(item, nodeDefine);
        }
    }

    private void addNodeLocation(SearchItem item, Map<String, Object> nodeDefine) {
        HashMap<String, Object> location = new HashMap<String, Object>();
        location.put("id", nodeDefine.get("id"));
        location.put("title", nodeDefine.get("title"));
        location.put("type", nodeDefine.get("type"));
        location.put("isNode", Boolean.TRUE);
        location.put("isMeta", Boolean.TRUE);
        item.addLocation(location);
    }

    private String getTitle(Map<String, Map<String, Object>> nodes, String nodeId) {
        Map<String, Object> item = nodes.get(nodeId);
        return this.getTitleByNodeDefine(item);
    }

    private String getTitleByNodeDefine(Map<String, Object> nodeDefine) {
        if (nodeDefine != null) {
            return D.s((Object)nodeDefine.get("title"));
        }
        return null;
    }
}

