/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.content.searcher;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.content.ContentSearcher;
import kd.isc.iscb.platform.core.content.ResourceType;
import kd.isc.iscb.platform.core.content.SearchItem;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.dt.D;

public class ValueConversionRuleSearcher
implements ContentSearcher {
    private ResourceType resourceType;
    private Map<String, String> fieldMap;

    public ValueConversionRuleSearcher(ResourceType resourceType) {
        this.resourceType = resourceType;
        this.fieldMap = new HashMap<String, String>(8);
        this.fieldMap.put("fsql_tag", ResManager.loadKDString((String)"SQL\u5185\u5bb9", (String)"ValueConversionRuleSearcher_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.fieldMap.put("fisc_script_tag", ResManager.loadKDString((String)"\u96c6\u6210\u811a\u672c", (String)"ValueConversionRuleSearcher_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public SearchItem convert(DataRow dataRow, String keyword) {
        long fid = D.l((Object)dataRow.get((Object)"fid"));
        SearchItem searchItem = new SearchItem(this.resourceType, fid, keyword);
        String frule_type = D.s((Object)dataRow.get((Object)"frule_type"));
        if ("sql".equals(frule_type)) {
            searchItem.addLocation(dataRow, "fsql_tag");
        } else {
            searchItem.addLocation(dataRow, "fisc_script_tag");
        }
        return searchItem;
    }

    @Override
    public Map<String, String> getFieldMap() {
        return Collections.unmodifiableMap(this.fieldMap);
    }

    @Override
    public String getQuerySql() {
        return "select fid, fnumber, frule_type, fsql_tag, fisc_script_tag from t_isc_value_conver_rule  where frule_type in ('sql','script') ;";
    }
}

