/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.datacomp;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.datacomp.builder.TableObjectReader;
import kd.isc.iscb.platform.core.datacomp.param.DataCompParam;
import kd.isc.iscb.platform.core.datacomp.util.CompUtil;
import kd.isc.iscb.platform.core.dc.e.DataCopyMapping;
import kd.isc.iscb.platform.core.dc.e.Filter;
import kd.isc.iscb.platform.core.dc.e.MarkedReader;
import kd.isc.iscb.platform.core.dc.e.ServiceUtil;
import kd.isc.iscb.platform.core.dc.e.p.ViewUtil;
import kd.isc.iscb.platform.core.dc.e.s.SourceDataDecorator;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.Schema;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ListAsReader;
import kd.isc.iscb.util.io.NullObjectReader;
import kd.isc.iscb.util.io.ObjectReader;

public class DataCompInput {
    private DataCompParam param;
    private DataCopyMapping mapping;

    DataCompInput(DataCompParam param) {
        this.param = param;
        this.mapping = new DataCopyMapping(param.getDataCopyParam());
    }

    public DataCompParam getParam() {
        return this.param;
    }

    public DataCopyMapping getMapping() {
        return this.mapping;
    }

    public ObjectReader<Map<String, Object>> getTarReader(List<Map<String, Object>> filters, List<String> conditionFields) {
        return this.getObjectReader(this.param.getDataCopyParam().getTargetConnection(), this.param.getDataCopyParam().getTargetSchema(), filters, conditionFields);
    }

    public ObjectReader<Map<String, Object>> getSrcReader(List<Map<String, Object>> filters, List<String> conditionFields) {
        return this.getObjectReader(this.param.getDataCopyParam().getSourceConnection(), this.param.getDataCopyParam().getSourceSchema(), filters, conditionFields);
    }

    public Map<String, Object> readTarget(ObjectReader<? extends Map<String, Object>> tarReader) {
        Map<String, Object> data = (Map<String, Object>)tarReader.read();
        if (data != null) {
            data = CompUtil.dataRow2Map(data);
        }
        return data;
    }

    public Map<String, Object> readSource(ObjectReader<Map<String, Object>> srcReader) {
        Map<String, Object> data = this.read(srcReader);
        if (data != null) {
            data = CompUtil.dataRow2Map(data);
            this.decorate(data);
        }
        return data;
    }

    private synchronized Map<String, Object> read(ObjectReader<Map<String, Object>> srcReader) {
        return (Map)srcReader.read();
    }

    private void decorate(Map<String, Object> data) {
        SourceDataDecorator decorator = this.param.getDataCopyParam().getSourceDataDecorator();
        if (decorator == null) {
            return;
        }
        decorator.decorate(data, this.param.getDataCopyParam());
    }

    private ObjectReader<Map<String, Object>> getObjectReader(ConnectionWrapper cn, DynamicObject meta, List<Map<String, Object>> filters, List<String> conditionFields) {
        ObjectReader<Map<String, Object>> reader;
        MetaType metaType = MetaType.valueOf((String)meta.getString("type"));
        switch (metaType) {
            case ENTITY: {
                reader = this.executeEntityQuery(cn, meta, filters, conditionFields);
                break;
            }
            case TABLE: 
            case VIEW: {
                reader = this.executeJdbcQuery(cn, meta, filters, conditionFields);
                break;
            }
            case QUERY: {
                reader = this.executeApiQuery(cn, meta, filters);
                break;
            }
            default: {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a%s", (String)"DataCompInput_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), metaType.name()));
            }
        }
        return reader;
    }

    private ObjectReader<Map<String, Object>> executeEntityQuery(ConnectionWrapper cn, DynamicObject meta, List<Map<String, Object>> filters, List<String> conditionFields) {
        String entity = meta.getString("full_name");
        Map<String, Object> requires = this.getRequireFields(conditionFields);
        this.removeIgnoredItems(filters);
        return ConnectionManager.query(cn, entity, requires, filters, Collections.emptyList());
    }

    private ObjectReader<Map<String, Object>> executeJdbcQuery(ConnectionWrapper cn, DynamicObject meta, List<Map<String, Object>> filters, List<String> conditionFields) {
        Schema schema;
        String tableName;
        String metaType = this.getMetaType(meta).name();
        if (MetaType.TABLE.name().equals(metaType)) {
            tableName = D.s((Object)meta.get("table_name"));
            schema = ConnectionManager.getTable(cn, tableName);
        } else {
            schema = ViewUtil.getSchema(meta, cn);
            tableName = "(" + ViewUtil.getSQL(meta) + ") ISC_SOURCE_VIEW ";
        }
        ArrayList<Integer> types = new ArrayList<Integer>();
        ArrayList<Object> values = new ArrayList<Object>();
        String select = this.createSelect(schema, conditionFields);
        String filter = this.createFilter(schema, types, values, filters);
        String sql = this.getSqlStr(select, filter, tableName);
        long totalCount = cn.executeCount(sql, values, types);
        if (totalCount > Integer.MAX_VALUE) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u884c\u6570\u592a\u591a\uff08%s\uff09\uff0c\u4e0d\u652f\u6301\u6570\u636e\u5bf9\u6bd4\uff01", (String)"DataCompInput_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), totalCount));
        }
        if (totalCount > 0L) {
            return new TableObjectReader<DataRow>(cn.executeQuery(sql, values, types), (int)totalCount);
        }
        return new TableObjectReader<Map<String, Object>>((ObjectReader<Map<String, Object>>)new NullObjectReader(), (int)totalCount);
    }

    private MetaType getMetaType(DynamicObject meta) {
        return MetaType.valueOf((String)meta.getString("type"));
    }

    private ObjectReader<Map<String, Object>> executeApiQuery(ConnectionWrapper cn, DynamicObject meta, List<Map<String, Object>> filters) {
        Map data = Collections.EMPTY_MAP;
        Object result = ServiceUtil.callService(cn, meta, data, null);
        if (result instanceof ObjectReader) {
            ObjectReader reader = (ObjectReader)result;
            return DataCompInput.createFilterReader(reader, filters);
        }
        if (result instanceof Collection) {
            Collection list = (Collection)result;
            return DataCompInput.createFilterReader((ObjectReader)new ListAsReader(list), filters);
        }
        if (result == null) {
            throw new NullPointerException(String.format(ResManager.loadKDString((String)"\u670d\u52a1\uff08%s\uff09\u7684\u7ed3\u679c\u4e3a\u7a7a\uff01", (String)"DataCompInput_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), meta.get("number")));
        }
        throw new IllegalArgumentException(result.getClass().getName());
    }

    private String createFilter(Schema src_table, List<Integer> types, List<Object> values, List<Map<String, Object>> filter_collection) {
        StringBuilder filter = new StringBuilder();
        for (int i = 0; i < filter_collection.size(); ++i) {
            Map<String, Object> obj = filter_collection.get(i);
            filter.append(obj.get("filter_left_bracket"));
            Object value = obj.get("filter_value");
            if (DataCompInput.isIgnoredFilterItem(value)) {
                filter.append(" 1=1 ");
            } else {
                Column field = DataCompInput.getFilterField(src_table, D.s((Object)obj.get("filter_column")));
                filter.append(field.getBinding());
                if (value instanceof List) {
                    this.handleListTypeParam(filter, values, field, (List)value, types, D.s((Object)obj.get("filter_compare")));
                } else if (this.isArray(value)) {
                    List list = (List)JSON.parseObject((String)value.toString(), List.class);
                    this.handleListTypeParam(filter, values, field, list, types, D.s((Object)obj.get("filter_compare")));
                } else {
                    this.handleBaseTypeParam(filter, values, obj, field, value, types);
                }
            }
            filter.append(obj.get("filter_right_bracket"));
            if (i >= filter_collection.size() - 1) continue;
            filter.append("OR".equals(obj.get("filter_link")) ? " OR " : " AND ");
        }
        return filter.toString().trim();
    }

    private Map<String, Object> getRequireFields(List<String> conditionFields) {
        HashMap<String, Object> map = new HashMap<String, Object>(conditionFields.size());
        for (String field : conditionFields) {
            map.put(field, 1);
        }
        String pk = this.param.getDataCopyParam().getSourcePrimaryKey();
        if (pk != null && !map.containsKey(pk)) {
            map.put(pk, 1);
        }
        return map;
    }

    private static boolean isIgnoredFilterItem(Object value) {
        return "*".equals(value);
    }

    private boolean isArray(Object value) {
        return value instanceof String && value.toString().startsWith("[");
    }

    private static Column getFilterField(Schema table, String filterColumn) {
        return table.getField(filterColumn);
    }

    private void handleBaseTypeParam(StringBuilder filter, List<Object> values, Map<?, ?> obj, Column field, Object value, List<Integer> types) {
        CommonUtil.filterCompareHandle(filter, values, obj, field, value, types);
    }

    private void handleListTypeParam(StringBuilder filter, List<Object> values, Column field, List<?> list, List<Integer> types, String filter_compare) {
        String com = "not in".equalsIgnoreCase(filter_compare) ? "not in" : "in";
        filter.append(com);
        filter.append(" (");
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                filter.append(',');
            }
            filter.append('?');
            types.add(field.getSqlType());
            values.add(field.toSqlParam(list.get(i)));
        }
        filter.append(')');
    }

    private String getSqlStr(String select, String filter, String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append("select ").append(select);
        sb.append(" from ").append(tableName);
        if (filter.length() > 0) {
            sb.append(" where ").append(filter);
        }
        return sb.toString();
    }

    private String createSelect(Schema tableSchema, List<String> conditionFields) {
        StringBuilder select = new StringBuilder();
        HashSet<String> fieldSet = new HashSet<String>();
        for (String field : conditionFields) {
            if (field == null || field.indexOf(46) >= 0) continue;
            this.appendColumnFormMasterTable(tableSchema, select, fieldSet, field);
        }
        String primaryKeyName = tableSchema.getPrimaryKeyName();
        if (primaryKeyName != null) {
            this.appendColumnFormMasterTable(tableSchema, select, fieldSet, primaryKeyName);
        }
        return select.toString();
    }

    private void appendColumnFormMasterTable(Schema tableSchema, StringBuilder select, Set<String> fieldSet, String src) {
        Column field = tableSchema.getField(src);
        String binding = field.getBinding();
        if (!fieldSet.contains(binding)) {
            if (fieldSet.size() > 0) {
                select.append(", ");
            }
            select.append(binding);
        }
        fieldSet.add(binding);
    }

    private void removeIgnoredItems(List<Map<String, Object>> filter) {
        Iterator<Map<String, Object>> it = filter.iterator();
        while (it.hasNext()) {
            Map<String, Object> item = it.next();
            Object value = item.get("filter_value");
            if (!DataCompInput.isIgnoredFilterItem(value)) continue;
            it.remove();
        }
    }

    private static ObjectReader createFilterReader(ObjectReader reader, List<Map<String, Object>> filterFields) {
        if (filterFields.size() > 0) {
            reader = new MarkedReader(reader, new Filter(filterFields));
        }
        return reader;
    }

    public void dispose() {
        this.param.getDataCopyParam().dispose();
    }
}

