/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.datacomp;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.tx.TX;
import kd.bos.exception.KDException;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.connector.eas.Util;
import kd.isc.iscb.platform.core.datacomp.DataCompThread;
import kd.isc.iscb.platform.core.datacomp.param.Counter;
import kd.isc.iscb.platform.core.datacomp.param.DataCompParam;
import kd.isc.iscb.platform.core.datacomp.param.DataCompSchema;
import kd.isc.iscb.platform.core.datacomp.util.CompensateUtil;
import kd.isc.iscb.platform.core.datacomp.util.ResultType;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.HandledException;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Json2;
import kd.isc.iscb.util.misc.StringUtil;

public class DataCompTask
extends AbstractTask {
    private static final String DATA_SCOPE = "data_scope";
    private static final String TAR_NO_SYN_COUNT = "tar_no_syn_count";
    private static final String TAR_NO_EXIST_COUNT = "tar_no_exist_count";
    private static final String SOURCE_COUNT = "source_count";
    private static final String STATE_RUNNING = "R";
    private static final String SQL_EQUALS = "=";
    private static final String STATE = "state";
    private static final String PARAMS_ENTRYENTITY = "params_entryentity";
    private static final String PARAM_TYPE = "param_type";
    private static final String PARAM_TITLE = "param_title";
    private static final String PARAM_NAME = "param_name";
    private static final String STRATEGY = "strategy";
    private static final String DATA_COMP = "data_comp";
    private static final String ID = "id";
    private static final String ENTITY_ISC_DATA_COMP_EXE = "isc_data_comp_exe";
    private static final String NUMBER = "number";
    private static final int MAX_LENGTH = 290;
    private static Log logger = LogFactory.getLog(DataCompTask.class);

    public static DynamicObject create(DynamicObject dataComp, Map<String, Object> params, InitType type) {
        if (params == null && DataCompTask.findRunningExecutions(dataComp) != null) {
            logger.warn("datacomp is running. number=" + dataComp.get(NUMBER));
            return null;
        }
        return DataCompTask.createExe(dataComp, params, type);
    }

    public static DynamicObject createExe(DynamicObject dataComp, Map<String, Object> params, InitType type) {
        DynamicObject exe = DataCompTask.createDataCompExecution(dataComp, params, type);
        String message = "execution is created. number=" + exe.get(NUMBER) + ", id=" + exe.getPkValue() + ", dataComp =" + dataComp.get(NUMBER);
        logger.info(message);
        return exe;
    }

    private static DynamicObject createDataCompExecution(DynamicObject dataComp, Map<String, Object> params, InitType type) {
        DynamicObject exe = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ISC_DATA_COMP_EXE);
        String strategy = dataComp.getString(STRATEGY);
        exe.set(ID, (Object)DataCompTask.newId());
        exe.set(NUMBER, (Object)DataCompTask.generateExecutionNumber(dataComp));
        exe.set(DATA_COMP, (Object)dataComp);
        exe.set(STRATEGY, (Object)strategy);
        exe.set(STATE, (Object)"C");
        exe.set(SOURCE_COUNT, (Object)0);
        exe.set(TAR_NO_EXIST_COUNT, (Object)-1);
        exe.set(TAR_NO_SYN_COUNT, (Object)-1);
        exe.set("creator", (Object)RequestContext.get().getUserId());
        exe.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        exe.set(PARAMS_ENTRYENTITY, (Object)DataCompTask.createParams(dataComp, exe, params));
        exe.set(DATA_SCOPE, DataCompTask.createFilterParams(dataComp, exe, params));
        CommonUtil.check(OperationServiceHelper.executeOperate((String)"save", (String)ENTITY_ISC_DATA_COMP_EXE, (DynamicObject[])new DynamicObject[]{exe}, (OperateOption)OperateOption.create()));
        return exe;
    }

    private static long newId() {
        return IDService.get().genLongId(RequestContext.get().getTenantId(), ENTITY_ISC_DATA_COMP_EXE);
    }

    public static String generateExecutionNumber(DynamicObject dataComp) {
        String number = Hash.mur32((Object[])new Object[]{UUID.randomUUID()}).toUpperCase() + "-" + dataComp.get(NUMBER);
        if (number.length() > 30) {
            number = number.substring(0, 30);
        }
        return number;
    }

    private static DynamicObject findRunningExecutions(DynamicObject dataComp) {
        QFilter filter = new QFilter(DATA_COMP, SQL_EQUALS, dataComp.getPkValue()).and(new QFilter(STATE, SQL_EQUALS, (Object)STATE_RUNNING));
        return BusinessDataServiceHelper.loadSingle((String)ENTITY_ISC_DATA_COMP_EXE, (String)ID, (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObjectCollection createParams(DynamicObject dataComp, DynamicObject exe, Map<String, Object> params) {
        DynamicObjectCollection exeParamsEntries = exe.getDynamicObjectCollection(PARAMS_ENTRYENTITY);
        DynamicObjectCollection compParamsEntries = dataComp.getDynamicObjectCollection(PARAMS_ENTRYENTITY);
        exeParamsEntries.clear();
        for (DynamicObject t : compParamsEntries) {
            DynamicObject rowObj = exeParamsEntries.addNew();
            String name = t.getString(PARAM_NAME);
            rowObj.set(PARAM_NAME, (Object)name);
            rowObj.set(PARAM_TITLE, (Object)t.getString(PARAM_TITLE));
            rowObj.set(PARAM_TYPE, (Object)t.getString(PARAM_TYPE));
            Object value = params.get(name);
            if (value instanceof Collection || value instanceof Object[]) {
                rowObj.set("param_value", (Object)Json.toString((Object)value, (boolean)true));
                continue;
            }
            rowObj.set("param_value", value);
        }
        return exeParamsEntries;
    }

    public static Object createFilterParams(DynamicObject dataComp, DynamicObject exe, Map<String, Object> params) {
        DynamicObjectCollection exeParamsEntries = exe.getDynamicObjectCollection(DATA_SCOPE);
        DynamicObjectCollection compParamsEntries = dataComp.getDynamicObjectCollection(DATA_SCOPE);
        exeParamsEntries.clear();
        for (DynamicObject t : compParamsEntries) {
            DynamicObject rowObj = exeParamsEntries.addNew();
            rowObj.set("filter_left_bracket", (Object)t.getString("filter_left_bracket"));
            rowObj.set("filter_column", (Object)t.getString("filter_column"));
            rowObj.set("filter_label", (Object)t.getString("filter_label"));
            rowObj.set("filter_compare", (Object)t.getString("filter_compare"));
            rowObj.set("filter_value_var", (Object)t.getString("filter_value_var"));
            rowObj.set("filter_value_fixed", (Object)t.getString("filter_value_fixed"));
            rowObj.set("filter_right_bracket", (Object)t.getString("filter_right_bracket"));
            rowObj.set("filter_link", (Object)t.getString("filter_link"));
        }
        return exeParamsEntries;
    }

    public static void setFailed(DataCompParam param, Throwable error, boolean b) {
        Long id = D.l((Object)param.getExecutionId());
        DynamicObject execution = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_ISC_DATA_COMP_EXE);
        execution.set("end_time", (Object)new Date());
        DataCompTask.refreshCounter(param, execution, error);
        Util.save(execution);
    }

    public static DynamicObject createExecution(DynamicObject dataEntity) {
        DynamicObject exe = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ISC_DATA_COMP_EXE);
        exe.set(ID, (Object)DataCompTask.newId());
        exe.set(NUMBER, dataEntity.get(NUMBER));
        exe.set(DATA_COMP, dataEntity.get(DATA_COMP));
        Object strategy = dataEntity.get(STRATEGY);
        exe.set(STRATEGY, strategy);
        exe.set(STATE, dataEntity.get(STATE));
        exe.set(SOURCE_COUNT, (Object)0);
        if ("CheckExist".equals(strategy)) {
            exe.set(TAR_NO_EXIST_COUNT, (Object)-1);
        } else if ("CheckUpdate".equals(strategy)) {
            exe.set(TAR_NO_SYN_COUNT, (Object)-1);
        }
        exe.set("creator", (Object)RequestContext.get().getUserId());
        exe.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        exe.set(PARAMS_ENTRYENTITY, (Object)DataCompTask.createParams(dataEntity, exe));
        exe.set(DATA_SCOPE, DataCompTask.createFilterParams(dataEntity, exe, null));
        CommonUtil.check(OperationServiceHelper.executeOperate((String)"save", (String)ENTITY_ISC_DATA_COMP_EXE, (DynamicObject[])new DynamicObject[]{exe}, (OperateOption)OperateOption.create()));
        return exe;
    }

    private static DynamicObjectCollection createParams(DynamicObject dataComp, DynamicObject exe) {
        DynamicObjectCollection exeParamsEntries = exe.getDynamicObjectCollection(PARAMS_ENTRYENTITY);
        DynamicObjectCollection compParamsEntries = dataComp.getDynamicObjectCollection(PARAMS_ENTRYENTITY);
        exeParamsEntries.clear();
        for (DynamicObject t : compParamsEntries) {
            DynamicObject rowObj = exeParamsEntries.addNew();
            String name = t.getString(PARAM_NAME);
            rowObj.set(PARAM_NAME, (Object)name);
            rowObj.set(PARAM_TITLE, (Object)t.getString(PARAM_TITLE));
            rowObj.set(PARAM_TYPE, (Object)t.getString(PARAM_TYPE));
            rowObj.set("param_value", (Object)t.getString("param_value"));
        }
        return exeParamsEntries;
    }

    public void execute(RequestContext ctx, Map<String, Object> params) throws KDException {
    }

    public static void start(DynamicObject execution) {
        long id = D.l((Object)execution.getPkValue());
        JobEngine.submit(new DataCompThread(id));
        logger.info("execution is submitted. number=" + execution.get(NUMBER));
    }

    public static void setSuccess(DataCompParam param) {
        String executionId = param.getExecutionId();
        DynamicObject execution = BusinessDataServiceHelper.loadSingle((Object)executionId, (String)ENTITY_ISC_DATA_COMP_EXE);
        execution.set("end_time", (Object)new Date());
        DataCompTask.refreshCounter(param, execution, param.getCounter().getSrc_Duplicate_Count() <= 0 ? null : new IscBizException(ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\u6e90\u5355\u5b58\u5728\u591a\u884c\u5019\u9009\u952e\u76f8\u540c\u7684\u6570\u636e\uff01", (String)"DataCompTask_9", (String)"isc-iscb-platform-core", (Object[])new Object[0])));
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String sql = "UPDATE T_ISC_DATA_COMP_EXE SET fmodifytime=?,  fend_time=?, fstate=?, fsource_count=?, ftar_no_exist_count=?,ftar_no_syn_count=?, ftar_no_same_count=?  WHERE fid= ? ";
        Counter counter = param.getCounter();
        List<Object> values = Arrays.asList(now, now, execution.getString(STATE), counter.getTotal_count(), counter.getNot_exist_count(), counter.getNot_update_count(), counter.getNot_same_count(), executionId);
        List<Integer> types = Arrays.asList(93, 93, 12, 4, 4, 4, 4, -5);
        try {
            DataCompTask.executeUpdate(sql, values, types);
        }
        catch (Exception e) {
            DataCompTask.executeUpdate(sql, values, types);
        }
        DataCompTask.executeDataSyn(param, execution);
    }

    private static void executeDataSyn(DataCompParam param, DynamicObject execution) {
        boolean flag = param.isFlag();
        if (flag) {
            DynamicObject compensateSchema = param.getCompensateSchema();
            String executionId = execution.getString(ID);
            if (compensateSchema != null) {
                Object schemaId = compensateSchema.getPkValue();
                CompensateUtil.dataCompensate(executionId, schemaId, null, param.getCounter());
            } else {
                DynamicObject data_comp = execution.getDynamicObject(DATA_COMP);
                DynamicObject comp = DataCompSchema.get(data_comp.getLong(ID));
                Object data_copy_id = comp.get("data_copy_id");
                CompensateUtil.dataCompensate(executionId, data_copy_id, null, param.getCounter());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeUpdate(String sql, List<Object> values, List<Integer> types) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private static void refreshCounter(DataCompParam param, DynamicObject execution, Throwable error) {
        Counter counter = param.getCounter();
        int totalCount = counter.getTotal_count();
        execution.set(SOURCE_COUNT, (Object)totalCount);
        int notExistCount = counter.getNot_exist_count();
        execution.set(TAR_NO_EXIST_COUNT, (Object)notExistCount);
        int notUpdateCount = counter.getNot_update_count();
        execution.set(TAR_NO_SYN_COUNT, (Object)notUpdateCount);
        if (error != null) {
            execution.set(STATE, (Object)(error instanceof TaskCancelException ? "X" : "F"));
        } else {
            boolean b;
            boolean bl = b = D.l((Object)totalCount) == D.l((Object)notExistCount) + D.l((Object)notUpdateCount);
            if (D.l((Object)totalCount) == 0L) {
                execution.set(STATE, (Object)Character.valueOf('S'));
            } else if (b) {
                execution.set(STATE, (Object)Character.valueOf('N'));
            } else if (D.l((Object)notExistCount) == 0L && D.l((Object)notUpdateCount) == 0L) {
                execution.set(STATE, (Object)Character.valueOf('S'));
            } else {
                execution.set(STATE, (Object)Character.valueOf('P'));
            }
        }
    }

    public static DynamicObject saveErrorLog(DataCompParam param, Throwable error, Map<String, Object> src, Map<String, Object> tar, Map<String, Object> expTar, ResultType type) {
        if (error instanceof HandledException) {
            return null;
        }
        if (src == null && error == null) {
            return null;
        }
        try {
            String s = error != null ? String.format(ResManager.loadKDString((String)"\u5931\u8d25! %s", (String)"DataCompTask_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), StringUtil.toString((Throwable)error)) : type.getDescription();
            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"isc_data_comp_exe_det");
            log.set("data_comp_exe", (Object)param.getExecutionId());
            log.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
            Object value = null;
            if (src != null) {
                value = src.get(param.getDataCopyParam().getSourcePrimaryKey());
            }
            log.set("src_pk", value);
            if (error == null) {
                log.set("compensate_state", (Object)"N");
            }
            log.set("message", (Object)StringUtil.trim((String)s, (int)100));
            log.set("message_tag", s != null && s.length() > 290 ? s : null);
            DataCompTask.writeDataToLog(src, log, "source_data", "source_data_tag");
            DataCompTask.writeDataToLog(tar, log, "real_data", "real_data_tag");
            DataCompTask.writeDataToLog(expTar, log, "target_data", "target_data_tag");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
            return log;
        }
        catch (Throwable e) {
            logger.warn(e);
            return null;
        }
    }

    private static void writeDataToLog(Map<String, Object> data, DynamicObject log, String field, String field_tag) {
        if (data == null) {
            log.set(field, (Object)"");
            log.set(field_tag, (Object)"");
        } else {
            String json = Json.toString(data);
            log.set(field, (Object)StringUtil.trim((String)json, (int)100));
            if (json.length() > 100) {
                log.set(field_tag, (Object)Json2.toString(data));
            }
        }
    }

    public static enum InitType {
        API_ASYN(new MultiLangEnumBridge("API_\u5f02\u6b65", "DataCompTask_0", "isc-iscb-platform-core")),
        API_SYNC(new MultiLangEnumBridge("API_\u540c\u6b65", "DataCompTask_1", "isc-iscb-platform-core")),
        PUSH(new MultiLangEnumBridge("\u63a8\u9001", "DataCompTask_2", "isc-iscb-platform-core")),
        TIMER(new MultiLangEnumBridge("\u5b9a\u65f6", "DataCompTask_3", "isc-iscb-platform-core")),
        MANUAL(new MultiLangEnumBridge("\u4eba\u5de5", "DataCompTask_4", "isc-iscb-platform-core")),
        MANUAL_COM(new MultiLangEnumBridge("\u4eba\u5de5\u8865\u507f", "DataCompTask_5", "isc-iscb-platform-core")),
        POST(new MultiLangEnumBridge("\u540e\u7f6e", "DataCompTask_6", "isc-iscb-platform-core")),
        SF_ASYN(new MultiLangEnumBridge("\u670d\u52a1\u7f16\u6392_\u5f02\u6b65", "DataCompTask_7", "isc-iscb-platform-core")),
        SF_SYNC(new MultiLangEnumBridge("\u670d\u52a1\u7f16\u6392_\u540c\u6b65", "DataCompTask_8", "isc-iscb-platform-core"));

        private MultiLangEnumBridge description;

        private InitType(MultiLangEnumBridge description) {
            this.description = description;
        }

        public String toString() {
            return this.description.loadKDString();
        }
    }
}

