/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.datacomp.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.platform.core.datacomp.DataCompInput;
import kd.isc.iscb.platform.core.datacomp.DataCompTask;
import kd.isc.iscb.platform.core.datacomp.util.ResultType;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Pair;

public class CompUtil {
    private static final String IGNORE_TAG = "#_IGNORE_TAG";

    public static Map<String, Object> dataRow2Map(Map<String, Object> data) {
        if (data instanceof DataRow) {
            data = ((DataRow)data).toMap();
        }
        return data;
    }

    public static List<Map<String, Object>> batchFilter(List<Pair<Map<String, Object>, Map<String, Object>>> buffer, String tarCandidateKey) {
        StringBuilder sb = new StringBuilder(buffer.size());
        sb.append('[');
        for (Pair<Map<String, Object>, Map<String, Object>> pair : buffer) {
            Map map = (Map)pair.getB();
            sb.append('\'');
            sb.append(map.get(tarCandidateKey));
            sb.append('\'');
            sb.append(',');
        }
        sb.delete(sb.length() - 1, sb.length());
        sb.append(']');
        HashMap<String, String> item = new HashMap<String, String>();
        item.put("filter_left_bracket", "");
        item.put("filter_column", tarCandidateKey);
        item.put("filter_compare", "in");
        item.put("filter_value", sb.toString());
        item.put("filter_right_bracket", "");
        item.put("filter_link", "");
        return Collections.singletonList(item);
    }

    public static void saveCompLogs(DataCompInput input, Object object, Map<Object, Map<String, Object>> expMap, ResultType type, Throwable e) {
        block3: {
            block2: {
                if (!(object instanceof Map)) break block2;
                Map map = (Map)object;
                for (Map.Entry mapEntry : map.entrySet()) {
                    Object key = mapEntry.getKey();
                    Map srcMap = (Map)mapEntry.getValue();
                    CompUtil.saveCompLog(input, srcMap, null, expMap.get(key), type, e);
                }
                break block3;
            }
            if (!(object instanceof List)) break block3;
            List list = (List)object;
            for (Pair mapMapPair : list) {
                Map srcMap = (Map)mapMapPair.getA();
                Map tarMap = (Map)mapMapPair.getB();
                CompUtil.saveCompLog(input, srcMap, null, tarMap, type, e);
            }
        }
    }

    public static void saveCompLog(DataCompInput input, Map<String, Object> src, Map<String, Object> tar, Map<String, Object> expTar, ResultType type, Throwable e) {
        if (src != null) {
            src.remove("$pk");
            src.remove("$id");
        }
        if (tar != null) {
            tar.remove("$id");
            tar.remove("$pk");
        }
        DataCompTask.saveErrorLog(input.getParam(), e, src, tar, expTar, type);
    }

    public static List<Map<String, Object>> assignTarCandidateKey(Map<String, Object> src, List<String> tarCandidateKey) {
        ArrayList<Map<String, Object>> filter = new ArrayList<Map<String, Object>>(tarCandidateKey.size());
        int s = 1;
        for (String key : tarCandidateKey) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("filter_left_bracket", "");
            item.put("filter_column", key);
            item.put("filter_compare", "=");
            item.put("filter_value", src.get(key));
            item.put("filter_right_bracket", "");
            if (s++ < tarCandidateKey.size()) {
                item.put("filter_link", " AND ");
            }
            filter.add(item);
        }
        return filter;
    }

    public static boolean isIgnored(Map<String, Object> data) {
        return D.x((Object)data.get(IGNORE_TAG));
    }
}

