/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ischub.EventUtil;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.util.DblinkMessageUtil;
import kd.isc.iscb.util.dt.D;

public class DataBaseLinkStateMonitor
implements Task {
    private static Log logger = LogFactory.getLog(DataBaseLinkStateMonitor.class);
    private String id;

    DataBaseLinkStateMonitor(String accountId) {
        this.id = "M:" + accountId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void run() {
        if (!JobEngine.isMaster()) {
            ScheduleManager.submit((Task)this, 60);
            return;
        }
        try {
            logger.warn("\u5f00\u59cb\u6267\u884c\u8fde\u63a5\u914d\u7f6e\u68c0\u6d4b\u3002");
            this.executeTestLinks();
        }
        finally {
            ScheduleManager.submit((Task)this, 900);
        }
    }

    public void executeTestLinks() {
        DynamicObject[] dataBaseLinks;
        for (DynamicObject dataBaseLink : dataBaseLinks = BusinessDataServiceHelper.load((String)"isc_database_link", (String)"id,state", (QFilter[])new QFilter[0])) {
            String state = "S";
            DynamicObject dblink = BusinessDataServiceHelper.loadSingle((Object)dataBaseLink.getLong("id"), (String)"isc_database_link");
            Throwable error = null;
            try {
                ConnectionManager.test(D.l((Object)dataBaseLink.getPkValue()));
            }
            catch (Throwable e) {
                state = "F";
                DblinkMessageUtil.checkAndSendMessage(dblink, e);
                error = e;
            }
            if (!state.equals(dataBaseLink.getString("state"))) {
                logger.info("\u8fde\u63a5\u3010" + dataBaseLink.getString("number") + "\u3011\u5f53\u524d\u72b6\u6001\uff1a" + state + ",\u4e0a\u6b21\u72b6\u6001\uff1a" + dataBaseLink.getString("state") + ",\u89e6\u53d1HUB\u4e8b\u4ef6");
                dataBaseLink.set("state", (Object)state);
                SaveServiceHelper.update((DynamicObject)dataBaseLink);
                this.saveHubEvent(state, dblink, error);
                continue;
            }
            logger.info("\u8fde\u63a5\u3010" + dataBaseLink.getString("number") + "\u3011\u72b6\u6001" + dataBaseLink.getString("state") + ",\u6ca1\u53d1\u751f\u53d8\u5316\uff0c\u6545\u5ffd\u7565HUB\u4e8b\u4ef6");
        }
    }

    private void saveHubEvent(String state, DynamicObject dblink, Throwable error) {
        try {
            String action = "S".equals(state) ? "valid" : "invalid";
            EventUtil.saveDsTriggerEventLog(action, dblink, error);
        }
        catch (Throwable e) {
            logger.error("\u4fdd\u5b58\u96c6\u6210\u4e91HUB\u4e8b\u4ef6\u5931\u8d25:", e);
        }
    }
}

