/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.dc.IscExceptionLog;
import kd.isc.iscb.platform.core.log.es.EsLogUtil;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Pair;

public class DataCopyLogCleanTask
extends AbstractTask {
    private static final String FSTART_TIME = "fstart_time";
    private static final String FCREATETIME = "fcreatetime";
    private static final String FMODIFYTIME = "FMODIFYTIME";
    private static final String FUPDATED_TIME = "fupdated_time";
    private static final String FEND_TIME = "fend_time";
    private static final String FMODIFIED_TIME = "fmodified_time";
    private static final String FRECEIVED_TIME = "freceived_time";
    private static final String FPUBLISHED_TIME = "fpublished_time";
    private static final String FCREATED_TIME = "fcreated_time";
    private static final String FRECORD_TIME = "frecord_time";
    private static final String FTIME = "ftime";
    private static Log logger = LogFactory.getLog(DataCopyLogCleanTask.class);
    private static int DELETE_BATCH_SIZE = 500;
    private static Map<String, Pair<String, String>> logTables = new LinkedHashMap<String, Pair<String, String>>();
    private static Set<String> needDelMultiTable = new HashSet<String>();
    private static final String T_ISC_DATA_COPY_EXECUTION = "t_isc_data_copy_execution";
    private static final String T_ISC_DC_EXECUTION_PARAMS = "t_isc_dc_execution_params";
    private static final String T_DBC_TABLE_COPY_LOG = "t_dbc_table_copy_log";
    private static final String T_DBC_TC_LOG_ITEMS = "t_dbc_tc_log_items";
    private boolean isEsEnabled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext ctx, Map<String, Object> params) throws KDException {
        this.isEsEnabled = EsLogUtil.isElasticEnabled();
        logger.info(String.format("\u6267\u884c\u96c6\u6210\u4e912.0\u65e5\u5fd7\u5b9a\u65f6\u81ea\u52a8\u6e05\u7406\uff0c\u5f53\u524d\u65f6\u95f4\uff1a%s", LocalDateTime.now().toString()));
        RequestContextCreator.restoreForMQ((RequestContext)ctx);
        int keepDays = Math.max(D.i((Object)params.get("keep_days")), 1);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            int eventCount = EventBindingUtil.removeLog((Connection)cn, (int)keepDays, null);
            logger.info(String.format("\u96c6\u6210\u4e91\u65e5\u5fd7\u6e05\u7406\u5b8c\u6210, %d\u6761\u4e8b\u4ef6\u89e6\u53d1\u65e5\u5fd7", eventCount));
        }
        catch (Exception e) {
            logger.warn("\u96c6\u6210\u670d\u52a1\u4e91\u65e5\u5fd7\u6e05\u7406\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
        this.innerRemoveOperationLogs();
        this.innerRemoveLogs(keepDays);
        this.innerRemoveProcInstLogs(keepDays);
        this.cleanEASEventLog(keepDays);
        this.cleanCustomInfos(3, "isc_biz_trace", "t_iscb_biz_trace_tree", FSTART_TIME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerRemoveProcInstLogs(int keepDays) {
        logger.info("\u5f00\u59cb\u6e05\u7406\u96c6\u6210\u4e91\u8868t_isc_sf_proc_inst\u65e5\u5fd7\u3002");
        long now = System.currentTimeMillis();
        Timestamp value = new Timestamp(now - (long)keepDays * 86400000L);
        int type = 93;
        try {
            int count;
            Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
            try {
                count = this.loopDeleteInstLog(cn, value, type);
            }
            finally {
                DbUtil.close((Connection)cn);
            }
            logger.info("\u6210\u529f\u6e05\u7406\u8868t_isc_sf_proc_inst\u65e5\u5fd7" + count + "\u6761;");
        }
        catch (Throwable e) {
            logger.warn("\u96c6\u6210\u670d\u52a1\u4e91\u6d41\u7a0b\u5b9e\u4f8b\u6e05\u7406\u53d1\u751f\u5f02\u5e38", e);
        }
    }

    private int loopDeleteInstLog(Connection cn, Timestamp value, int type) {
        int deleted;
        List<Object> values = Collections.singletonList(value);
        List<Integer> types = Collections.singletonList(type);
        int sum = 0;
        int delete_size = this.getDeleteSize();
        do {
            String sql = "SELECT top " + delete_size + " fid FROM t_isc_sf_proc_inst WHERE fstate in ('Failed','Complete','Terminated','Ignored') and fmodified_time < ? ";
            deleted = this.deleteTop500(cn, "t_isc_sf_proc_inst", sql, false, values, types);
            sum += deleted;
        } while (deleted >= delete_size);
        return sum;
    }

    private int getDeleteSize() {
        int delete_size = D.i((Object)ContextUtil.getTenantProperty("isc_proc_delete_size"));
        delete_size = delete_size == 0 ? 100 : delete_size;
        delete_size = Math.max(delete_size, 1);
        return delete_size;
    }

    private void cleanCustomInfos(int keepDays, String entityName, String tableName, String timeField) {
        long now = System.currentTimeMillis();
        Timestamp value = new Timestamp(now - (long)keepDays * 86400000L);
        int type = 93;
        try {
            int count = this.deleteLog(value, type, tableName, timeField, needDelMultiTable.contains(tableName));
            logger.info("\u6210\u529f\u6e05\u7406\u96c6\u6210\u670d\u52a1\u4e91\u8868 " + tableName + " \u6570\u636e" + count + "\u6761;");
        }
        catch (Exception e) {
            logger.warn("\u96c6\u6210\u670d\u52a1\u4e91\u65e5\u5fd7\u4fe1\u606f\u6e05\u7406\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
    }

    private void innerRemoveOperationLogs() {
        long now = System.currentTimeMillis();
        Timestamp value = new Timestamp(now - 2592000000L);
        int type = 93;
        try {
            String table = "t_isc_operation_log";
            int count = this.deleteLog(value, type, table, FCREATED_TIME, needDelMultiTable.contains(table));
            logger.info("\u6210\u529f\u6e05\u7406\u8868" + table + "\u65e5\u5fd7" + count + "\u6761;");
        }
        catch (Exception e) {
            logger.warn("\u96c6\u6210\u670d\u52a1\u4e91\u64cd\u4f5c\u65e5\u5fd7\u6e05\u7406\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
    }

    private void innerRemoveLogs(int keepDays) {
        keepDays = this.isEsEnabled ? EsLogUtil.getDbLogMaxExistedDays() : keepDays;
        long now = System.currentTimeMillis();
        Timestamp value = new Timestamp(now - (long)keepDays * 86400000L);
        int type = 93;
        try {
            for (Map.Entry<String, Pair<String, String>> entry : logTables.entrySet()) {
                String table = entry.getKey();
                if ("t_isc_operation_log".equals(table) || "t_iscb_biz_trace_tree".equals(table) || "t_isc_sf_proc_inst".equals(table)) continue;
                String field = (String)entry.getValue().getA();
                logger.info("\u5f00\u59cb\u6e05\u7406\u8868" + table + "--" + keepDays + "\u5929\u524d\u7684\u65e5\u5fd7");
                int count = this.deleteLog(value, type, table, field, needDelMultiTable.contains(table));
                logger.info("\u6210\u529f\u6e05\u7406\u8868" + table + "\u65e5\u5fd7" + count + "\u6761;");
            }
            logger.info("\u96c6\u6210\u670d\u52a1\u4e91\u65e5\u5fd7\u6e05\u7406\u5b8c\u6210.");
            IscExceptionLog.delete("CLEAR_LOG_EX", 1L);
        }
        catch (Exception e) {
            logger.warn("\u96c6\u6210\u670d\u52a1\u4e91\u65e5\u5fd7\u6e05\u7406\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            IscExceptionLog.save("CLEAR_LOG_EX", 1L, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanEASEventLog(int keepDays) {
        QFilter filter = new QFilter("database_type", "=", (Object)"eas").and(new QFilter("state", "=", (Object)"S"));
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"isc_database_link", (String)"id,number", (QFilter[])new QFilter[]{filter}, (String)"modifytime desc");
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("keep_days", keepDays);
        for (DynamicObject row : objects) {
            ConnectionManager.pushResLicense(true);
            try {
                Long id = row.getLong("id");
                ConnectionWrapper cn = ConnectionManager.getConnection(id);
                params.put("isc_hub", ConnectorUtil.getIscHub(row));
                int count = cn.getFactory().removeLogs(cn, params);
                logger.info("\u6e05\u9664EAS\u8fde\u63a5\uff08" + row.getString("number") + "\uff09\u7684\u89e6\u53d1\u65e5\u5fd7" + count + "\u884c.");
            }
            catch (Exception e) {
                logger.warn("EAS\u8fde\u63a5\uff08" + row.getString("number") + "\uff09\u65e5\u5fd7\u6e05\u7406\u5931\u8d25", (Throwable)e);
            }
            finally {
                ConnectionManager.popResLicense();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteLog(Object value, int type, String tableName, String indexField, boolean containMultiLang) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            int n = this.loopDeleteLog(cn, tableName, indexField, containMultiLang, value, type);
            return n;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private int loopDeleteLog(Connection cn, String tableName, String indexField, boolean containMultiLang, Object value, int type) {
        int deleted;
        List<Object> values = Collections.singletonList(value);
        List<Integer> types = Collections.singletonList(type);
        int sum = 0;
        do {
            String sql = "SELECT top " + DELETE_BATCH_SIZE + " fid FROM " + tableName + " WHERE " + indexField + " < ? ";
            deleted = this.deleteTop500(cn, tableName, sql, containMultiLang, values, types);
            sum += deleted;
        } while (deleted >= DELETE_BATCH_SIZE);
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteTop500(Connection cn, String tableName, String sql, boolean containMultiLang, List<Object> values, List<Integer> types) {
        ObjectReader reader = DbUtil.executeQuery((Connection)cn, (String)sql, values, types);
        try {
            ArrayList<Object> ids = new ArrayList<Object>(500);
            ArrayList<Integer> idTypes = new ArrayList<Integer>(500);
            StringBuilder whereSql = this.generateWhereSql(idTypes, (ObjectReader<DataRow>)reader, ids);
            if (ids.isEmpty()) {
                int n = 0;
                return n;
            }
            if (this.isEsEnabled) {
                EsLogUtil.migrateDynamicObjToEs((String)logTables.get(tableName).getB(), ids);
            }
            String removeSql = null;
            if (containMultiLang) {
                removeSql = this.generateRemoveSql(tableName + "_l", whereSql);
                DbUtil.executeUpdate((Connection)cn, (String)removeSql, ids, idTypes);
            }
            if (T_ISC_DATA_COPY_EXECUTION.equals(tableName)) {
                removeSql = this.generateRemoveSql(T_ISC_DC_EXECUTION_PARAMS, whereSql);
                DbUtil.executeUpdate((Connection)cn, (String)removeSql, ids, idTypes);
            }
            if (T_DBC_TABLE_COPY_LOG.equals(tableName)) {
                removeSql = this.generateRemoveSql(T_DBC_TC_LOG_ITEMS, whereSql);
                DbUtil.executeUpdate((Connection)cn, (String)removeSql, ids, idTypes);
            }
            removeSql = this.generateRemoveSql(tableName, whereSql);
            int count = DbUtil.executeUpdate((Connection)cn, (String)removeSql, ids, idTypes);
            this.commit(cn);
            int n = count;
            return n;
        }
        finally {
            DbUtil.close((ObjectReader)reader);
        }
    }

    private void commit(Connection cn) {
        try {
            if (cn != null && !cn.getAutoCommit()) {
                cn.commit();
            }
        }
        catch (SQLException e) {
            throw DatabaseError.TRANS_COMMIT_FAILURE.wrap((Throwable)e);
        }
    }

    private String generateRemoveSql(String tableName, StringBuilder whereSql) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ").append(tableName).append((CharSequence)whereSql);
        return sql.toString();
    }

    private StringBuilder generateWhereSql(List<Integer> types, ObjectReader<DataRow> reader, List<Object> ids) {
        StringBuilder where = new StringBuilder(" WHERE fid in(");
        DataRow row = (DataRow)reader.read();
        while (row != null) {
            if (!ids.isEmpty()) {
                where.append(',');
            }
            ids.add(row.get((Object)"fid"));
            where.append('?');
            types.add(-5);
            row = (DataRow)reader.read();
        }
        where.append(')');
        return where;
    }

    static void cleanTables() {
        logTables.clear();
    }

    static {
        logTables.put("t_iscb_bill_log_relation", (Pair<String, String>)new Pair((Object)FTIME, (Object)"isc_bill_log_relation"));
        logTables.put("t_isc_data_copy_exec_log", (Pair<String, String>)new Pair((Object)FCREATED_TIME, (Object)"isc_data_copy_exec_log"));
        logTables.put("t_iscb_mq_data_published", (Pair<String, String>)new Pair((Object)FPUBLISHED_TIME, (Object)"isc_mq_data_published"));
        logTables.put("t_iscb_mq_data_received", (Pair<String, String>)new Pair((Object)FRECEIVED_TIME, (Object)"isc_mq_data_received"));
        logTables.put("t_iscb_biz_execution", (Pair<String, String>)new Pair((Object)FCREATED_TIME, (Object)"isc_mq_bill_data_task"));
        logTables.put("t_isc_sf_proc_log", (Pair<String, String>)new Pair((Object)FCREATED_TIME, (Object)"isc_sf_proc_log"));
        logTables.put("t_isc_sf_proc_inst", (Pair<String, String>)new Pair((Object)FMODIFIED_TIME, (Object)"isc_sf_proc_inst"));
        logTables.put("T_ISCB_DATA_TS_LOG", (Pair<String, String>)new Pair((Object)FTIME, (Object)"isc_data_ts_log"));
        logTables.put("t_iscb_apic_log", (Pair<String, String>)new Pair((Object)FEND_TIME, (Object)"isc_apic_log"));
        logTables.put("t_isc_call_api_log", (Pair<String, String>)new Pair((Object)FEND_TIME, (Object)"isc_call_api_log"));
        logTables.put("t_isc_attach_log", (Pair<String, String>)new Pair((Object)FUPDATED_TIME, (Object)"isc_attachment_log"));
        logTables.put(T_ISC_DATA_COPY_EXECUTION, (Pair<String, String>)new Pair((Object)FMODIFYTIME, (Object)"isc_data_copy_execution"));
        logTables.put("t_isc_data_copy_taskstage", (Pair<String, String>)new Pair((Object)FMODIFYTIME, (Object)"isc_data_copy_taskstage"));
        logTables.put("t_isc_mq_starter_log", (Pair<String, String>)new Pair((Object)FRECEIVED_TIME, (Object)"isc_mq_starter_log"));
        logTables.put("t_isc_data_comp_exe_det", (Pair<String, String>)new Pair((Object)FCREATETIME, (Object)"isc_data_comp_exe_det"));
        logTables.put("t_iscb_biz_trace_tree", (Pair<String, String>)new Pair((Object)FSTART_TIME, (Object)"isc_biz_trace"));
        logTables.put("t_isc_sf_waiting_data", (Pair<String, String>)new Pair((Object)FCREATED_TIME, (Object)"isc_sf_waiting_data"));
        logTables.put("t_isc_operation_log", (Pair<String, String>)new Pair((Object)FCREATED_TIME, (Object)"isc_operation_log"));
        logTables.put("t_isc_res_consume_stat", (Pair<String, String>)new Pair((Object)FRECORD_TIME, (Object)"isc_res_consume_stat"));
        logTables.put(T_DBC_TABLE_COPY_LOG, (Pair<String, String>)new Pair((Object)FCREATETIME, (Object)"dbc_table_copy_log"));
        needDelMultiTable.add(T_ISC_DATA_COPY_EXECUTION);
        needDelMultiTable.add("t_isc_data_copy_taskstage");
    }
}

