/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.dc.DataCopyJob;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.dc.DataCopyTaskState;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class DataCopyTaskMonitor
implements Task {
    private static final int INTERVAL = 1200000;
    private String id;
    private int offset1 = 86400000;
    private final int offset2 = 1200000;
    private static Log logger = LogFactory.getLog(DataCopyTask.class);

    DataCopyTaskMonitor(String accountId) {
        this.id = "M:" + accountId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.isNotReady()) {
            return;
        }
        if (!JobEngine.isMaster()) {
            ScheduleManager.submit((Task)this, 60);
            return;
        }
        boolean exit = false;
        try {
            long now = System.currentTimeMillis();
            Timestamp lbound = new Timestamp(now - (long)this.offset1);
            Timestamp ubound = new Timestamp(now - 1200000L);
            List<DataRow> list = DataCopyTaskMonitor.searchInactiveTasks(lbound, ubound);
            DataCopyTaskMonitor.loadInactiveTasks(list);
        }
        catch (Throwable e) {
            logger.warn("DataCopyTaskMonitor failed.", e);
            String message = e.getMessage();
            if (message != null) {
                exit = message.contains("doesn't exist") || message.contains("unknown");
            }
        }
        finally {
            if (!exit) {
                this.offset1 = 0x6DDD00;
                ScheduleManager.submit((Task)this, 1200);
            }
        }
    }

    private static void loadInactiveTasks(List<DataRow> list) {
        int count = 0;
        for (DataRow e : list) {
            long executionId = D.l((Object)e.get((Object)"fid"));
            if (JobEngine.existsJobWithOwnerId(executionId)) continue;
            boolean first = true;
            if ("R".equals(e.get((Object)"fstate"))) {
                DataCopyTaskState.restoreState(executionId);
                first = false;
            }
            String number = (String)e.get((Object)"fnumber");
            JobEngine.submit(new DataCopyJob(number, false, executionId, first, D.l((Object)e.get((Object)"fjob_mutex"))));
            ++count;
        }
        if (count > 0) {
            logger.info(count + " tasks reloaded.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNotReady() {
        boolean bl;
        Connection cn = null;
        try {
            String sql = "select count(*) as c from KSQL_USERTABLES WHERE KSQL_TABNAME='T_ISC_DATA_COPY_EXECUTION'";
            cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
            bl = D.i((Object)DbUtil.executeScalar((Connection)cn, (String)sql)) == 0;
        }
        catch (Throwable throwable) {
            DbUtil.close(cn, (boolean)false);
            throw throwable;
        }
        DbUtil.close((Connection)cn, (boolean)false);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<DataRow> searchInactiveTasks(Timestamp startTime, Timestamp endTime) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            String sql = "SELECT fid,fstate,fnumber,fjob_mutex FROM T_ISC_DATA_COPY_EXECUTION  WHERE fstate in ('R','C') and fmodifytime > ? and fmodifytime < ? ORDER BY fstate DESC";
            List list = DbUtil.executeList((Connection)cn, (String)sql, Arrays.asList(startTime, endTime), Arrays.asList(93, 93));
            return list;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
    }
}

