/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.id.IDService;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.dc.DataCopyTaskStageNotify;
import kd.isc.iscb.platform.core.dc.e.DataCopyInput;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.platform.core.task.LightTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.task.TaskManager;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.io.Counter;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.trace.TraceTask;

public class DataCopyTaskStage {
    private static final String FILTER_RIGHT_BRACKET = "filter_right_bracket";
    private static final String FILTER_LINK = "filter_link";
    private static final String FILTER_COLUMN = "filter_column";
    private static final String FILTER_VALUE = "filter_value";
    private static final String FILTER_LEFT_BRACKET = "filter_left_bracket";
    private static final String FILTER_COMPARE = "filter_compare";
    private static final String MODIFYTIME = "modifytime";
    private static final String TOTAL_FAILED = "total_failed";
    private static final String TOTAL_SUCCESS = "total_success";
    private static final String TOTAL_BATCH = "total_batch";
    private static final String TOTAL_COUNT = "total_count";
    private static final String STATE = "state";
    private static final String ENTITY_ISC_DATA_COPY_TASKSTAGE = "isc_data_copy_taskstage";
    private static Log logger = LogFactory.getLog(DataCopyTaskStage.class);
    public static final String TASK_STAGE = "$is_filter";
    public static final String ARRAY = "$filter_items";
    private static ThreadLocal<Object> currentBatchID = new ThreadLocal();

    public static DynamicObject create(DynamicObject trigger) {
        final DynamicObject exe = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ISC_DATA_COPY_TASKSTAGE);
        long bachId = IDService.get().genLongId();
        String number = DataCopyTask.generateExecutionNumber(trigger);
        exe.set("id", (Object)bachId);
        exe.set("number", (Object)number);
        exe.set("name", (Object)DataCopyTaskStage.generateTaskStageName(trigger));
        exe.set("data_trigger", (Object)trigger);
        exe.set("data_copy", trigger.get("data_copy"));
        exe.set("status", (Object)"C");
        exe.set(STATE, (Object)"C");
        exe.set(MODIFYTIME, (Object)new Timestamp(System.currentTimeMillis()));
        exe.set("host", (Object)Instance.getInstanceId());
        exe.set("begin_time", (Object)new Timestamp(System.currentTimeMillis()));
        exe.set("enable", (Object)"1");
        exe.set(TOTAL_COUNT, (Object)-1);
        exe.set(TOTAL_BATCH, (Object)-1);
        exe.set(TOTAL_SUCCESS, (Object)-1);
        exe.set(TOTAL_FAILED, (Object)-1);
        exe.set("creator", (Object)RequestContext.get().getUserId());
        exe.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        TraceStack.run(TraceType.NEW_DCB, number, bachId, new TraceTask(){

            public void run() {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{exe});
            }
        });
        return exe;
    }

    public static String generateTaskStageName(DynamicObject trigger) {
        String name = D.s((Object)trigger.get("name"));
        if (name.length() > 50) {
            name = name.substring(0, 48) + "..";
        }
        return name;
    }

    public static Object getBatchId() {
        return currentBatchID.get();
    }

    public static void doTaskStage(final Object batchId) {
        currentBatchID.set(batchId);
        final DynamicObject taskStage = BusinessDataServiceHelper.loadSingle((Object)batchId, (String)ENTITY_ISC_DATA_COPY_TASKSTAGE);
        TraceStack.run(TraceType.EXE_DCB, taskStage, new TraceTask(){

            public void run() {
                SignalManager.registerTask(D.s((Object)batchId));
                try {
                    DataCopyTaskStage.innerDoTask(batchId, taskStage);
                }
                finally {
                    SignalManager.unregisterTask(D.s((Object)batchId));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void innerDoTask(Object batchId, DynamicObject taskStage) {
        DataCopyParam param = null;
        DataCopyInput input = null;
        int taskSize = 0;
        try {
            param = new DataCopyParam(taskStage);
            taskSize = param.getTaskSize();
            input = new DataCopyInput(param, null);
            input.initEntityQueryIdReader();
            int totalCount = param.getCounter().getTotalCount();
            if (taskSize > 1000 && totalCount > 1000) {
                DataCopyTaskStage.createMapData(input, param, taskSize, totalCount);
            } else {
                DataCopyTaskStage.createListData(input, param, taskSize, totalCount);
            }
            DataCopyTaskStage.refresherStateB2C(batchId);
            DataCopyTaskStage.refreshTaskStage(param, taskSize, batchId);
            TaskManager.submit(new DataCopyTaskStageNotify(batchId));
        }
        catch (Exception e) {
            DataCopyTaskStage.refresherStateB2X(batchId);
            DataCopyTaskStage.refreshTaskStage(param, taskSize, batchId, e);
        }
        finally {
            currentBatchID.remove();
            if (null != input) {
                input.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refresherStateB2C(Object batchId) {
        Connection cn = null;
        try {
            String sql = "UPDATE T_ISC_DATA_COPY_EXECUTION SET fmodifytime=?, fstate='C' WHERE fstate = 'B' AND ftaskstage = " + batchId;
            List<Timestamp> values = Collections.singletonList(new Timestamp(System.currentTimeMillis()));
            List<Integer> types = Collections.singletonList(93);
            cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
            DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
            DbUtil.close((Connection)cn, (boolean)true);
        }
        catch (Exception e) {
            logger.warn("\u66f4\u65b0\u6267\u884c\u5bf9\u8c61\u72b6\u6001\u5931\u8d25\uff1a", (Throwable)e);
        }
        finally {
            DbUtil.close(cn, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refresherStateB2X(Object batchId) {
        Connection cn = null;
        try {
            String sql = "UPDATE T_ISC_DATA_COPY_EXECUTION SET fmodifytime=?, fstate='X' WHERE fstate = 'B' AND ftaskstage = " + batchId;
            List<Timestamp> values = Collections.singletonList(new Timestamp(System.currentTimeMillis()));
            List<Integer> types = Collections.singletonList(93);
            cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
            DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
            DbUtil.close((Connection)cn, (boolean)true);
        }
        catch (Exception e) {
            logger.warn("\u66f4\u65b0\u6267\u884c\u5bf9\u8c61\u72b6\u6001\u5931\u8d25\uff1a", (Throwable)e);
        }
        finally {
            DbUtil.close(cn, (boolean)true);
        }
    }

    private static void refreshTaskStage(DataCopyParam param, int taskSize, Object batchId) {
        DataCopyTaskStage.refreshTaskStage(param, taskSize, batchId, null);
    }

    private static void refreshTaskStage(DataCopyParam param, int taskSize, Object batchId, Exception e) {
        DynamicObject taskstage = BusinessDataServiceHelper.loadSingle((Object)batchId, (String)ENTITY_ISC_DATA_COPY_TASKSTAGE);
        int totalCount = -1;
        int failedCount = -1;
        int successCount = -1;
        int totalBatch = -1;
        if (param != null) {
            Counter counter = param.getCounter();
            totalCount = counter.getTotalCount();
            failedCount = counter.getFailedCount();
            successCount = counter.getSuccessCount();
            totalBatch = DataCopyTaskStage.getTotalBatch(taskSize, totalCount);
        }
        if (null == e && failedCount < 1) {
            taskstage.set("log", (Object)ResManager.loadKDString((String)"\u5206\u6279\u6210\u529f", (String)"DataCopyTaskStage_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            taskstage.set(STATE, (Object)"S");
        } else {
            if (e instanceof TaskCancelException) {
                taskstage.set(STATE, (Object)"X");
                taskstage.set("log", (Object)ResManager.loadKDString((String)"\u5206\u6279\u5931\u8d25\uff1a\u4efb\u52a1\u5df2\u64a4\u9500", (String)"DataCopyTaskStage_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            } else {
                taskstage.set(STATE, (Object)"F");
                taskstage.set("log", (Object)ResManager.loadKDString((String)"\u5206\u6279\u5931\u8d25\uff1a\u4efb\u52a1\u5df2\u5931\u8d25", (String)"DataCopyTaskStage_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            }
            taskstage.set("log_tag", (Object)StringUtil.trim((Object)e, (int)2000));
        }
        taskstage.set(TOTAL_COUNT, (Object)totalCount);
        taskstage.set(TOTAL_BATCH, (Object)totalBatch);
        taskstage.set(TOTAL_SUCCESS, (Object)successCount);
        taskstage.set(TOTAL_FAILED, (Object)(totalBatch == -1 ? totalBatch : totalBatch - successCount));
        taskstage.set(MODIFYTIME, (Object)new Timestamp(System.currentTimeMillis()));
        taskstage.set("end_time", (Object)new Timestamp(System.currentTimeMillis()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskstage});
    }

    private static int getTotalBatch(int taskSize, int totalCount) {
        double res = (double)totalCount / (double)taskSize;
        return (int)Math.ceil(res);
    }

    private static void createMapData(DataCopyInput input, DataCopyParam param, int taskSize, int totalCount) {
        String pk = param.getSourcePrimaryKey();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(2);
        int i = 0;
        int j = 0;
        Map<String, Object> src = input.read();
        while (src != null) {
            SignalManager.checkCancelSignal();
            Object id = src.get(pk);
            if (++i == 1 && ++j == totalCount) {
                DataCopyTaskStage.doCreateStage(param, Collections.singletonList(id), pk);
            } else if (i == 1) {
                map.put("minId", id);
            } else if (i == taskSize || j == totalCount) {
                map.put("maxId", id);
                DataCopyTaskStage.doCreateStage(param, map, pk);
                map.clear();
                i = 0;
            }
            src = input.read();
        }
    }

    private static void createListData(DataCopyInput input, DataCopyParam param, int taskSize, int totalCount) {
        String pk = param.getSourcePrimaryKey();
        ArrayList<String> stageIds = new ArrayList<String>(taskSize);
        int i = 0;
        Map<String, Object> src = input.read();
        while (src != null) {
            SignalManager.checkCancelSignal();
            Object id = src.get(pk);
            stageIds.add(D.s((Object)id));
            if (taskSize == stageIds.size() || ++i == totalCount) {
                DataCopyTaskStage.doCreateStage(param, stageIds, pk);
                stageIds.clear();
            }
            src = input.read();
        }
    }

    private static void doCreateStage(DataCopyParam param, Object stageIds, String pk) {
        DynamicObject trigger = param.getTrigger();
        List<Map<String, Object>> filter = null;
        if (stageIds instanceof List) {
            filter = DataCopyTaskStage.getFilterFromList(param, (List)stageIds, pk);
        } else if (stageIds instanceof Map) {
            filter = DataCopyTaskStage.getFilterFromMap(param, (Map)stageIds, pk);
        }
        Map<String, Object> data = DataCopyTaskStage.getTaskStageData(filter);
        DataCopyTask.create(trigger, null, null, null, data, DataCopyTask.InitType.MANUAL);
        DataCopyTaskStage.refreshSingleTaskStage(param, Boolean.TRUE);
    }

    private static void refreshSingleTaskStage(DataCopyParam param, Boolean b) {
        DynamicObject taskstage = BusinessDataServiceHelper.loadSingle((Object)DataCopyTaskStage.getBatchId(), (String)ENTITY_ISC_DATA_COPY_TASKSTAGE);
        Counter counter = param.getCounter();
        if (b.booleanValue()) {
            counter.incSuccessCount(1);
            taskstage.set(TOTAL_SUCCESS, (Object)counter.getSuccessCount());
        } else {
            counter.incFailedCount(1);
            taskstage.set(TOTAL_FAILED, (Object)counter.getSuccessCount());
        }
        int totalCount = counter.getTotalCount();
        taskstage.set(TOTAL_COUNT, (Object)totalCount);
        taskstage.set(TOTAL_BATCH, (Object)DataCopyTaskStage.getTotalBatch(param.getTaskSize(), totalCount));
        taskstage.set(MODIFYTIME, (Object)new Timestamp(System.currentTimeMillis()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskstage});
    }

    private static Map<String, Object> getTaskStageData(Object filter) {
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put(TASK_STAGE, Boolean.TRUE);
        data.put(ARRAY, filter);
        return data;
    }

    private static List<Map<String, Object>> getFilterFromList(DataCopyParam param, List<Object> stageIds, String pk) {
        List<Map<String, Object>> filter1 = param.prepareFilter();
        List<Map<String, Object>> filter2 = DataCopyTaskStage.getFilterOfIn(stageIds, pk);
        if (filter1.isEmpty()) {
            return filter2;
        }
        if (filter2.isEmpty()) {
            return filter1;
        }
        return DataCopyTaskStage.mergeFilter(filter1, filter2);
    }

    private static List<Map<String, Object>> getFilterOfIn(List<Object> stageIds, String pk) {
        ArrayList<Map<String, Object>> filterList = new ArrayList<Map<String, Object>>(1);
        HashMap<String, String> filter = new HashMap<String, String>(6);
        filterList.add(filter);
        filter.put(FILTER_LEFT_BRACKET, "");
        filter.put(FILTER_COLUMN, pk);
        filter.put(FILTER_COMPARE, "in");
        filter.put(FILTER_VALUE, DataCopyTaskStage.getFilterValue(stageIds));
        filter.put(FILTER_RIGHT_BRACKET, "");
        filter.put(FILTER_LINK, "");
        return filterList;
    }

    private static List<Map<String, Object>> mergeFilter(List<Map<String, Object>> filter1, List<Map<String, Object>> filter2) {
        DataCopyTaskStage.addLeftBracket(filter1);
        DataCopyTaskStage.addRightBracket(filter1);
        DataCopyTaskStage.setFilterLink(filter1);
        DataCopyTaskStage.addLeftBracket(filter2);
        DataCopyTaskStage.addRightBracket(filter2);
        filter1.addAll(filter2);
        return filter1;
    }

    private static void addLeftBracket(List<Map<String, Object>> filter) {
        Map<String, Object> item = filter.get(0);
        String s = D.s((Object)item.get(FILTER_LEFT_BRACKET));
        s = s == null ? "(" : "(" + s;
        item.put(FILTER_LEFT_BRACKET, s);
    }

    private static void addRightBracket(List<Map<String, Object>> filter) {
        Map<String, Object> item = filter.get(filter.size() - 1);
        String s = D.s((Object)item.get(FILTER_RIGHT_BRACKET));
        s = s == null ? ")" : s + ")";
        item.put(FILTER_RIGHT_BRACKET, s);
    }

    private static void setFilterLink(List<Map<String, Object>> filter) {
        Map<String, Object> item = filter.get(filter.size() - 1);
        item.put(FILTER_LINK, "AND");
    }

    private static List<Map<String, Object>> getFilterFromMap(DataCopyParam param, Map<String, Object> stageIds, String pk) {
        List<Map<String, Object>> filter1 = param.prepareFilter();
        List<Map<String, Object>> filter2 = DataCopyTaskStage.getFilterOfCompare(stageIds, pk);
        if (filter1.isEmpty()) {
            return filter2;
        }
        if (filter2.isEmpty()) {
            return filter1;
        }
        return DataCopyTaskStage.mergeFilter(filter1, filter2);
    }

    private static List<Map<String, Object>> getFilterOfCompare(Map<String, Object> stageIds, String pk) {
        ArrayList<Map<String, Object>> filterList = new ArrayList<Map<String, Object>>(stageIds.size());
        for (Map.Entry<String, Object> entry : stageIds.entrySet()) {
            LinkedHashMap<String, Object> filterMap = new LinkedHashMap<String, Object>(6);
            filterList.add(filterMap);
            filterMap.put(FILTER_COLUMN, pk);
            String key = entry.getKey();
            if (key.contains("minId")) {
                filterMap.put(FILTER_COMPARE, ">=");
            } else if (key.contains("maxId")) {
                filterMap.put(FILTER_COMPARE, "<=");
            }
            filterMap.put(FILTER_VALUE, entry.getValue());
        }
        if (filterList.size() > 1) {
            Map item = (Map)filterList.get(0);
            item.put(FILTER_LINK, "AND");
        }
        return filterList;
    }

    private static String getFilterValue(List<Object> stageIds) {
        StringBuilder filterValue = new StringBuilder();
        filterValue.append('[');
        for (int i = 0; i < stageIds.size(); ++i) {
            filterValue.append('\'').append(stageIds.get(i)).append('\'');
            if (i == stageIds.size() - 1) continue;
            filterValue.append(',');
        }
        filterValue.append(']');
        return filterValue.toString();
    }

    private static void refresherStateTask() {
        ScheduleManager.submit((Task)new LightTask(){

            @Override
            public String getId() {
                return null;
            }

            @Override
            public void run() {
                DataCopyTaskStage.refresherState2F();
            }
        }, 900);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refresherState2F() {
        logger.info("refresherState2F");
        long currentTimeMillis = System.currentTimeMillis();
        Timestamp now = new Timestamp(currentTimeMillis);
        Timestamp refresherTime = new Timestamp(currentTimeMillis - 900000L);
        Connection cn = null;
        try {
            String sql = "UPDATE T_ISC_DATA_COPY_TASKSTAGE SET FMODIFYTIME=?, FEND_TIME=?, FSTATE='F', FLOG=?WHERE FMODIFYTIME<= ? AND FSTATE='C'";
            List<Object> values = Arrays.asList(now, now, "\u5206\u6279\u5931\u8d25\uff1a\u672a\u77e5\u539f\u56e0", refresherTime);
            List<Integer> types = Arrays.asList(93, 93, 12, 93);
            cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
            DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
            DbUtil.close((Connection)cn, (boolean)true);
        }
        catch (Exception e) {
            logger.warn("\u4fdd\u5b58\u5931\u8d25\u72b6\u6001\u5931\u8d25\uff1a", (Throwable)e);
        }
        finally {
            DbUtil.close(cn, (boolean)true);
        }
    }

    public static final class taskStageThread
    implements Task {
        private Object id;

        public taskStageThread(Object bachId) {
            this.id = bachId;
        }

        @Override
        public String getId() {
            return String.valueOf(this.id);
        }

        @Override
        public void run() {
            DataCopyTaskStage.doTaskStage(this.id);
            DataCopyTaskStage.refresherStateTask();
        }
    }
}

