/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.db.tx.TX;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class IscExceptionLog {
    private static final String existedSql = "select count(*) from t_isc_sys_ex_log where ftype = ?";
    private static final String insertSql = "insert into t_isc_sys_ex_log(ftype,fid,fcreatetime,fupdatetime,fmessage,fmessage_tag,ferror_count) values(?,?,?,?,?,?,?)";
    private static final String updateSql = "update t_isc_sys_ex_log set fupdatetime = ?,fmessage = ?,fmessage_tag=?,ferror_count = ferror_count + 1 where ftype = ? and fid = ?";
    private static final String deleteSql = "delete from t_isc_sys_ex_log where ftype = ? and fid = ?";
    private static final String selectSql = "select ftype,fid,fcreatetime,fupdatetime,ferror_count,fmessage,fmessage_tag from t_isc_sys_ex_log where ftype = ? and fid = ?";
    public static final String CLEAR_LOG_EX = "CLEAR_LOG_EX";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(String exceptionType, long id, Throwable ex) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            String errMsg = StringUtil.toString((Throwable)ex);
            if (!IscExceptionLog.isExisted(exceptionType, cn)) {
                IscExceptionLog.insertLog(exceptionType, id, cn, now, errMsg);
            } else {
                IscExceptionLog.updateLog(exceptionType, id, cn, now, errMsg);
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataRow query(String exceptionType, long id) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            DataRow dataRow = DbUtil.executeRow((Connection)cn, (String)selectSql, Arrays.asList(exceptionType, id), Arrays.asList(12, -5));
            return dataRow;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String exceptionType, long id) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)deleteSql, Arrays.asList(exceptionType, id), Arrays.asList(12, -5));
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private static void updateLog(String exceptionType, long id, Connection cn, Timestamp now, String errMsg) {
        List<Object> values = Arrays.asList(now, StringUtil.trim((String)errMsg, (int)100), errMsg, exceptionType, id);
        List<Integer> types = Arrays.asList(93, 12, 12, 12, -5);
        DbUtil.executeUpdate((Connection)cn, (String)updateSql, values, types);
    }

    private static void insertLog(String exceptionType, long id, Connection cn, Timestamp now, String errMsg) {
        List<Object> values = Arrays.asList(exceptionType, id, now, now, StringUtil.trim((String)errMsg, (int)100), errMsg, 1);
        List<Integer> types = Arrays.asList(12, -5, 93, 93, 12, 12, -5);
        DbUtil.executeUpdate((Connection)cn, (String)insertSql, values, types);
    }

    private static boolean isExisted(String exceptionType, Connection cn) {
        Object obj = DbUtil.executeScalar((Connection)cn, (String)existedSql, Collections.singletonList(exceptionType), Collections.singletonList(12));
        return D.l((Object)obj) > 0L;
    }
}

