/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc;

import java.sql.Timestamp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.misc.log.Logger;

public class IscScriptLogger
implements Logger {
    private static final Log logger = LogFactory.getLog(IscScriptLogger.class);

    public void debug(String message) {
        this.log(Logger.Type.Debug, message);
    }

    public void debug(String message, Throwable t) {
        this.log(Logger.Type.Debug, message, t);
    }

    public void error(String message) {
        this.log(Logger.Type.Error, message);
    }

    public void error(String message, Throwable t) {
        this.log(Logger.Type.Error, message, t);
    }

    public void info(String message) {
        this.log(Logger.Type.Info, message);
    }

    public void info(String message, Throwable t) {
        this.log(Logger.Type.Info, message, t);
    }

    public void warn(String message) {
        this.log(Logger.Type.Warn, message);
    }

    public void warn(String message, Throwable t) {
        this.log(Logger.Type.Warn, message, t);
    }

    public void log(Logger.Type type, String message) {
        this.log(type, message, null);
    }

    public void echo(String message) {
        this.log(Logger.Type.Echo, message, null);
    }

    public void log(Logger.Type type, String message, Throwable error) {
        StringBuilder s = new StringBuilder();
        s.append(Thread.currentThread().getName()).append(':').append(type).append(',');
        s.append(new Timestamp(System.currentTimeMillis()));
        s.append("\r\n\t").append(message);
        if (error != null) {
            s.append("\r\n").append(StringUtil.toString((Throwable)error));
        }
        logger.info(s.toString());
    }
}

