/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.sf.runtime.ProcessRuntime;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class ServiceFlowProcessInstMonitor
implements Task {
    private String id;
    private final int offset = 1200000;
    private static Log logger = LogFactory.getLog(ServiceFlowProcessInstMonitor.class);

    ServiceFlowProcessInstMonitor(String accountId) {
        this.id = "M:" + accountId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.isNotReady()) {
            return;
        }
        if (!JobEngine.isMaster()) {
            ScheduleManager.submit((Task)this, 60);
            return;
        }
        boolean exit = false;
        try {
            long now = System.currentTimeMillis();
            Timestamp expire_time = new Timestamp(now - 1200000L);
            List<DataRow> list = ServiceFlowProcessInstMonitor.searchInactiveTasks(expire_time);
            ServiceFlowProcessInstMonitor.interruptProcInst(list);
        }
        catch (Throwable e) {
            logger.warn("ServiceFlowProcessInstMonitor failed.", e);
            String message = e.getMessage();
            if (message != null) {
                exit = message.contains("doesn't exist") || message.contains("unknown");
            }
        }
        finally {
            if (!exit) {
                ScheduleManager.submit((Task)this, 600);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void interruptProcInst(List<DataRow> list) {
        int size = list.size();
        if (size == 0) {
            return;
        }
        ArrayList<Object> values = new ArrayList<Object>(size + 2);
        ArrayList<Integer> types = new ArrayList<Integer>(size + 2);
        StringBuilder sb = new StringBuilder();
        sb.append("update T_ISC_SF_PROC_INST set fstate = ?,fmodified_time = ? where fid in (");
        values.add("Interrupted");
        types.add(12);
        values.add(new Timestamp(System.currentTimeMillis()));
        types.add(93);
        ArrayList<Long> procInstIds = new ArrayList<Long>(size);
        for (int i = 0; i < size; ++i) {
            DataRow e = list.get(i);
            long procInstId = D.l((Object)e.get((Object)"fid"));
            if (i > 0) {
                sb.append(',');
            }
            procInstIds.add(procInstId);
            values.add(procInstId);
            sb.append('?');
            types.add(-5);
        }
        sb.append(')');
        ProcessRuntime.batchSaveErrorLog(procInstIds, ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u6267\u884c\u8d85\u8fc720\u5206\u949f\u672a\u54cd\u5e94\uff0c\u8bf7\u624b\u52a8\u91cd\u8bd5\u3002", (String)"ServiceFlowProcessInstMonitor_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        Connection cn = TX.__getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sb.toString(), values, types);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
        logger.info(size + "\u4e2a\u6d41\u7a0b\u5b9e\u4f8b\u91cd\u7f6e\u4e3a\u4e2d\u65ad\u72b6\u6001\u3002");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNotReady() {
        boolean bl;
        Connection cn = null;
        try {
            String sql = "select count(*) as c from KSQL_USERTABLES WHERE KSQL_TABNAME='T_ISC_SF_PROC_INST'";
            cn = TX.__getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
            bl = D.i((Object)DbUtil.executeScalar((Connection)cn, (String)sql)) == 0;
        }
        catch (Throwable throwable) {
            DbUtil.close(cn, (boolean)false);
            throw throwable;
        }
        DbUtil.close((Connection)cn, (boolean)false);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<DataRow> searchInactiveTasks(Timestamp timestmap) {
        Connection cn = TX.__getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            String sql = "SELECT fid FROM T_ISC_SF_PROC_INST  WHERE fstate = 'Running' and fmodified_time < ?";
            List list = DbUtil.executeList((Connection)cn, (String)sql, Collections.singletonList(timestmap), Collections.singletonList(93));
            return list;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
    }
}

