/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.dc.e.AbstractWriter;
import kd.isc.iscb.platform.core.dc.e.BizBatchException;
import kd.isc.iscb.platform.core.dc.e.DataBatchWriter;
import kd.isc.iscb.platform.core.dc.meta.DataCopyConsumer;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.connector.SaveDataType;

public class BizBatchWriter
extends AbstractWriter {
    private static final ThreadLocal<List<Map<String, Object>>> batch = new ThreadLocal();
    private int batchSize;

    public BizBatchWriter(DataCopyConsumer param) {
        super(param);
        int batchSize = param.getBatchSize();
        this.batchSize = Math.min(30000, batchSize <= 1 ? 50 : batchSize);
        param.getCounter().setBatchSize(this.batchSize);
    }

    public void write(Map<String, Object> data) {
        List<Map<String, Object>> batch = this.getBatch();
        batch.add(data);
        if (batch.size() >= this.batchSize) {
            this.flush();
        }
    }

    private List<Map<String, Object>> getBatch() {
        List<Map<String, Object>> list = batch.get();
        if (list == null) {
            list = new ArrayList<Map<String, Object>>();
            batch.set(list);
        }
        return list;
    }

    private void flush() {
        List<Map<String, Object>> batch = this.getBatch();
        if (batch.size() == 0) {
            return;
        }
        try {
            this.presetFailed();
            List<Response> responses = this.callBatchAction(batch);
            this.setResponse(batch, responses);
        }
        catch (Throwable e) {
            DataBatchWriter.setFailed(batch, e);
            throw e;
        }
        finally {
            batch.clear();
        }
    }

    private List<Response> callBatchAction(List<Map<String, Object>> batch) {
        String proxy_user = this.getProxyUser();
        ConnectionWrapper cn = this.param.getTargetConnection();
        String meta = this.param.getTargetSchema().getString("full_name");
        Map<String, List<String>> judgeFields = this.param.getTargetJudgeFields();
        String action = this.param.getTargetActions().get(0);
        String pk = this.param.getTargetPrimaryKey();
        Map<String, Object> targetActionParams = this.param.getTargetActionParams();
        List<Response> responses = cn.getFactory().doBatchBizAction(cn, meta, batch, pk, judgeFields, action, targetActionParams, proxy_user);
        return responses;
    }

    private void setResponse(List<Map<String, Object>> batch, List<Response> responses) {
        String errorMessage = null;
        for (int i = 0; i < batch.size(); ++i) {
            Map<String, Object> data = batch.get(i);
            Response resp = responses.get(i);
            data.put(this.param.getTargetPrimaryKey(), resp.getId());
            data.put("$action", resp.getType());
            data.put("$entry_mapping", resp.getEntryMappings());
            String error = resp.getErrorMessage();
            if (error == null) continue;
            DynamicObject cfg = this.param.getTargetConnection().getConfig();
            String remark = ConnectionWrapper.generateDbLinkRemark(cfg);
            errorMessage = error = ConnectionWrapper.compositeNewMessage(error, remark);
            data.put("$error_message", error);
        }
        if (errorMessage != null) {
            throw new BizBatchException(errorMessage);
        }
    }

    private String getProxyUser() {
        List<Map<String, Object>> batch = this.getBatch();
        String proxy_user = null;
        for (Map<String, Object> data : batch) {
            String user = this.param.getProxyUser(data);
            if (proxy_user == null) {
                proxy_user = user;
                continue;
            }
            if (proxy_user.equals(user)) continue;
            throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f7f\u7528\u4e86\u591a\u4e2a\u4ee3\u7406\u7528\u6237\uff08%1$s, %2$s\uff09\uff0c\u8bf7\u7981\u7528\u6279\u91cf\u5904\u7406\u63a5\u53e3\u3002", (String)"BizBatchWriter_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), proxy_user, user));
        }
        return proxy_user;
    }

    private void presetFailed() {
        List<Map<String, Object>> batch = this.getBatch();
        for (Map<String, Object> data : batch) {
            data.put("$action", SaveDataType.FAILED);
        }
    }

    @Override
    public boolean rollback(Throwable error) {
        List<Map<String, Object>> batch = this.getBatch();
        for (Map<String, Object> tar : batch) {
            this.param.saveTargetErrorLog(error, tar);
        }
        batch.clear();
        return false;
    }

    public void commit() {
        this.flush();
    }
}

