/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.script.ScriptContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.IscRuntimeInfo;
import kd.isc.iscb.platform.core.apic.InvokeAPI;
import kd.isc.iscb.platform.core.connector.self.MicroServiceInvoker;
import kd.isc.iscb.platform.core.connector.self.MicroServiceInvoker2;
import kd.isc.iscb.platform.core.connector.self.SelfConnection;
import kd.isc.iscb.platform.core.connector.webapi.DynamicObjectContext;
import kd.isc.iscb.platform.core.consume.ConsumeUtil;
import kd.isc.iscb.platform.core.consume.IscConsumeInfo;
import kd.isc.iscb.platform.core.dc.e.DataCopyDebugger;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.platform.core.dc.e.FlatObjectToMapOrList;
import kd.isc.iscb.platform.core.dc.e.ServiceInvoker;
import kd.isc.iscb.platform.core.dc.e.d.Util;
import kd.isc.iscb.platform.core.dc.e.v.Aggregation;
import kd.isc.iscb.platform.core.dc.e.v.AggregationFactory;
import kd.isc.iscb.platform.core.dc.e.v.Evaluator;
import kd.isc.iscb.platform.core.dc.e.v.EvaluatorFactory;
import kd.isc.iscb.platform.core.dc.e.v.ExprEvaluator;
import kd.isc.iscb.platform.core.dc.e.v.PropertyAssembler;
import kd.isc.iscb.platform.core.dc.e.v.a.BizQueryFunction;
import kd.isc.iscb.platform.core.dc.e.v.a.DecodeFunction;
import kd.isc.iscb.platform.core.dc.e.v.a.EncodeFunction;
import kd.isc.iscb.platform.core.dc.meta.DataCopyTransformer;
import kd.isc.iscb.platform.core.vc.ValueConversionRule;
import kd.isc.iscb.platform.core.vc.ValueConversionRuleConfig;
import kd.isc.iscb.platform.core.vc.ValueConversionRuleFactory;
import kd.isc.iscb.util.connector.TableUtil;
import kd.isc.iscb.util.data.LRUMap;
import kd.isc.iscb.util.debugger.DebuggerAction;
import kd.isc.iscb.util.debugger.InlineScriptDebuggerAction;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.Quad;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;

public class DataCopyMapping {
    private DataCopyTransformer param;
    private List<Quad<PropertyAssembler, Evaluator, ValueConversionRule, Aggregation>> mapping_before_assembling;
    private List<Quad<PropertyAssembler, Evaluator, ValueConversionRule, Aggregation>> mapping_after_assembling;
    private LRUMap<Long, Integer> buffer = new LRUMap(8192);
    private LRUMap<Pair<String, ValueConversionRule>, Object> value_conver_cache = new LRUMap(8192);
    private List<ValueConversionRule> rules = new ArrayList<ValueConversionRule>();
    private IscRuntimeInfo info = IscRuntimeInfo.get();
    private List<Pair<PropertyAssembler, Evaluator>> judgeFieldsEvaluators;
    private static final String MAPPING_KEY = UUID.randomUUID().toString();

    public DataCopyMapping(DataCopyTransformer param) {
        this.param = param;
    }

    public DataCopyTransformer getParam() {
        return this.param;
    }

    public Map<String, Object> translateAll(Map<String, Object> src) {
        LinkedHashMap<String, Object> tar = new LinkedHashMap<String, Object>();
        this.translateAll(src, tar);
        return tar;
    }

    public void translateAll(Map<String, Object> src, Map<String, Object> tar) {
        DataCopyDebugger.trap(this.param, "field_mapping", src, null);
        try {
            ArrayList<IscBizException> errors = new ArrayList<IscBizException>(16);
            this.evalOnSource(src, tar, errors);
            this.evalOnTargets(tar, errors);
            DataCopyMapping.handleErrors(errors);
            this.evalMappingScript(src, tar);
            this.checkDuplication(tar);
        }
        catch (Throwable e) {
            this.info.incDataCopyTransferFailedCount();
            throw e;
        }
        finally {
            this.info.incDataCopyTransferTotalCount();
        }
    }

    public static void registerLine(DataCopyParam param) {
        DataCopyDebugger.registerLine(param, "field_mapping", ResManager.loadKDString((String)"\u6267\u884c\u5b57\u6bb5\u6620\u5c04", (String)"DataCopyMapping_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        if (param.getMappingScript() != null) {
            DataCopyDebugger.registerLine(param, "script_mapping", ResManager.loadKDString((String)"\u6267\u884c\u8f6c\u6362\u811a\u672c", (String)"DataCopyMapping_18", (String)"isc-iscb-platform-core", (Object[])new Object[0]), (DebuggerAction)new InlineScriptDebuggerAction(param.getMappingScript().getProgram()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evalMappingScript(Map<String, Object> src, Map<String, Object> target) {
        Script script = this.param.getMappingScript();
        if (script == null) {
            return;
        }
        DataCopyDebugger.trap(this.param, "script_mapping", src, target);
        LinkedHashMap<String, Object> ctx = new LinkedHashMap<String, Object>(this.rules.size() + 12);
        ctx.put("src", src);
        ctx.put("tar", target);
        ctx.put("$src", this.param.getSourceConnection());
        ctx.put("$tar", this.param.getTargetConnection());
        ctx.put("$tar_service", new ServiceInvoker(this.param.getTargetConnection(), null));
        ctx.put("$src_service", new ServiceInvoker(this.param.getSourceConnection(), null));
        ctx.put("$this", new SelfConnection());
        ctx.put("encode", new EncodeFunction());
        ctx.put("decode", new DecodeFunction());
        ctx.put("bizQuery", new BizQueryFunction());
        ctx.put("invokeMicroService", new MicroServiceInvoker());
        ctx.put("invokeMicroService2", new MicroServiceInvoker2());
        ctx.put("params", this.param.getFilterParams());
        ctx.put("flatObjectToMapOrList", new FlatObjectToMapOrList());
        ctx.put("invoke_api", new InvokeAPI());
        DynamicObject schema = this.param.getSchema();
        if (schema != null) {
            ctx.put("$schema_number", schema.getString("number"));
            ctx.put("$schema", new DynamicObjectContext(schema));
        }
        ctx.put(MAPPING_KEY, this);
        for (ValueConversionRule rule : this.rules) {
            ctx.put(rule.name(), rule);
        }
        long start = System.currentTimeMillis();
        try {
            script.eval(ctx);
        }
        finally {
            String title = ConsumeUtil.innerGetTitle(this.param.getSchema(), "mapping_script", ResManager.loadKDString((String)"\u3010\u8f6c\u6362\u811a\u672c\u3011\uff1a", (String)"DataCopyMapping_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            IscConsumeInfo.recordOnce(start, this.param.getSchema(), title);
        }
    }

    public Map<String, Object> translateJudgeFieldsOnly(Map<String, Object> src) {
        ArrayList<IscBizException> errors = new ArrayList<IscBizException>(16);
        Map<String, Object> target = this.evalOnSourceForJudgeFields(src, errors);
        this.evalOnTargetsForJudgeFields(target, errors);
        DataCopyMapping.handleErrors(errors);
        return target;
    }

    public Map<String, Object> translateByAppointedField(Map<String, Object> src, List<String> fields) {
        ArrayList<IscBizException> errors = new ArrayList<IscBizException>(16);
        Map<String, Object> target = this.evalOnSourceForAppointedField(src, fields, errors);
        this.evalOnTargetsForJudgeFields(target, errors);
        DataCopyMapping.handleErrors(errors);
        return target;
    }

    public static void handleErrors(List<IscBizException> errors) {
        switch (errors.size()) {
            case 0: {
                return;
            }
            case 1: {
                throw errors.get(0);
            }
        }
        String message = DataCopyMapping.generateMessage(errors);
        Throwable cause = errors.get(0).getCause();
        IscBizException e = new IscBizException(message, cause);
        e.setStackTrace(cause.getStackTrace());
        throw e;
    }

    private static String generateMessage(List<IscBizException> errors) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (Exception exception : errors) {
            String message = StringUtil.getMessage((Throwable)exception);
            if (sb.indexOf(message) < 0) {
                if (sb.length() > 0) {
                    sb.append("\r\n\r\n");
                }
                sb.append(++index).append('\uff0e').append(message);
            }
            if (sb.length() <= 256000) continue;
            sb.append("...");
            break;
        }
        return sb.toString();
    }

    private Map<String, Object> evalOnSourceForAppointedField(Map<String, Object> src, List<String> fields, List<IscBizException> errors) {
        LinkedHashMap<String, Object> tar = new LinkedHashMap<String, Object>();
        for (Quad<PropertyAssembler, Evaluator, ValueConversionRule, Aggregation> p : this.getMappingBeforeAssembling()) {
            if (!this.isMasterJudgeField((PropertyAssembler)p.getA(), fields)) continue;
            this.execMapping(src, tar, p, errors);
        }
        return tar;
    }

    private void checkDuplication(Map<String, Object> target) {
        List<String> judgeFields = this.param.getJudgeFields();
        if (judgeFields.size() == 0) {
            return;
        }
        String keys = TableUtil.calcKeys(target, judgeFields);
        byte[] bytes = keys.getBytes(D.UTF_8);
        Long h1 = Hash.mur64((byte[])bytes);
        Integer h2 = Hash.mur32((byte[])bytes);
        this.checkDuplication(judgeFields, keys, h1, h2);
    }

    private synchronized void checkDuplication(List<String> judgeFields, String keys, Long h1, Integer h2) {
        if (h2.equals(this.buffer.get((Object)h1))) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6e90\u7cfb\u7edf\u4e2d\u5b58\u5728\u591a\u6761\u5019\u9009\u952e\u3010%1$s\u3011\u503c\u91cd\u590d\u7684\u6570\u636e\uff0c\u8bf7\u8c03\u6574\u5019\u9009\u952e\u6216\u5bf9\u6e90\u7cfb\u7edf\u4e2d\u91cd\u590d\u6570\u636e\u8fdb\u884c\u4fee\u590d\uff0c\u91cd\u590d\u503c\uff1a%2$s", (String)"DataCopyMapping_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), judgeFields, keys));
        }
        this.buffer.put((Object)h1, (Object)h2);
    }

    private void evalOnTargets(Map<String, Object> target, List<IscBizException> errors) {
        for (Quad<PropertyAssembler, Evaluator, ValueConversionRule, Aggregation> p : this.getMappingAfterAssembling()) {
            this.execMapping(target, target, p, errors);
        }
    }

    private void evalOnTargetsForJudgeFields(Map<String, Object> target, List<IscBizException> errors) {
        for (Quad<PropertyAssembler, Evaluator, ValueConversionRule, Aggregation> p : this.getMappingAfterAssembling()) {
            Evaluator e = (Evaluator)p.getB();
            if (!(e instanceof ExprEvaluator) || !((ExprEvaluator)e).isSuperKey()) continue;
            this.execMapping(target, target, p, errors);
        }
    }

    private Map<String, Object> evalOnSource(Map<String, Object> src, Map<String, Object> tar, List<IscBizException> errors) {
        for (Quad<PropertyAssembler, Evaluator, ValueConversionRule, Aggregation> p : this.getMappingBeforeAssembling()) {
            this.execMapping(src, tar, p, errors);
        }
        return tar;
    }

    private void execMapping(Map<String, Object> src, Map<String, Object> tar, Quad<PropertyAssembler, Evaluator, ValueConversionRule, Aggregation> p, List<IscBizException> errors) {
        PropertyAssembler a = (PropertyAssembler)p.getA();
        Evaluator e = (Evaluator)p.getB();
        try {
            ValueConversionRule rule = (ValueConversionRule)p.getC();
            Aggregation ag = (Aggregation)p.getD();
            Object value = e.eval(this.param, src, a);
            if (ag == null) {
                value = this.convert(a, value, rule, errors, e);
            } else if (rule == null) {
                value = ag.calc(value, src);
            } else if (ag.runAt() == Aggregation.RunAt.BEFORE_VALUE_CONVERT) {
                value = ag.calc(value, src);
                value = this.convert(a, value, rule, errors, e);
            } else {
                value = this.convert(a, value, rule, errors, e);
                value = ag.calc(value, src);
            }
            a.set(tar, value);
        }
        catch (Exception err) {
            String message = String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\u5931\u8d25\uff0c\u5b57\u6bb5\uff1a%1$s -> %2$s\u3002\u539f\u56e0\uff1a%3$s", (String)"DataCopyMapping_19", (String)"isc-iscb-platform-core", (Object[])new Object[0]), e, a, StringUtil.getCascadeMessage((Throwable)err));
            errors.add(new IscBizException(message, (Throwable)err));
        }
    }

    private Map<String, Object> evalOnSourceForJudgeFields(Map<String, Object> src, List<IscBizException> errors) {
        LinkedHashMap<String, Object> tar = new LinkedHashMap<String, Object>();
        List<String> judgeFields = this.param.getJudgeFields();
        for (Quad<PropertyAssembler, Evaluator, ValueConversionRule, Aggregation> p : this.getMappingBeforeAssembling()) {
            if (!this.isMasterJudgeField((PropertyAssembler)p.getA(), judgeFields)) continue;
            this.execMapping(src, tar, p, errors);
        }
        return tar;
    }

    private boolean isMasterJudgeField(PropertyAssembler a, List<String> judgeFields) {
        return a.getPathLength() == 1 && judgeFields.contains(a.getField());
    }

    private Object convert(PropertyAssembler p, Object value, ValueConversionRule rule, List<IscBizException> errors, Evaluator e) {
        if (rule == null) {
            return value;
        }
        if (value instanceof Object[]) {
            return this.convertArray(p, (Object[])value, rule, errors, e);
        }
        return this.convertValue(p, value, rule, errors, e);
    }

    public Object convert(Object value, ValueConversionRule rule) {
        ArrayList<IscBizException> errors = new ArrayList<IscBizException>(1);
        Object tar = this.convert(null, value, rule, errors, null);
        DataCopyMapping.handleErrors(errors);
        return tar;
    }

    private Object convertValue(PropertyAssembler p, Object value, ValueConversionRule rule, List<IscBizException> errors, Evaluator e) {
        String src = D.s((Object)value);
        Pair key = new Pair((Object)src, (Object)rule);
        Object tar = this.getFromCache((Pair<String, ValueConversionRule>)key);
        if (tar == null) {
            tar = this.innerRunRule(p, rule, src, e);
            this.putToCache((Pair<String, ValueConversionRule>)key, tar);
        }
        if (tar instanceof IscBizException) {
            if (!errors.contains(tar)) {
                errors.add((IscBizException)((Object)tar));
            }
            return null;
        }
        return "".equals(tar) ? null : tar;
    }

    private Object innerRunRule(PropertyAssembler p, ValueConversionRule rule, String src, Evaluator e) {
        try {
            return ValueConversionRuleFactory.run(p, rule, src);
        }
        catch (Exception err) {
            return DataCopyMapping.wrapException(p, e, src, err);
        }
    }

    public static Object wrapException(Object p, Object e, Object src, Exception err) {
        StringBuilder sb = new StringBuilder();
        String format = String.format(ResManager.loadKDString((String)"\u6e90\u5b57\u6bb5\"%1$s\"\u7684\u503c\u4e3a\"%2$s\"\uff0c\u5230\u76ee\u6807\u5355\u5b57\u6bb5\"%3$s\"\u8f6c\u6362\u5931\u8d25\u3002", (String)"DataCopyMapping_20", (String)"isc-iscb-platform-core", (Object[])new Object[0]), e, src, p);
        sb.append(format).append("\n").append(StringUtil.getCascadeMessage((Throwable)err));
        return new IscBizException(sb.toString(), (Throwable)err);
    }

    private synchronized void putToCache(Pair<String, ValueConversionRule> key, Object tar) {
        this.value_conver_cache.put(key, tar);
    }

    private synchronized Object getFromCache(Pair<String, ValueConversionRule> key) {
        Object t = this.value_conver_cache.get(key);
        return t;
    }

    private Object convertArray(PropertyAssembler p, Object[] values, ValueConversionRule rule, List<IscBizException> errors, Evaluator e) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.convert(p, values[i], rule, errors, e);
        }
        return values;
    }

    private synchronized List<Quad<PropertyAssembler, Evaluator, ValueConversionRule, Aggregation>> getMappingBeforeAssembling() {
        this.createMapping();
        return this.mapping_before_assembling;
    }

    private synchronized List<Quad<PropertyAssembler, Evaluator, ValueConversionRule, Aggregation>> getMappingAfterAssembling() {
        this.createMapping();
        return this.mapping_after_assembling;
    }

    public synchronized List<Pair<PropertyAssembler, Evaluator>> getJudgeFieldsEvaluators() {
        this.createMapping();
        return this.judgeFieldsEvaluators;
    }

    private void createMapping() {
        if (this.mapping_before_assembling != null) {
            return;
        }
        this.mapping_before_assembling = new ArrayList<Quad<PropertyAssembler, Evaluator, ValueConversionRule, Aggregation>>();
        this.mapping_after_assembling = new ArrayList<Quad<PropertyAssembler, Evaluator, ValueConversionRule, Aggregation>>(1);
        this.judgeFieldsEvaluators = new ArrayList<Pair<PropertyAssembler, Evaluator>>(2);
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        HashMap<String, String> entry_source = new HashMap<String, String>();
        ArrayList<IscBizException> errors = new ArrayList<IscBizException>(16);
        this.createMapping(counter, entry_source, errors);
        DataCopyMapping.handleErrors(errors);
    }

    private void createMapping(Map<String, Integer> counter, Map<String, String> entry_source, List<IscBizException> errors) {
        String message;
        String src;
        String tar;
        for (DynamicObject obj : (DynamicObjectCollection)this.param.getSchema().get("mapping_entries")) {
            try {
                this.createMappingEntry(obj, counter, entry_source);
            }
            catch (Exception e) {
                tar = D.s((Object)obj.get("mapping_tar_column"));
                src = D.s((Object)obj.get("mapping_src_column"));
                message = String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\u914d\u7f6e\u9519\u8bef\uff0c\u5b57\u6bb5\uff1a%1$s -> %2$s\u3002\u539f\u56e0\uff1a%3$s", (String)"DataCopyMapping_21", (String)"isc-iscb-platform-core", (Object[])new Object[0]), src, tar, StringUtil.getCascadeMessage((Throwable)e));
                errors.add(new IscBizException(message, (Throwable)e));
            }
        }
        for (Map.Entry<String, String> e : entry_source.entrySet()) {
            try {
                this.createOtherMappingEntry(e);
            }
            catch (IscBizException err) {
                tar = e.getKey();
                src = e.getValue();
                message = String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\u914d\u7f6e\u9519\u8bef\uff0c\u5b57\u6bb5\uff1a%1$s -> %2$s\u3002\u539f\u56e0\uff1a%3$s", (String)"DataCopyMapping_21", (String)"isc-iscb-platform-core", (Object[])new Object[0]), src, tar, StringUtil.getCascadeMessage((Throwable)err));
                errors.add(new IscBizException(message, (Throwable)err));
            }
        }
    }

    private void createOtherMappingEntry(Map.Entry<String, String> e) {
        String targetPK;
        String tar_entry = e.getKey();
        String src_entry = e.getValue();
        if (src_entry.length() > 0 && (targetPK = this.param.findTargetEntryPK(tar_entry.split("\\."))) != null) {
            PropertyAssembler a = new PropertyAssembler(this.param, tar_entry + "." + "$id", 0);
            Evaluator ev = EvaluatorFactory.get(src_entry + "." + "$id", null, null);
            this.mapping_before_assembling.add((Quad<PropertyAssembler, Evaluator, ValueConversionRule, Aggregation>)new Quad((Object)a, (Object)ev, null, null));
            PropertyAssembler a2 = new PropertyAssembler(this.param, tar_entry + "." + "$pk", 0);
            Evaluator ev2 = EvaluatorFactory.get(null, targetPK, null);
            this.mapping_before_assembling.add((Quad<PropertyAssembler, Evaluator, ValueConversionRule, Aggregation>)new Quad((Object)a2, (Object)ev2, null, null));
        }
    }

    private void createMappingEntry(DynamicObject obj, Map<String, Integer> counter, Map<String, String> entry_source) {
        String tar = D.s((Object)obj.get("mapping_tar_column"));
        String fixed_value = D.s((Object)obj.get("fixed_value"));
        String src = D.s((Object)obj.get("mapping_src_column"));
        ValueConversionRule rule = this.getValueConversionRule(obj);
        if (tar == null || src == null && fixed_value == null) {
            return;
        }
        int index = D.i((Object)counter.get(tar));
        PropertyAssembler a = new PropertyAssembler(this.param, tar, index);
        counter.put(tar, ++index);
        String aggr = D.s((Object)obj.get("aggr_fn"));
        Evaluator e = EvaluatorFactory.get(src, fixed_value, a);
        Aggregation ag = AggregationFactory.get(src, aggr);
        this.checkAggrCompatibility(rule, ag);
        if (e.runOnSource()) {
            this.mapping_before_assembling.add((Quad<PropertyAssembler, Evaluator, ValueConversionRule, Aggregation>)new Quad((Object)a, (Object)e, (Object)rule, (Object)ag));
        } else {
            this.mapping_after_assembling.add((Quad<PropertyAssembler, Evaluator, ValueConversionRule, Aggregation>)new Quad((Object)a, (Object)e, (Object)rule, (Object)ag));
        }
        this.collectEntryMapping(entry_source, tar, src, fixed_value, aggr);
        if (D.x((Object)obj.get("candidate_key")) && !obj.getString("mapping_tar_column").contains(".")) {
            this.judgeFieldsEvaluators.add((Pair<PropertyAssembler, Evaluator>)new Pair((Object)a, (Object)e));
        }
    }

    private void checkAggrCompatibility(ValueConversionRule rule, Aggregation ag) {
        if (rule == null || ag == null) {
            return;
        }
        if (ag.runAt() == Aggregation.RunAt.WITHOUT_VALUE_CONVER) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u805a\u5408\u8fd0\u7b97\uff08%s\uff09\u4e0d\u80fd\u4e0e\u503c\u8f6c\u6362\u89c4\u5219\u4e00\u8d77\u4f7f\u7528\uff01", (String)"DataCopyMapping_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]), ag));
        }
    }

    private void collectEntryMapping(Map<String, String> entry_source, String tar, String src, String fixed_value, String aggr) {
        String tar_entry = this.getLongestEntryPath(tar, this.param.getTargetEntryTables().keySet(), this.param.getTargetProperties());
        if (tar_entry == null) {
            return;
        }
        if (aggr != null) {
            return;
        }
        String prior = entry_source.get(tar_entry);
        if ("".equals(prior) || fixed_value != null) {
            return;
        }
        String src_entry = this.getLongestEntryPath(src, this.param.getSourceEntryTables().keySet(), this.param.getSourceProperties());
        if (src_entry == null) {
            return;
        }
        if (prior == null || src_entry.length() > prior.length()) {
            entry_source.put(tar_entry, src_entry);
        }
    }

    private String getLongestEntryPath(String propPath, Set<String> entryTableAlias, Map<String, DataType> properties) {
        int i = propPath.lastIndexOf(46);
        if (i < 0) {
            return null;
        }
        String entryPath = Util.getLongestEntryProperty(properties, propPath);
        if (entryPath == null && entryTableAlias.contains(propPath.substring(0, i))) {
            entryPath = propPath.substring(0, i);
        }
        return entryPath;
    }

    private ValueConversionRule getValueConversionRule(DynamicObject obj) {
        DynamicObject rule_cfg = (DynamicObject)obj.get("value_conver_rule");
        ValueConversionRule rule = null;
        if (rule_cfg != null) {
            rule_cfg = ValueConversionRuleConfig.getById(D.l((Object)rule_cfg.getPkValue()));
            rule = ValueConversionRuleFactory.getRule(rule_cfg, this.param.getSourceConnection(), this.param.getTargetConnection());
            this.rules.add(rule);
        }
        return rule;
    }

    public static DataCopyMapping get(ScriptContext ctx) {
        return (DataCopyMapping)kd.isc.iscb.util.script.Util.get((ScriptContext)ctx, (String)MAPPING_KEY);
    }
}

