/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Base64;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;

public class DataCopyOidLookup {
    public static final String T_ISCB_OID_LOOKUP = "T_ISCB_OID_LOOKUP";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restoreFromOidMapping(DataCopyParam param, Map<String, Object> src, Map<String, Object> tar) {
        if (!param.recordOidMappings()) {
            return;
        }
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            DataCopyOidLookup.innerRestoreFromOidMapping(cn, param, src, tar);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private static void innerRestoreFromOidMapping(Connection cn, DataCopyParam param, Map<String, Object> src, Map<String, Object> tar) {
        Map entry_mapping;
        String targetObjectType;
        String source_oid = D.s((Object)src.get(param.getSourcePrimaryKey()));
        long source_connection = D.l((Object)param.getSourceConnection().getConfig().getPkValue());
        long target_connection = D.l((Object)param.getTargetConnection().getConfig().getPkValue());
        String sql = "select fid, fsource_type, ftarget_type, fsource_oid, ftarget_oid, fentry_mapping, fentry_mapping_tag from  T_ISCB_OID_LOOKUP where fid=?";
        String sourceObjectType = DataCopyOidLookup.getObjectType(param.getSourceSchema());
        String id = DataCopyOidLookup.generateOidMappingId(source_oid, source_connection, sourceObjectType, target_connection, targetObjectType = DataCopyOidLookup.getObjectType(param.getTargetSchema()));
        DataRow row = DbUtil.executeRow((Connection)cn, (String)sql, Collections.singletonList(id), Collections.singletonList(12));
        if (row == null) {
            return;
        }
        DataCopyOidLookup.checkSourceId(row, id, source_oid, sourceObjectType, targetObjectType);
        tar.put(param.getTargetPrimaryKey(), row.get((Object)"ftarget_oid"));
        String json = D.s((Object)row.get((Object)"fentry_mapping_tag"));
        if (json == null) {
            json = D.s((Object)row.get((Object)"fentry_mapping"));
        }
        if ((entry_mapping = (Map)Json.toObject((String)json)) != null) {
            DataCopyOidLookup.resetOid(tar, entry_mapping);
        }
    }

    private static void resetOid(Map<String, Object> tar, Map<String, String> entry_mapping) {
        String target_oid;
        String source_oid = D.s((Object)tar.get("$id"));
        String pk = D.s((Object)tar.remove("$pk"));
        if (source_oid != null && (target_oid = entry_mapping.remove(source_oid)) != null && pk != null) {
            tar.put(pk, target_oid);
        }
        for (Object v : tar.values()) {
            if (!(v instanceof Collection)) continue;
            DataCopyOidLookup.resetEntryOID(entry_mapping, (Collection)v);
        }
    }

    private static void resetEntryOID(Map<String, String> entry_mapping, Collection<?> v) {
        for (Object i : v) {
            if (!(i instanceof Map)) continue;
            DataCopyOidLookup.resetOid((Map)i, entry_mapping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveOidMapping(DataCopyParam param, Map<String, Object> src, Map<String, Object> tar) {
        if (!param.recordOidMappings()) {
            return;
        }
        SaveDataType action = (SaveDataType)tar.get("$action");
        if (action == null) {
            return;
        }
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            switch (action) {
                case DELETE: {
                    DataCopyOidLookup.deleteOidMapping(param, cn, src, tar);
                    return;
                }
                case INSERT: 
                case UPDATE: {
                    DataCopyOidLookup.saveOidMapping(param, cn, src, tar);
                    return;
                }
            }
            return;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private static void saveOidMapping(DataCopyParam param, Connection cn, Map<String, Object> src, Map<String, Object> tar) {
        String target_oid = D.s((Object)tar.get(param.getTargetPrimaryKey()));
        if (target_oid == null || SaveDataType.NOP.equals(tar.get("$action"))) {
            return;
        }
        String source_oid = D.s((Object)src.get(param.getSourcePrimaryKey()));
        if (source_oid == null) {
            return;
        }
        DynamicObject source_schema = param.getSourceSchema();
        DynamicObject target_schema = param.getTargetSchema();
        BigDecimal created_time = BigDecimal.valueOf(System.currentTimeMillis());
        Map entry_mapping1 = (Map)tar.get("$entry_mapping");
        DataCopyOidLookup.saveOidMapping(cn, param.getSourceConnection(), source_schema, source_oid, param.getTargetConnection(), target_schema, target_oid, created_time, entry_mapping1);
        Map<String, String> entry_mapping2 = DataCopyOidLookup.swap(entry_mapping1);
        DataCopyOidLookup.saveOidMapping(cn, param.getTargetConnection(), target_schema, target_oid, param.getSourceConnection(), source_schema, source_oid, created_time, entry_mapping2);
    }

    private static Map<String, String> swap(Map<String, String> entry_mapping) {
        if (entry_mapping == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(entry_mapping.size());
        for (Map.Entry<String, String> e : entry_mapping.entrySet()) {
            String duplicated = map.put(e.getValue(), e.getKey());
            if (duplicated == null) continue;
            map.remove(e.getKey());
        }
        return map;
    }

    private static void deleteOidMapping(DataCopyParam param, Connection cn, Map<String, Object> src, Map<String, Object> tar) {
        String sql = "delete from T_ISCB_OID_LOOKUP where fid=?";
        String source_oid = D.s((Object)src.get(param.getSourcePrimaryKey()));
        String id1 = DataCopyOidLookup.generateOidMappingId(source_oid, param.getSourceConnection(), param.getSourceSchema(), param.getTargetConnection(), param.getTargetSchema());
        DbUtil.executeUpdate((Connection)cn, (String)sql, Collections.singletonList(id1), Collections.singletonList(12));
        String target_oid = D.s((Object)tar.get(param.getTargetPrimaryKey()));
        String id2 = DataCopyOidLookup.generateOidMappingId(target_oid, param.getTargetConnection(), param.getTargetSchema(), param.getSourceConnection(), param.getSourceSchema());
        DbUtil.executeUpdate((Connection)cn, (String)sql, Collections.singletonList(id2), Collections.singletonList(12));
    }

    public static String lookup(String source_oid, long source_connection, DynamicObject source_schema, long target_connection, DynamicObject target_schema) {
        String sourceObjectType = DataCopyOidLookup.getObjectType(source_schema);
        String targetObjectType = DataCopyOidLookup.getObjectType(target_schema);
        return DataCopyOidLookup.lookup(source_oid, source_connection, sourceObjectType, target_connection, targetObjectType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String lookup(String source_oid, long source_connection, String sourceObjectType, long target_connection, String targetObjectType) {
        String id = DataCopyOidLookup.generateOidMappingId(source_oid, source_connection, sourceObjectType, target_connection, targetObjectType);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            String sql = "select fid, fsource_type, ftarget_type, fsource_oid, ftarget_oid from T_ISCB_OID_LOOKUP where fid=?";
            DataRow row = DbUtil.executeRow((Connection)cn, (String)sql, Collections.singletonList(id), Collections.singletonList(12));
            if (row == null) {
                String string = null;
                return string;
            }
            DataCopyOidLookup.checkSourceId(row, id, source_oid, sourceObjectType, targetObjectType);
            String string = (String)row.get((Object)"ftarget_oid");
            return string;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private static void checkSourceId(DataRow row, String fid, String source_oid, String sourceObjectType, String targetObjectType) {
        if (!source_oid.equals(row.get((Object)"fsource_oid"))) {
            String message = String.format(ResManager.loadKDString((String)"\u6e90\u5355/\u76ee\u6807\u5355ID\u5173\u8054\u5173\u7cfb\u51b2\u7a81\uff0c\u6839\u636e\u6e90\u5355ID\u201c%s\u201d\u67e5\u8be2\u5230\u76ee\u6807\u5355ID\uff0c\u4f46\u6570\u636e\u5e93\u4e2d\u767b\u8bb0\u7684\u4fe1\u606f\u4e0e\u671f\u671b\u7684\u4e0d\u7b26\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5e76\u63d0\u4f9b\u4ee5\u4e0b\u4fe1\u606f\u4f9b\u5206\u6790\u3002", (String)"DataCopyOidLookup_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), source_oid) + "\r\n" + String.format(ResManager.loadKDString((String)"\u5b9e\u9645\u53c2\u6570\uff1a{fid=%1$s, fsource_type=%2$s, ftarget_type%3$s, fsource_oid=%4$s}", (String)"DataCopyOidLookup_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), fid, sourceObjectType, targetObjectType, source_oid) + "\r\n" + String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u8bb0\u5f55\uff1a%s", (String)"DataCopyOidLookup_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), row);
            throw new IscBizException(message);
        }
    }

    private static String getObjectType(DynamicObject meta) {
        String table_name = D.s((Object)meta.get("table_name"));
        if (table_name == null) {
            return D.s((Object)meta.getPkValue());
        }
        return table_name.toUpperCase();
    }

    public static String generateOidMappingId(String source_oid, ConnectionWrapper source_cn, DynamicObject source_schema, ConnectionWrapper target_cn, DynamicObject target_schema) {
        long source_connection = D.l((Object)source_cn.getConfig().getPkValue());
        long target_connection = D.l((Object)target_cn.getConfig().getPkValue());
        String sourceObjectType = DataCopyOidLookup.getObjectType(source_schema);
        String targetObjectType = DataCopyOidLookup.getObjectType(target_schema);
        return DataCopyOidLookup.generateOidMappingId(source_oid, source_connection, sourceObjectType, target_connection, targetObjectType);
    }

    public static String generateOidMappingId(String source_oid, long source_connection, String sourceObjectType, long target_connection, String targetObjectType) {
        String text = source_connection + "\n" + sourceObjectType.toUpperCase() + "\n" + target_connection + "\n" + targetObjectType.toUpperCase() + "\n" + source_oid;
        byte[] bytes = Hash.md5((byte[])text.getBytes(StandardCharsets.UTF_8));
        return new String(Base64.encode((byte[])bytes), 0, 22);
    }

    private static void saveOidMapping(Connection cn, ConnectionWrapper source_cn, DynamicObject source_schema, String source_oid, ConnectionWrapper target_cn, DynamicObject target_schema, String target_oid, BigDecimal created_time, Map<String, String> entry_mapping) {
        String target_type;
        String source_type;
        String id;
        String mapping2;
        String s = DataCopyOidLookup.toJson(entry_mapping);
        boolean isShort = s == null || s.length() <= 2000;
        String mapping1 = isShort ? s : " ";
        String string = mapping2 = isShort ? null : s;
        if (mapping1 == null) {
            mapping1 = " ";
        }
        if (DataCopyOidLookup.existsTargetOid(cn, id = DataCopyOidLookup.generateOidMappingId(source_oid, source_cn, source_schema, target_cn, target_schema), source_oid, target_oid, source_type = DataCopyOidLookup.getObjectType(source_schema), target_type = DataCopyOidLookup.getObjectType(target_schema))) {
            String sql = "UPDATE T_ISCB_OID_LOOKUP SET ftarget_oid=?,fentry_mapping=?, fentry_mapping_tag=?,fcreated_time=? WHERE fid=?";
            List<Object> params = Arrays.asList(target_oid, mapping1, mapping2, created_time, id);
            List<Integer> types = Arrays.asList(12, 12, 12, 3, 12);
            DbUtil.executeUpdate((Connection)cn, (String)sql, params, types);
        } else {
            String sql = "INSERT INTO T_ISCB_OID_LOOKUP(fid, fsource_system, fsource_type, fsource_oid, ftarget_system, ftarget_type, ftarget_oid, fentry_mapping, fentry_mapping_tag, fcreated_time) VALUES(?,    ?, ?, ?,   ?, ?, ?,    ?,?,?)";
            BigDecimal source_system = BigDecimal.valueOf(source_cn.getConfig().getLong("id"));
            BigDecimal target_system = BigDecimal.valueOf(target_cn.getConfig().getLong("id"));
            List<Object> params = Arrays.asList(id, source_system, source_type, source_oid, target_system, target_type, target_oid, mapping1, mapping2, created_time);
            List<Integer> types = Arrays.asList(12, 3, 12, 12, 3, 12, 12, 12, 12, 3);
            DbUtil.executeUpdate((Connection)cn, (String)sql, params, types);
        }
    }

    private static boolean existsTargetOid(Connection cn, String fid, String source_oid, String target_oid, String source_type, String target_type) {
        String sql = "select fid, fsource_type, ftarget_type, fsource_oid, ftarget_oid from T_ISCB_OID_LOOKUP where fid=?";
        DataRow row = DbUtil.executeRow((Connection)cn, (String)sql, Collections.singletonList(fid), Collections.singletonList(12));
        if (row == null) {
            return false;
        }
        DataCopyOidLookup.checkSourceId(row, fid, source_oid, source_type, target_type);
        return true;
    }

    private static String toJson(Map<String, String> entry_mapping) {
        if (entry_mapping == null) {
            return null;
        }
        entry_mapping.remove(null);
        if (entry_mapping.isEmpty()) {
            return null;
        }
        return Json.toString(entry_mapping, (boolean)true);
    }
}

