/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.IscRuntimeInfo;
import kd.isc.iscb.platform.core.dc.e.AbstractWriter;
import kd.isc.iscb.platform.core.dc.e.BizBatchWriter;
import kd.isc.iscb.platform.core.dc.e.BizObjectWriter;
import kd.isc.iscb.platform.core.dc.e.DataBatchScriptWriter;
import kd.isc.iscb.platform.core.dc.e.DataBatchWriter;
import kd.isc.iscb.platform.core.dc.e.DataCopyDebugger;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.platform.core.dc.e.DataHandlerWriter;
import kd.isc.iscb.platform.core.dc.e.DataRowWriter;
import kd.isc.iscb.platform.core.dc.e.MMQueueWriter;
import kd.isc.iscb.platform.core.dc.e.MQueueWriter;
import kd.isc.iscb.platform.core.dc.e.ServiceWriter;
import kd.isc.iscb.platform.core.dc.e.TargetScriptWriter;
import kd.isc.iscb.platform.core.dc.meta.DataCopyConsumer;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.debugger.DebuggerAction;
import kd.isc.iscb.util.debugger.InlineScriptDebuggerAction;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectWriter;

public class DataCopyOutput {
    private DataCopyConsumer param;
    private volatile ObjectWriter<Map<String, Object>> writer;
    private IscRuntimeInfo info = IscRuntimeInfo.get();
    private volatile boolean needsRPC = false;
    private static Random rnd = new Random();

    public DataCopyOutput(DataCopyConsumer param) {
        this(param, null);
    }

    public DataCopyOutput(DataCopyConsumer param, ObjectWriter<Map<String, Object>> writer) {
        this.param = param;
        this.writer = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Map<String, Object> data) {
        DataCopyDebugger.trap(this.param, "target_action", null, data);
        this.prepare();
        long beforeWriteTick = System.currentTimeMillis();
        try {
            this.writeAndIncCounter(data);
            DataCopyDebugger.trap(this.param, "after_target_action", null, data);
        }
        finally {
            this.param.getCounter().incLoadTime(System.currentTimeMillis() - beforeWriteTick);
            this.param.getCounter().incLoadBytes(DbUtil.getObjectSize(data));
        }
    }

    public static void registerLine(DataCopyParam param) {
        if (param.getTargetDataScript() == null) {
            DataCopyDebugger.registerLine(param, "target_action", DataCopyOutput.getDebugText(param));
        } else {
            DataCopyDebugger.registerLine(param, "target_action", DataCopyOutput.getDebugText(param), (DebuggerAction)new InlineScriptDebuggerAction(param.getTargetDataScript().getProgram()));
        }
        DataCopyDebugger.registerLine(param, "after_target_action", ResManager.loadKDString((String)"\u76ee\u6807\u6570\u636e\u5904\u7406\u5b8c\u6210", (String)"DataCopyOutput_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    private void writeAndIncCounter(Map<String, Object> data) {
        try {
            this.writeAndHandleDeadLock(data);
        }
        catch (Throwable e) {
            if (this.needsRPC) {
                this.info.incDataCopyWriteFailedCount();
            }
            throw e;
        }
        finally {
            if (this.needsRPC) {
                this.info.incDataCopyWriteTotalCount();
            }
        }
    }

    private void writeAndHandleDeadLock(Map<String, Object> data) {
        int count = 0;
        while (true) {
            try {
                this.writer.write(data);
                return;
            }
            catch (Exception e) {
                if (this.isDeadLock(e) && ++count <= 3) {
                    D.sleep((long)(rnd.nextInt(5000) + 500));
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private boolean isDeadLock(Exception e) {
        HashSet<Exception> errors = new HashSet<Exception>(16);
        for (Throwable err = e; err != null; err = err.getCause()) {
            if (!errors.add((Exception)err)) {
                return false;
            }
            String message = err.getMessage();
            if (message == null) {
                return false;
            }
            if (!message.contains("Deadlock found")) continue;
            return true;
        }
        return false;
    }

    public synchronized void prepare() {
        if (this.writer == null) {
            long beforeWriteTick = System.currentTimeMillis();
            try {
                this.createWriter();
            }
            finally {
                this.param.getCounter().incLoadTime(System.currentTimeMillis() - beforeWriteTick);
            }
        }
    }

    private void createWriter() {
        this.needsRPC = true;
        if (this.param.targetToMQ()) {
            this.writer = this.prepareMQueueWriter();
            this.needsRPC = false;
        } else if (this.param.getTargetDataHandler() != null) {
            this.writer = this.prepareDataHandlerWriter();
        } else if (this.param.getTargetDataScript() != null) {
            this.writer = this.prepareTargetScriptWriter();
        } else if (this.param.isBatchMode()) {
            this.writer = new DataBatchWriter(this.param);
        } else if (this.param.targetIsTable()) {
            this.writer = new DataRowWriter(this.param);
        } else if (this.param.targetIsEntity()) {
            this.writer = this.prepareBizObjectWriter();
        } else if (this.param.targetIsService()) {
            this.writer = this.prepareServicetWriter();
        } else {
            throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u76ee\u6807\u5355\u7c7b\u578b\uff08%s)\uff0c\u53ef\u4ee5\u901a\u8fc7\u914d\u7f6e\u76ee\u6807\u5904\u7406\u7c7b\u6216\u5904\u7406\u811a\u672c\u6765\u4f7f\u7528\u8be5\u7c7b\u578b\u76ee\u6807\u5355", (String)"DataCopyOutput_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.param.getTargetSchema().get("type")));
        }
    }

    private static String getDebugText(DataCopyParam param) {
        if (param.targetToMQ()) {
            if (param.targetIsMQS()) {
                return ResManager.loadKDString((String)"\u591a\u4e3b\u9898MQ\u53d1\u5e03", (String)"DataCopyOutput_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            return ResManager.loadKDString((String)"\u5355\u4e3b\u9898MQ\u53d1\u5e03", (String)"DataCopyOutput_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
        if (param.getTargetDataHandler() != null) {
            return ResManager.loadKDString((String)"\u8c03\u7528\u6570\u636e\u5904\u7406\u7c7b", (String)"DataCopyOutput_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
        if (param.getTargetDataScript() != null) {
            if (param.isBatchMode()) {
                return ResManager.loadKDString((String)"\u76ee\u6807\u6570\u636e\u811a\u672c\u6279\u91cf\u5904\u7406", (String)"DataCopyOutput_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            return ResManager.loadKDString((String)"\u76ee\u6807\u6570\u636e\u811a\u672c\u5904\u7406", (String)"DataCopyOutput_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
        if (param.isBatchMode()) {
            return ResManager.loadKDString((String)"\u76ee\u6807\u5e93\u6570\u636e\u8868\u6279\u91cf\u64cd\u4f5c", (String)"DataCopyOutput_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
        if (param.targetIsTable()) {
            return ResManager.loadKDString((String)"\u76ee\u6807\u5e93\u6570\u636e\u8868\u64cd\u4f5c", (String)"DataCopyOutput_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
        if (param.targetIsEntity()) {
            if (param.supportsBizBatchAction()) {
                return ResManager.loadKDString((String)"\u76ee\u6807\u7cfb\u7edf\u5b9e\u4f53\u6279\u91cf\u64cd\u4f5c", (String)"DataCopyOutput_18", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            return ResManager.loadKDString((String)"\u76ee\u6807\u7cfb\u7edf\u5b9e\u4f53\u64cd\u4f5c", (String)"DataCopyOutput_19", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
        if (param.targetIsService()) {
            return ResManager.loadKDString((String)"\u52a0\u8f7d\u670d\u52a1\u8c03\u7528", (String)"DataCopyOutput_20", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u52a0\u8f7d\u64cd\u4f5c", (String)"DataCopyOutput_21", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
    }

    private ObjectWriter<Map<String, Object>> prepareMQueueWriter() {
        if (!this.param.isRollbackOnError()) {
            if (this.param.targetIsMQS()) {
                return new MMQueueWriter(this.param);
            }
            return new MQueueWriter(this.param);
        }
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u6d88\u606f\u961f\u5217\u8f93\u51fa\u6682\u4e0d\u652f\u6301\u5355\u4e8b\u52a1\u6a21\u5f0f\u3002", (String)"DataCopyOutput_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    private AbstractWriter prepareTargetScriptWriter() {
        if (!this.param.isRollbackOnError()) {
            if (this.param.isBatchMode()) {
                return new DataBatchScriptWriter(this.param);
            }
            return new TargetScriptWriter(this.param);
        }
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u6570\u636e\u5904\u7406\u811a\u672c\u4e0d\u652f\u6301\u5355\u4e8b\u52a1\u6a21\u5f0f\u3002", (String)"DataCopyOutput_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    private ServiceWriter prepareServicetWriter() {
        if (this.param.getTargetEntryTables().size() == 0) {
            if (!this.param.isRollbackOnError()) {
                return new ServiceWriter(this.param);
            }
            throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u662f\u670d\u52a1\u65f6\u4e0d\u652f\u6301\u5355\u4e2a\u4e8b\u52a1\u6a21\u5f0f\u3002", (String)"DataCopyOutput_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u4e0d\u652f\u6301\u670d\u52a1\u4e0e\u5206\u5f55\u8868\u6df7\u7528\uff01", (String)"DataCopyOutput_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    private DataHandlerWriter prepareDataHandlerWriter() {
        if (!this.param.isRollbackOnError()) {
            return new DataHandlerWriter(this.param);
        }
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u6570\u636e\u5904\u7406\u7c7b\u4e0d\u652f\u6301\u5355\u4e2a\u4e8b\u52a1\u6a21\u5f0f\u3002", (String)"DataCopyOutput_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    private ObjectWriter<Map<String, Object>> prepareBizObjectWriter() {
        if (this.param.getTargetEntryTables().size() == 0) {
            if (!this.param.isRollbackOnError()) {
                if (this.param.supportsBizBatchAction()) {
                    return new BizBatchWriter(this.param);
                }
                return new BizObjectWriter(this.param);
            }
            throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u662f\u5b9e\u4f53\u65f6\u4e0d\u652f\u6301\u5355\u4e2a\u4e8b\u52a1\u6a21\u5f0f\u3002", (String)"DataCopyOutput_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u4e0d\u652f\u6301\u5355\u636e\u5bf9\u8c61\u4e0e\u5206\u5f55\u8868\u6df7\u7528\uff01", (String)"DataCopyOutput_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    public synchronized void commit() {
        if (this.writer != null) {
            this.writer.commit();
        }
    }

    public synchronized boolean rollback(Throwable error) {
        if (this.writer != null) {
            return this.writer.rollback(error);
        }
        return true;
    }

    public synchronized void dispose() {
        DbUtil.close(this.writer);
    }
}

