/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.param.AppParam;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.isc.iscb.platform.core.IscScript;
import kd.isc.iscb.platform.core.api.webapi.WebApi;
import kd.isc.iscb.platform.core.apic.ExternalApiMeta;
import kd.isc.iscb.platform.core.app.AppParameterServiceHelper;
import kd.isc.iscb.platform.core.cache.data.ConnectionConfig;
import kd.isc.iscb.platform.core.cache.data.DataCopySchema;
import kd.isc.iscb.platform.core.cache.data.DataCopyTrigger;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.cache.data.MicroServiceApi;
import kd.isc.iscb.platform.core.cache.data.PublishTopicSchema;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.connector.JdbcConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ischub.EventRequest;
import kd.isc.iscb.platform.core.connector.ischub.HubEventBindingCache;
import kd.isc.iscb.platform.core.connector.ischub.eventlog.EventLogExtendInfo;
import kd.isc.iscb.platform.core.connector.self.SelfConnection;
import kd.isc.iscb.platform.core.connector.self.SelfConnectionFactory;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.dc.e.DataCopyAttachment;
import kd.isc.iscb.platform.core.dc.e.DataCopyBillNotify;
import kd.isc.iscb.platform.core.dc.e.DataCopyDebuggableResource;
import kd.isc.iscb.platform.core.dc.e.DataCopyDebugger;
import kd.isc.iscb.platform.core.dc.e.DataCopyEvent;
import kd.isc.iscb.platform.core.dc.e.DataCopyInput;
import kd.isc.iscb.platform.core.dc.e.DataCopyMapping;
import kd.isc.iscb.platform.core.dc.e.DataCopyMessageSender;
import kd.isc.iscb.platform.core.dc.e.DataCopyOutput;
import kd.isc.iscb.platform.core.dc.e.DataCreteria;
import kd.isc.iscb.platform.core.dc.e.ExternalApiProxy;
import kd.isc.iscb.platform.core.dc.e.MicroServiceProxy;
import kd.isc.iscb.platform.core.dc.e.SQLUtil;
import kd.isc.iscb.platform.core.dc.e.d.EntryCollectionType;
import kd.isc.iscb.platform.core.dc.e.d.SimpleValueType;
import kd.isc.iscb.platform.core.dc.e.d.Util;
import kd.isc.iscb.platform.core.dc.e.p.ViewUtil;
import kd.isc.iscb.platform.core.dc.e.s.CompositeSourceDataDecorator;
import kd.isc.iscb.platform.core.dc.e.s.SourceDataDecorator;
import kd.isc.iscb.platform.core.dc.e.v.Evaluator;
import kd.isc.iscb.platform.core.dc.e.v.EvaluatorFactory;
import kd.isc.iscb.platform.core.dc.e.v.ExprEvaluator;
import kd.isc.iscb.platform.core.dc.meta.AbstractDataCopyConsumer;
import kd.isc.iscb.platform.core.dc.meta.AbstractDataCopyProvider;
import kd.isc.iscb.platform.core.dc.meta.DataCopyConsumer;
import kd.isc.iscb.platform.core.dc.meta.DataCopyProvider;
import kd.isc.iscb.platform.core.dc.meta.DataCopyTransformer;
import kd.isc.iscb.platform.core.fn.ScriptFunction;
import kd.isc.iscb.platform.core.fn.ScriptFunctionManager;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.sf.Resource;
import kd.isc.iscb.platform.core.sf.parser.ResourceCategory;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.platform.core.trace.TraceUtil;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.vc.ValueConversionException;
import kd.isc.iscb.platform.core.vc.ValueConversionRule;
import kd.isc.iscb.platform.core.vc.ValueConversionRuleConfig;
import kd.isc.iscb.platform.core.vc.ValueConversionRuleFactory;
import kd.isc.iscb.util.connector.TableAction;
import kd.isc.iscb.util.db.Schema;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.Counter;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.misc.Triple;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.data.ValueRange;

public class DataCopyParam
implements DataCopyProvider,
DataCopyConsumer,
DataCopyTransformer {
    private static final String FILTER_VALUE = "filter_value";
    private static final String FILTER_COMPARE = "filter_compare";
    private static final String FILTER_COLUMN = "filter_column";
    private static final String FILTER_LEFT_BRACKET = "filter_left_bracket";
    private static final String FILTER_RIGHT_BRACKET = "filter_right_bracket";
    private static final String FILTER_LINK = "filter_link";
    private static final String PARAM_ENTRIES = "param_entries";
    private static final String PARAMS_ENTRYENTITY = "params_entryentity";
    private static final String NUMBER = "number";
    private static final String TABLE_NAME = "table_name";
    private static final String MASTER_TABLE_ID = "master_table_id";
    private static final String RELATION_TYPE = "relation_type";
    private static final String RELATION_MAPPING = "relation_mapping";
    private static final String FIXED_VALUE = "fixed_value";
    private static final String MAPPING_SRC_COLUMN = "mapping_src_column";
    private static final String MAPPING_TAR_COLUMN = "mapping_tar_column";
    private static final String MAPPING_ENTRIES = "mapping_entries";
    private static final String ENTITY_ISC_DATA_COPY_TASKSTAGE = "isc_data_copy_taskstage";
    private static final String ENTITY_ISC_DATA_COPY = "isc_data_copy";
    private static final String ENTITY_ISC_DATA_COPY_EXECUTION = "isc_data_copy_execution";
    private static final String ENTITY_ISC_DATA_COPY_TRIGGER = "isc_data_copy_trigger";
    private static final String DATA_TRIGGER_ID = "data_trigger_id";
    private static final String DATA_COPY_TRIGGER_ID = "data_copy_trigger_id";
    private static final String DATA_COPY_ID = "data_copy_id";
    private static final String DATA_SOURCE_ID = "data_source_id";
    private static final String DATA_TARGET_ID = "data_target_id";
    private String executionId;
    private DynamicObject execution;
    private DynamicObject taskStage;
    private Object pushedData;
    private List<Map<String, Object>> pushedFilter;
    private ConnectionWrapper this_connection;
    private ConnectionWrapper src_connection;
    private ConnectionWrapper tar_connection;
    private Counter counter = new Counter();
    private DataCopyProvider provider;
    private DataCopyConsumer consumer;
    private DynamicObject trigger;
    private DynamicObject schema;
    private SourceDataDecorator sdd;
    private List<String> judgeFields;
    private List<String> srcJudgeFields;
    private String judgeField;
    private Map<String, List<String>> entryJudgeFields = new HashMap<String, List<String>>();
    private Object ssid;
    private boolean breakOnError;
    private boolean rollbackOnError;
    private int thread_ubound = 1;
    private Map<String, Set<String>> targetFields;
    private Map<String, Object> filter_params;
    private boolean batch_write_mode;
    private boolean has_source_entry_tables;
    private Map<String, Triple<Schema, String, String>> source_entry_tables;
    private Map<String, Pair<Table, String>> target_entry_tables;
    private Map<String, DataType> target_properties;
    private Map<String, DataType> source_properties;
    private ArrayList<String> target_actions;
    private Map<String, Object> target_actions_params;
    private DynamicObjectCollection schema_actions_entry;
    private String sourceParentField;
    private String targetParentField;
    private String defaultRootParent;
    private DataCreteria rootNodeCreteria;
    private long writeBackRuleId;
    private boolean trace_all;
    private boolean has_source_ref_tables;
    private Map<String, Pair<Schema, String>> source_ref_tables;
    private String target_data_handler;
    private Script target_script;
    private Evaluator proxy_user;
    private boolean has_dynamic_proxy_user;
    private boolean record_oid_mappings;
    private boolean record_oid_log;
    private String mapping_script_text;
    private Script mapping_script;
    private String reader_script_text;
    private Script reader_script;
    private String mutex;
    private int batchSize;
    private int retryCount;
    private int[] retryIntervals;
    private int taskSize;
    private boolean supports_file_copy;
    private boolean use_src_attach_create_time;
    private ValueConversionRule attach_creator_rule;
    private boolean hasConfigTsField;
    private String timeStampField;
    private String srcDataRetrieveScriptStr;
    private Script srcDataRetrieveScript;
    private Map<String, Object> srcScriptContext = new HashMap<String, Object>();
    private Map<String, Object> tarScriptContext = new HashMap<String, Object>();
    private Map<String, Object> mappingScriptContext = new HashMap<String, Object>();
    private boolean disableTrace;
    private int maxCount = Integer.MAX_VALUE;
    private int maxErrorLogRecordCount;
    private EventLogExtendInfo extendInfo;
    private Map<DataCopyEvent.Type, List<EventRequest>> iscEventRequests = new EnumMap<DataCopyEvent.Type, List<EventRequest>>(DataCopyEvent.Type.class);
    private Map<DataCopyEvent.Type, List<DataCopyEvent>> event_handlers = new EnumMap<DataCopyEvent.Type, List<DataCopyEvent>>(DataCopyEvent.Type.class);
    private Map<DataCopyEvent.Type, List<DataCopyMessageSender>> message_handlers = new EnumMap<DataCopyEvent.Type, List<DataCopyMessageSender>>(DataCopyEvent.Type.class);
    private int bill_message_count = 0;
    private DataCopyDebuggableResource res;

    public DataCopyParam(DynamicObject obj) {
        this.setDynamicObject(obj);
        this.init();
    }

    public DataCopyParam(DynamicObject obj, List<Map<String, Object>> filters) {
        this.pushedFilter = filters;
        this.setDynamicObject(obj);
        this.init();
    }

    public DataCopyParam(DynamicObject obj, Map<String, Object> filter_params) {
        this.filter_params = filter_params;
        this.setDynamicObject(obj);
        this.init();
    }

    public DataCopyParam(DynamicObject schema, ConnectionWrapper src, ConnectionWrapper tar) {
        this.schema = schema;
        this.src_connection = src;
        this.tar_connection = tar;
        this.init();
    }

    private void setDynamicObject(DynamicObject obj) {
        String type = obj.getDataEntityType().getName();
        if (ENTITY_ISC_DATA_COPY_EXECUTION.equals(type)) {
            this.executionId = obj.getPkValue().toString();
            this.execution = obj;
            this.trigger = DataCopyTrigger.get(obj.getLong(DATA_COPY_TRIGGER_ID));
            this.schema = DataCopySchema.get(this.trigger.getLong(DATA_COPY_ID));
            this.initPushedDataOrFilter();
        } else if (ENTITY_ISC_DATA_COPY_TRIGGER.equals(type)) {
            this.trigger = obj;
            this.schema = DataCopySchema.get(this.trigger.getLong(DATA_COPY_ID));
        } else if (ENTITY_ISC_DATA_COPY.equals(type)) {
            this.schema = obj;
        } else if (ENTITY_ISC_DATA_COPY_TASKSTAGE.equals(type)) {
            this.taskStage = obj;
            this.trigger = DataCopyTrigger.get(obj.getLong(DATA_TRIGGER_ID));
            this.schema = DataCopySchema.get(this.trigger.getLong(DATA_COPY_ID));
        } else {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8981\u6c42\u7684\u53c2\u6570\u7c7b\u578b\u5fc5\u987b\u662f\uff08isc_data_copy_execution\u6216isc_data_copy_trigger\u6216isc_data_copy\uff09\uff0c\u4f46\u53c2\u6570\u7684\u5b9e\u9645\u7c7b\u578b\u662f\uff08%s\uff09\u3002", (String)"DataCopyParam_43", (String)"isc-iscb-platform-core", (Object[])new Object[0]), type));
        }
    }

    private void initPushedDataOrFilter() {
        if (this.pushedFilter != null) {
            return;
        }
        String data = D.s((Object)this.getExecution().get("source_data_tag"));
        if (data != null) {
            Object o = JSON.parse((String)data);
            if (o instanceof Map && D.x(((Map)o).get("$is_filter"))) {
                this.pushedFilter = (List)((Map)o).get("$filter_items");
            } else {
                this.pushedData = o;
                this.initHubExtendInfo();
            }
        }
    }

    private void initHubExtendInfo() {
        Map srcData;
        Object o;
        List list;
        if (this.pushedData instanceof List && (list = (List)this.pushedData).size() == 1 && (o = (srcData = (Map)list.get(0)).get("$event_ext_info")) instanceof Map) {
            this.extendInfo = new EventLogExtendInfo((Map)o);
        }
    }

    public EventLogExtendInfo getHubExtendInfo() {
        return this.extendInfo;
    }

    private void init() {
        this.initScriptContext();
        this.thread_ubound = this.trigger == null ? 1 : D.i((Object)this.trigger.get("thread_ubound"));
        this.target_data_handler = D.s((Object)this.schema.get("target_handler"));
        this.initTargetScript();
        this.record_oid_mappings = D.x((Object)this.schema.get("record_oid_mappings"));
        Pair<Evaluator, Boolean> p = DataCopyParam.getProxyUser(D.s((Object)this.schema.get("proxy_user")));
        this.proxy_user = (Evaluator)p.getKey();
        this.has_dynamic_proxy_user = (Boolean)p.getValue();
        this.record_oid_log = D.x((Object)this.schema.get("record_oid_log"));
        this.trace_all = this.record_oid_log || this.trigger != null && D.x((Object)this.trigger.get("trace_all"));
        long src_schema_id = this.schema.getLong("source_schema_id");
        this.provider = this.createDataCopyProvider(src_schema_id);
        long tar_schema_id = (Long)this.schema.get("target_schema_id");
        this.consumer = this.createDataCopyConsumer(tar_schema_id);
        this.writeBackRuleId = (Long)this.schema.get("write_back_rule_id");
        String mode = D.s((Object)this.schema.get("mode"));
        this.breakOnError = !"ResumeOnError".equals(mode) || this.execution == null;
        this.rollbackOnError = "RequiresTransaction".equals(mode);
        this.supports_file_copy = this.schema.getBoolean("supports_file_copy");
        if (this.supports_file_copy) {
            this.initAttachExtendInfo();
        }
        this.initParentField();
        this.initSrcRetrieveScript();
        String mapping_script_text = D.s((Object)this.schema.get("mapping_script_tag"));
        if (mapping_script_text == null) {
            mapping_script_text = D.s((Object)this.schema.get("mapping_script"));
        }
        this.mapping_script_text = mapping_script_text;
        String reader_script_text = D.s((Object)this.schema.get("reader_script_tag"));
        if (reader_script_text == null) {
            reader_script_text = D.s((Object)this.schema.get("reader_script"));
        }
        this.reader_script_text = reader_script_text;
        this.has_source_entry_tables = this.initHasSourceEntryTables();
        this.has_source_ref_tables = this.initHasSourceRefTables();
        this.schema_actions_entry = this.schema.getDynamicObjectCollection("target_actions");
        this.initBatchSize();
        this.batch_write_mode = this.initBatchMode();
        if (!this.batch_write_mode && this.batchSize <= 0) {
            this.batchSize = 1;
        }
        this.initEventHandlers();
        this.initIscEventHandlers();
        this.initMessageHandlers();
        this.initMutex();
        this.initTimestempField();
        this.initSourceDataDecorator();
        this.initRetryCount();
        this.initMaxErrorLogRecordCount();
        this.initRetryIntervals();
        this.initTaskSize();
        this.disableTrace = TraceUtil.isDisableTrace(this.getTrigger());
        this.innerRegisterLine();
    }

    private void initAttachExtendInfo() {
        DynamicObject attachCreatorRule;
        this.use_src_attach_create_time = this.schema.getBoolean("use_src_att_create_time");
        long attach_creator_rule_id = this.schema.getLong("attach_creator_rule_id");
        if (attach_creator_rule_id > 0L && (attachCreatorRule = ValueConversionRuleConfig.getById(attach_creator_rule_id)) != null) {
            this.attach_creator_rule = ValueConversionRuleFactory.getRule(attachCreatorRule, this.getSourceConnection(), this.getTargetConnection());
        }
    }

    @Override
    public Object evalTargetAttachCreator(String srcAttachCreatorId) {
        if (this.attach_creator_rule != null) {
            try {
                return ValueConversionRuleFactory.run(null, this.attach_creator_rule, srcAttachCreatorId);
            }
            catch (Exception e) {
                throw new ValueConversionException(String.format(ResManager.loadKDString((String)"\u9644\u4ef6\u521b\u5efa\u4eba\u503c\u8f6c\u6362\u89c4\u5219\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u4f7f\u7528\u201c%1$s\u201d\u4f5c\u4e3a\u53c2\u6570\u503c\u6d4b\u8bd5\u8be5\u503c\u8f6c\u6362\u89c4\u5219\u83b7\u53d6\u66f4\u591a\u4fe1\u606f\u6216\u8c03\u6574\u8be5\u89c4\u5219\u3002", (String)"DataCopyParam_63", (String)"isc-iscb-platform-core", (Object[])new Object[0]), srcAttachCreatorId), e);
            }
        }
        return null;
    }

    @Override
    public boolean useSrcAttachCreateTime() {
        return this.use_src_attach_create_time;
    }

    private void initMessageHandlers() {
        if (this.trigger == null) {
            return;
        }
        List<DynamicObject> objects = DataCopyBillNotify.getAll(this.trigger);
        ArrayList<DataCopyMessageSender> successMsgSenders = new ArrayList<DataCopyMessageSender>();
        ArrayList<DataCopyMessageSender> failedMsgSenders = new ArrayList<DataCopyMessageSender>();
        for (DynamicObject object : objects) {
            DataCopyMessageSender sender = new DataCopyMessageSender(this, object);
            if (D.s((Object)object.get("condition")).contains("success")) {
                successMsgSenders.add(sender);
            }
            if (!D.s((Object)object.get("condition")).contains("failed")) continue;
            failedMsgSenders.add(sender);
        }
        if (!successMsgSenders.isEmpty()) {
            this.message_handlers.put(DataCopyEvent.Type.OnRowSuccess, successMsgSenders);
        }
        if (!failedMsgSenders.isEmpty()) {
            this.message_handlers.put(DataCopyEvent.Type.OnRowFailed, failedMsgSenders);
        }
        if ((this.batchSize > 1 || this.isBatchMode()) && !this.message_handlers.isEmpty()) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5b58\u5728\u5355\u636e\u7ea7\u6d88\u606f\u901a\u77e5\uff0c\u5f53\u524d\u65b9\u6848\u4e0d\u5e94\u4f7f\u7528\u6279\u91cf\u6a21\u5f0f(\u6570\u636e\u8868\u6279\u91cf/\u5355\u636e\u6279\u91cf\u64cd\u4f5c)\uff0c\u89e3\u51b3\u63aa\u65bd\uff1a\u53d6\u6d88\u6279\u91cf\u6a21\u5f0f\u6216\u8005\u7981\u7528\u5355\u636e\u7ea7\u6d88\u606f\u901a\u77e5", (String)"DataCopyParam_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }

    public synchronized int incMessageCount() {
        return ++this.bill_message_count;
    }

    private void initIscEventHandlers() {
        List<EventRequest> rowFailedEvent;
        if (this.trigger == null) {
            return;
        }
        for (DataCopyEvent.Type type : DataCopyEvent.Type.values()) {
            List<EventRequest> eventRequests = HubEventBindingCache.find(this.trigger.getDataEntityType().getName(), this.trigger.getLong("id"), type.name());
            this.iscEventRequests.put(type, eventRequests);
        }
        if ((this.batch_write_mode || this.batchSize > 1) && (rowFailedEvent = this.iscEventRequests.get((Object)DataCopyEvent.Type.OnRowFailed)) != null && rowFailedEvent.size() > 0) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5b58\u5728HUB\u4e8b\u4ef6[\u5355\u636e\u6267\u884c\u5931\u8d25]\u76d1\u542c\uff0c\u8bf7\u5c06\u542f\u52a8\u65b9\u6848\u7684\u76ee\u6807\u5355\u6279\u91cf\u5927\u5c0f\u8bbe\u7f6e\u4e3a1\u3002", (String)"DataCopyParam_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }

    private void initScriptContext() {
        DynamicObjectCollection functionEntry = this.schema.getDynamicObjectCollection("function_entryentity");
        long srcDataSource = this.getSourceDataSourceId();
        long tarDataSource = this.getTargetDataSourceId();
        for (DynamicObject entry : functionEntry) {
            DynamicObject res = entry.getDynamicObject("custom_function");
            if (res == null) continue;
            this.allocateResource(srcDataSource, tarDataSource, entry, res);
        }
        this.mappingScriptContext.putAll(this.srcScriptContext);
        this.mappingScriptContext.putAll(this.tarScriptContext);
    }

    private void allocateResource(long srcDataSource, long tarDataSource, DynamicObject entry, DynamicObject res) {
        String name = this.getResourceAlias(entry, res);
        String category = this.getResCategory(entry);
        long resId = res.getLong("id");
        if ("isc_custom_function".equals(category)) {
            this.allocateScriptFunction(name, resId);
        } else if ("isc_apic_for_external_api".equals(category)) {
            this.allocateExternalApiResource(srcDataSource, tarDataSource, name, resId);
        } else if ("isc_apic_mservice".equals(category)) {
            this.allocateMServiceResource(name, resId);
        } else if ("isc_apic_webapi".equals(category)) {
            this.allocateWebApiResource(srcDataSource, tarDataSource, name, resId);
        } else {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7c7b\u578b\u4e3a\uff08%s\uff09\u7684\u8d44\u6e90\u3002", (String)"DataCopyParam_44", (String)"isc-iscb-platform-core", (Object[])new Object[0]), category));
        }
    }

    private void allocateMServiceResource(String name, long resId) {
        MicroServiceApi schema = MicroServiceApi.getSchema(resId);
        MicroServiceProxy proxy = new MicroServiceProxy(schema);
        this.tarScriptContext.put(name, proxy);
    }

    private void allocateScriptFunction(String name, long resId) {
        ScriptFunction fn = ScriptFunctionManager.getFunction(resId);
        this.srcScriptContext.put(name, fn);
        this.tarScriptContext.put(name, fn);
    }

    private void allocateExternalApiResource(long srcDataSource, long tarDataSource, String name, long resId) {
        ExternalApiMeta api = ExternalApiMeta.get(resId);
        boolean valid = false;
        if (api.getDataSourceId() == srcDataSource) {
            this.srcScriptContext.put(name, new ExternalApiProxy(api, this));
            valid = true;
        }
        if (api.getDataSourceId() == tarDataSource) {
            this.tarScriptContext.put(name, new ExternalApiProxy(api, this));
            valid = true;
        }
        if (!valid) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5916\u90e8API\uff08%s\uff09\u7684\u6570\u636e\u6e90\u4e0e\u6570\u636e\u96c6\u6210\u65b9\u6848\u7684\u6765\u6e90\u7cfb\u7edf/\u76ee\u6807\u7cfb\u7edf\u4e0d\u5339\u914d\u3002", (String)"DataCopyParam_45", (String)"isc-iscb-platform-core", (Object[])new Object[0]), api.getNumber()));
        }
    }

    private void allocateWebApiResource(long srcDataSource, long tarDataSource, String aliseName, long resId) {
        DynamicObject cfg = WebApi.get(resId).getCfg();
        String name = cfg.getString(NUMBER);
        String title = cfg.getString("name");
        long group_id = cfg.getLong("group_id");
        Resource resource = ResourceCategory.ISC_APIC_WEBAPI.create(resId, name, title);
        boolean valid = false;
        if (group_id == srcDataSource) {
            this.srcScriptContext.put(aliseName, resource);
            valid = true;
        }
        if (group_id == tarDataSource) {
            this.tarScriptContext.put(aliseName, resource);
            valid = true;
        }
        if (!valid) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"WebAPI\uff08%s\uff09\u7684\u6570\u636e\u6e90\u4e0e\u6570\u636e\u96c6\u6210\u65b9\u6848\u7684\u6765\u6e90\u7cfb\u7edf/\u76ee\u6807\u7cfb\u7edf\u4e0d\u5339\u914d\u3002", (String)"DataCopyParam_66", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name));
        }
    }

    private String getResCategory(DynamicObject entry) {
        String resCategoryStr = D.s((Object)entry.get("res_category"));
        if (resCategoryStr == null) {
            resCategoryStr = "isc_custom_function";
        }
        return resCategoryStr;
    }

    private String getResourceAlias(DynamicObject entry, DynamicObject res) {
        String name = D.s((Object)entry.get("function_number"));
        if (name == null) {
            name = res.getString(NUMBER);
        }
        return name;
    }

    private void initTimestempField() {
        if (this.trigger == null) {
            return;
        }
        this.timeStampField = D.s((Object)this.trigger.get("timestamp_field"));
        this.hasConfigTsField = this.timeStampField != null;
    }

    @Override
    public boolean hasConfigSourceTsField() {
        return this.hasConfigTsField;
    }

    @Override
    public String getSourceTsField() {
        return this.timeStampField;
    }

    private void initEventHandlers() {
        List<DataCopyEvent> rowFailedEvent;
        if (this.trigger == null) {
            return;
        }
        for (DynamicObject i : this.trigger.getDynamicObjectCollection("event_handlers")) {
            DataCopyEvent.Type type = DataCopyEvent.Type.valueOf(D.s((Object)i.get("datacopy_event")));
            DataCopyEvent.Consumer consumer = DataCopyEvent.Consumer.valueOf(D.s((Object)i.get("target_consumer")));
            String handler = D.s((Object)i.get("event_handler"));
            List<DataCopyEvent> events = this.event_handlers.get((Object)type);
            if (events == null) {
                events = new ArrayList<DataCopyEvent>(2);
                this.event_handlers.put(type, events);
            }
            events.add(new DataCopyEvent(consumer, handler));
        }
        if ((this.batch_write_mode || this.batchSize > 1) && (rowFailedEvent = this.event_handlers.get((Object)DataCopyEvent.Type.OnRowFailed)) != null && rowFailedEvent.size() > 0) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5f53\u524d\u542f\u52a8\u65b9\u6848\u7684\u4e8b\u4ef6\u5904\u7406\u914d\u7f6e\u4e86\u76d1\u542c\u5355\u636e\u6267\u884c\u5931\u8d25\u4e8b\u4ef6\uff0c\u8bf7\u5c06\u542f\u52a8\u65b9\u6848\u7684\u76ee\u6807\u5355\u6279\u91cf\u5927\u5c0f\u8bbe\u7f6e\u4e3a1\u3002", (String)"DataCopyParam_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }

    private void initRetryIntervals() {
        if (this.trigger == null) {
            this.retryIntervals = new int[]{1, 8, 27};
        } else {
            String retryIntervalStr = D.s((Object)this.trigger.get("retry_interval"));
            if (retryIntervalStr == null) {
                this.retryIntervals = new int[]{1, 8, 27};
            } else {
                this.initIntervalArray(retryIntervalStr);
            }
        }
    }

    private void initIntervalArray(String retryIntervalStr) {
        String[] intervals = retryIntervalStr.split(";|,|\uff1b|\uff0c");
        this.retryIntervals = new int[intervals.length];
        for (int i = 0; i < intervals.length; ++i) {
            int val;
            this.retryIntervals[i] = val = D.i((Object)intervals[i]);
        }
    }

    private void initRetryCount() {
        String retryCountStr;
        this.retryCount = this.trigger == null ? 3 : ((retryCountStr = D.s((Object)this.trigger.get("retry_count_str"))) == null ? 3 : D.i((Object)retryCountStr));
    }

    private void initTargetScript() {
        String ts = D.s((Object)this.schema.get("target_script_tag"));
        if (ts == null) {
            ts = D.s((Object)this.schema.get("target_script"));
        }
        if (ts != null) {
            this.target_script = IscScript.compile(ts, this.tarScriptContext);
        }
    }

    private void initBatchSize() {
        if (this.trigger != null) {
            this.batchSize = D.i((Object)this.trigger.get("batch_size"));
            if (this.batchSize < 0) {
                this.batchSize = 1;
            }
        } else {
            this.batchSize = 1;
        }
    }

    private void initMutex() {
        if (this.trigger == null) {
            return;
        }
        String mutex = D.s((Object)this.trigger.get("mutex_name"));
        if (mutex != null && mutex.startsWith("#{") && mutex.endsWith("}")) {
            String param = mutex.substring(2, mutex.length() - 1);
            String value = D.s((Object)this.getFilterParams().get(param));
            if (value != null) {
                mutex = param + "/" + Hash.mur32((Object[])new Object[]{value});
            }
        }
        this.mutex = mutex;
    }

    private void initSourceDataDecorator() {
        if (this.hasSourceEntryTables()) {
            this.setSourceDataDecorator(SourceDataDecorator.ENTRY_TABLE);
        }
        if (this.hasSourceRefTables()) {
            this.setSourceDataDecorator(SourceDataDecorator.REF_TABLE);
        }
        if (this.hasReaderScript()) {
            this.setSourceDataDecorator(SourceDataDecorator.SCRIPT);
        }
        if (this.hasConfigSourceTsField()) {
            this.setSourceDataDecorator(SourceDataDecorator.TIMESTAMP);
        }
    }

    private static void registerDecoratorLine(DataCopyParam param) {
        if (param.hasSourceEntryTables()) {
            SourceDataDecorator.ENTRY_TABLE.registerLine(param);
        }
        if (param.hasSourceRefTables()) {
            SourceDataDecorator.REF_TABLE.registerLine(param);
        }
        if (param.hasReaderScript()) {
            SourceDataDecorator.SCRIPT.registerLine(param);
        }
        if (param.hasConfigSourceTsField()) {
            SourceDataDecorator.TIMESTAMP.registerLine(param);
        }
    }

    private void setSourceDataDecorator(SourceDataDecorator decorator) {
        this.sdd = this.sdd == null ? decorator : new CompositeSourceDataDecorator(this.sdd, decorator);
    }

    public static Pair<Evaluator, Boolean> getProxyUser(String user) {
        Evaluator eval;
        boolean has_dynamic_proxy_user;
        if (user == null) {
            has_dynamic_proxy_user = false;
            eval = EvaluatorFactory.NULL;
        } else if (user.startsWith("#{")) {
            has_dynamic_proxy_user = true;
            eval = EvaluatorFactory.get(user.substring(2, user.length() - 1), null, null);
        } else {
            has_dynamic_proxy_user = false;
            eval = EvaluatorFactory.get(null, user, null);
        }
        return new Pair((Object)eval, (Object)has_dynamic_proxy_user);
    }

    private void initParentField() {
        this.targetParentField = D.s((Object)this.schema.get("parent_field"));
        if (this.targetParentField != null) {
            this.defaultRootParent = D.s((Object)this.schema.get("default_root_parent"));
            String expr = D.s((Object)this.schema.get("root_node_creteria"));
            if (expr != null) {
                this.rootNodeCreteria = new DataCreteria(expr);
            }
            for (DynamicObject obj : (DynamicObjectCollection)this.schema.get(MAPPING_ENTRIES)) {
                String tar = D.s((Object)obj.get(MAPPING_TAR_COLUMN));
                String src = D.s((Object)obj.get(MAPPING_SRC_COLUMN));
                if (!this.targetParentField.equals(tar)) continue;
                this.checkSourceParentField(obj, tar, src);
                this.sourceParentField = src;
            }
        }
    }

    private void checkSourceParentField(DynamicObject obj, String tar, String src) {
        if (D.s((Object)obj.get(FIXED_VALUE)) != null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7531\u4e8e\u662f\u5c42\u6b21\u7ed3\u6784\u6570\u636e\uff0c\u76ee\u6807\u5bf9\u8c61\u7684\u4e0a\u7ea7\u5bf9\u8c61\uff08%s\uff09\u5b57\u6bb5\u4e0d\u80fd\u6307\u5b9a\u56fa\u5b9a\u503c\u3002", (String)"DataCopyParam_46", (String)"isc-iscb-platform-core", (Object[])new Object[0]), tar));
        }
        if (D.s((Object)obj.get("value_conver_rule")) != null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7531\u4e8e\u662f\u5c42\u6b21\u7ed3\u6784\u6570\u636e\uff0c\u76ee\u6807\u5bf9\u8c61\u7684\u4e0a\u7ea7\u5bf9\u8c61\uff08%s\uff09\u5b57\u6bb5\u4e0d\u9700\u8981\u8bbe\u7f6e\u503c\u8f6c\u6362\u89c4\u5219\u3002", (String)"DataCopyParam_47", (String)"isc-iscb-platform-core", (Object[])new Object[0]), tar));
        }
        if (src == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7531\u4e8e\u662f\u5c42\u6b21\u7ed3\u6784\u6570\u636e\uff0c\u76ee\u6807\u5bf9\u8c61\u7684\u4e0a\u7ea7\u5bf9\u8c61\uff08%s\uff09\u5b57\u6bb5\u5fc5\u987b\u6307\u5b9a\u6e90\u5bf9\u8c61\u5b57\u6bb5\u3002", (String)"DataCopyParam_48", (String)"isc-iscb-platform-core", (Object[])new Object[0]), tar));
        }
    }

    public boolean isRecordOidLog() {
        return this.record_oid_log;
    }

    public boolean isTraceAll() {
        return this.trace_all;
    }

    public String getSourceParentField() {
        return this.sourceParentField;
    }

    public List<DataCopyEvent> getEventHandlers(DataCopyEvent.Type type) {
        List<DataCopyEvent> list = this.event_handlers.get((Object)type);
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    public List<DataCopyMessageSender> getMessageHandlers(DataCopyEvent.Type type) {
        List<DataCopyMessageSender> list = this.message_handlers.get((Object)type);
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    public List<EventRequest> getIscEvenRequests(DataCopyEvent.Type type) {
        List<EventRequest> list = this.iscEventRequests.get((Object)type);
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    public String getTargetParentField() {
        return this.targetParentField;
    }

    @Override
    public String getProxyUser(Map<String, Object> data) {
        return DataCopyParam.evalProxyUser(this, this.proxy_user, data);
    }

    public static String evalProxyUser(DataCopyTransformer transformer, Evaluator expr, Map<String, Object> data) {
        Object proxy_user = expr.eval(transformer, data, null);
        if (proxy_user instanceof Object[]) {
            return D.s((Object)((Object[])proxy_user)[0]);
        }
        return D.s((Object)proxy_user);
    }

    public boolean hasDynamicProxyUser() {
        return this.has_dynamic_proxy_user;
    }

    public boolean recordOidMappings() {
        return this.record_oid_mappings;
    }

    public DataCreteria getTargetRootNodeCreteria() {
        return this.rootNodeCreteria;
    }

    public String getTargetDefaultRootParent() {
        return this.defaultRootParent;
    }

    @Override
    public synchronized Script getMappingScript() {
        Script s = this.mapping_script;
        if (s == null) {
            String t = this.mapping_script_text;
            if (t != null) {
                s = this.mapping_script = IscScript.compile(t, this.mappingScriptContext);
            }
            if (s != null) {
                this.setMappingScriptTimeOut(s);
            }
        }
        return s;
    }

    @Override
    public Map<String, Object> getMappingScriptContext() {
        HashMap<String, Object> ctx = new HashMap<String, Object>(this.mappingScriptContext.size());
        ctx.putAll(this.mappingScriptContext);
        return ctx;
    }

    public boolean hasReaderScript() {
        return this.reader_script_text != null;
    }

    @Override
    public synchronized Script getReaderScript() {
        String t;
        Script s = this.reader_script;
        if (s == null && (t = this.reader_script_text) != null) {
            s = this.reader_script = IscScript.compile(this.reader_script_text, this.srcScriptContext);
        }
        return s;
    }

    private void initSrcRetrieveScript() {
        this.srcDataRetrieveScriptStr = D.s((Object)this.schema.get("src_retrieve_script_tag"));
        if (this.srcDataRetrieveScriptStr == null) {
            this.srcDataRetrieveScriptStr = D.s((Object)this.schema.get("src_retrieve_script"));
        }
        if (this.srcDataRetrieveScriptStr != null) {
            this.srcDataRetrieveScript = IscScript.compile(this.srcDataRetrieveScriptStr, this.srcScriptContext);
        }
    }

    @Override
    public Script getSrcDataRetrieveScript() {
        return this.srcDataRetrieveScript;
    }

    @Override
    public synchronized List<String> getTargetActions() {
        if (this.target_actions == null) {
            this.initTargetActions();
        }
        return (List)this.target_actions.clone();
    }

    private void initTargetActions() {
        ArrayList<String> target_actions = new ArrayList<String>(2);
        LinkedHashMap<String, Object> target_params = new LinkedHashMap<String, Object>(2);
        for (DynamicObject i : this.schema.getDynamicObjectCollection("target_actions")) {
            String action = D.s((Object)i.getString("tar_action_number"));
            if ("_UPSERT".equals(action) && (!this.isBatchMode() || this.batchSize <= 1)) {
                throw new IscBizException(ResManager.loadKDString((String)"\u6279\u91cf\u6a21\u5f0f\u5f00\u542f\u60c5\u51b5\u4e0b\u624d\u5141\u8bb8\u4f7f\u7528_UPSERT\u64cd\u4f5c\uff0c\u8bf7\u5728\u201c\u542f\u52a8\u65b9\u6848\u201d\u7684\u7f16\u8f91\u9875\u9762\u8bbe\u7f6e\u201c\u76ee\u6807\u5355\u6279\u91cf\u5927\u5c0f\u201d\u540e\u518d\u91cd\u65b0\u5c1d\u8bd5\u3002", (String)"DataCopyParam_65", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            }
            if (action == null) continue;
            target_actions.add(action);
            this.setTargetActionParams(target_params, i, action);
        }
        if (target_actions.isEmpty()) {
            target_actions.add(TableAction._SAVE.name());
        }
        this.target_actions = target_actions;
        this.target_actions_params = target_params;
    }

    private void setTargetActionParams(Map<String, Object> target_params, DynamicObject i, String action) {
        String oparam = D.s((Object)i.getString("tar_action_params"));
        try {
            if (!StringUtil.isEmpty((String)oparam)) {
                target_params.put(action, Script.parseJson((String)oparam));
            }
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u5408\u6cd5\u7684\u64cd\u4f5c\u53c2\u6570\uff0c\u65e0\u6cd5\u5c06%s\u901a\u8fc7Json\u8f6c\u6362\u4e3amap\u683c\u5f0f", (String)"DataCopyParam_49", (String)"isc-iscb-platform-core", (Object[])new Object[0]), oparam), (Throwable)e);
        }
    }

    @Override
    public synchronized Map<String, Object> getTargetActionParams() {
        if (this.target_actions_params == null) {
            this.initTargetActions();
        }
        return new LinkedHashMap<String, Object>(this.target_actions_params);
    }

    @Override
    public String getSourcePrimaryKey() {
        return this.provider.getSourcePrimaryKey();
    }

    @Override
    public String getTargetPrimaryKey() {
        return this.consumer.getTargetPrimaryKey();
    }

    @Override
    public void saveTargetErrorLog(Throwable error, Map<String, Object> tar) {
        DataCopyTask.saveErrorLog(this, error, null, tar);
    }

    @Override
    public synchronized Map<String, Triple<Schema, String, String>> getSourceEntryTables() {
        if (this.source_entry_tables == null) {
            Object masterSchemaId = this.provider.getSourceSchema().getPkValue();
            this.source_entry_tables = this.selectEntryTables(masterSchemaId, this.getSourceConnection());
        }
        return this.source_entry_tables;
    }

    @Override
    public synchronized Map<String, Pair<Schema, String>> getSourceRefTables() {
        if (this.source_ref_tables == null) {
            this.source_ref_tables = this.selectRefTables();
        }
        return this.source_ref_tables;
    }

    @Override
    public synchronized Map<String, Pair<Table, String>> getTargetEntryTables() {
        this.initTargetEntryTables();
        return this.target_entry_tables;
    }

    private void initTargetEntryTables() {
        if (this.target_entry_tables == null) {
            Object masterSchemaId = this.consumer.getTargetSchema().getPkValue();
            Map<String, Triple<Schema, String, String>> tmp = this.selectEntryTables(masterSchemaId, this.getTargetConnection());
            HashMap<String, Pair<Table, String>> map = new HashMap<String, Pair<Table, String>>(tmp.size());
            for (Map.Entry<String, Triple<Schema, String, String>> e : tmp.entrySet()) {
                Table schema = (Table)e.getValue().getA();
                String masterField = (String)e.getValue().getB();
                map.put(e.getKey(), (Pair<Table, String>)new Pair((Object)schema, (Object)masterField));
            }
            this.target_entry_tables = map;
        }
    }

    @Override
    public synchronized Map<String, DataType> getSourceProperties() {
        if (this.source_properties == null) {
            this.source_properties = Util.getProperties(this.getSourceSchema());
        }
        return this.source_properties;
    }

    @Override
    public synchronized Map<String, DataType> getTargetProperties() {
        if (this.target_properties == null) {
            this.target_properties = Util.getProperties(this.getTargetSchema());
        }
        return this.target_properties;
    }

    @Override
    public synchronized Table findTargetEntryTable(String table_name) {
        this.initTargetEntryTables();
        Pair<Table, String> p = this.target_entry_tables.get(table_name);
        if (p != null) {
            return (Table)p.getA();
        }
        return null;
    }

    private Map<String, Triple<Schema, String, String>> selectEntryTables(Object masterSchemaId, ConnectionWrapper cn) {
        HashMap<String, Triple<Schema, String, String>> entry_tables = new HashMap<String, Triple<Schema, String, String>>();
        for (DynamicObject i : this.schema.getDynamicObjectCollection(RELATION_MAPPING)) {
            DynamicObject meta;
            Schema schema;
            if (!"entry_table".equals(i.get(RELATION_TYPE)) || !i.get(MASTER_TABLE_ID).equals(masterSchemaId) || (schema = this.getSchema(cn, meta = MetaDataSchema.get(i.getLong("data_table_id")))) == null) continue;
            String name = meta.getString("name");
            String master_field = D.s((Object)i.getString("master_field"));
            if (master_field == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u8868\uff08%s\uff09\u5fc5\u987b\u8bbe\u7f6e\u201c\u5f15\u7528\u6570\u636e\u8868\u5173\u8054\u5b57\u6bb5\u201d\uff01", (String)"DataCopyParam_50", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name));
            }
            if (schema.findField(master_field) == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u8868\uff08%1$s\uff09\u7684\u201c\u5f15\u7528\u6570\u636e\u8868\u5173\u8054\u5b57\u6bb5\uff08%2$s\uff09\u201d\u5728\u8868\u4e0a\u4e0d\u5b58\u5728\uff01", (String)"DataCopyParam_51", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name, master_field));
            }
            String orderBy = D.s((Object)i.get("entry_order_by"));
            String relation_alias = DataCopyParam.getRelationAlias(i, meta);
            entry_tables.put(relation_alias, (Triple<Schema, String, String>)new Triple((Object)schema, (Object)master_field, (Object)orderBy));
        }
        return entry_tables;
    }

    private Schema getSchema(ConnectionWrapper cn, DynamicObject meta) {
        Table schema;
        if ("STRUCT".equals(meta.get("type"))) {
            return null;
        }
        if ("TABLE".equals(meta.get("type"))) {
            String table_name = D.s((Object)meta.get(TABLE_NAME));
            schema = ConnectionManager.getTable(cn, table_name);
        } else if ("VIEW".equals(meta.get("type"))) {
            schema = ViewUtil.getSchema(meta, cn);
        } else {
            throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u5173\u7cfb\u6620\u5c04\u5206\u5f55\u5f15\u7528\u6570\u636e\u8868\u53ea\u652f\u6301\u6570\u636e\u8868\u6216\u8005\u89c6\u56fe,\u5f53\u524d\u4e3a%s", (String)"DataCopyParam_67", (String)"isc-iscb-platform-core", (Object[])new Object[0]), meta.getString("type")));
        }
        return schema;
    }

    public static String getRelationAlias(DynamicObject entry, DynamicObject meta) {
        String relation_alias = D.s((Object)entry.get("relation_alias"));
        if (relation_alias == null) {
            String table_name = D.s((Object)meta.get(TABLE_NAME));
            relation_alias = table_name != null ? table_name : D.s((Object)meta.get(NUMBER));
        }
        return relation_alias;
    }

    private Map<String, Pair<Schema, String>> selectRefTables() {
        Object masterSchemaId = this.getSourceSchema().getPkValue();
        ConnectionWrapper cn = this.getSourceConnection();
        HashMap<String, Pair<Schema, String>> entry_tables = new HashMap<String, Pair<Schema, String>>();
        for (DynamicObject i : this.schema.getDynamicObjectCollection(RELATION_MAPPING)) {
            DynamicObject meta;
            Schema schema;
            if (!"ref_table".equals(i.get(RELATION_TYPE)) || (schema = this.getSchema(cn, meta = MetaDataSchema.get(i.getLong("data_table_id")))) == null) continue;
            String master_ref_field = this.checkRefTable(meta, i, masterSchemaId);
            String relation_alias = DataCopyParam.getRelationAlias(i, meta);
            entry_tables.put(relation_alias, (Pair<Schema, String>)new Pair((Object)schema, (Object)master_ref_field));
        }
        return entry_tables;
    }

    private String checkRefTable(DynamicObject meta, DynamicObject entry, Object masterSchemaId) {
        String name = meta.getString("name");
        if (!entry.get(MASTER_TABLE_ID).equals(masterSchemaId)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u8868\uff08%s\uff09\u4e0d\u662f\u6e90\u5bf9\u8c61\u7684\u5916\u952e\u8868\uff0c\u53ea\u6709\u6e90\u5bf9\u8c61\u624d\u652f\u6301\u5916\u952e\u8868\uff01", (String)"DataCopyParam_52", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name));
        }
        String master_ref_field = D.s((Object)entry.get("master_ref_field"));
        if (master_ref_field == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5916\u952e\u8868\uff08%s\uff09\u5fc5\u987b\u8bbe\u7f6e\u201c\u4e3b\u6570\u636e\u8868\u5173\u8054\u5b57\u6bb5\u201d\uff01", (String)"DataCopyParam_53", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name));
        }
        return master_ref_field;
    }

    @Override
    public boolean isBreakOnError() {
        return this.breakOnError;
    }

    public void setResumeOnError() {
        if (this.rollbackOnError) {
            throw new IscBizException(ResManager.loadKDString((String)"\u8981\u6c42\u5355\u4e2a\u4e8b\u52a1\u7684\u6570\u636e\u96c6\u6210\u4efb\u52a1\uff0c\u4e0d\u53ef\u8bbe\u7f6e\u4e3a\u5931\u8d25\u65f6\u7ee7\u7eed\u6267\u884c\u3002", (String)"DataCopyParam_22", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        this.breakOnError = false;
    }

    @Override
    public DynamicObject getSourceSchema() {
        return this.provider.getSourceSchema();
    }

    @Override
    public DynamicObject getTargetSchema() {
        return this.consumer.getTargetSchema();
    }

    @Override
    public boolean isBatchMode() {
        return this.batch_write_mode;
    }

    public boolean isDisableTrace() {
        return this.disableTrace;
    }

    public boolean hasSourceEntryTables() {
        return this.has_source_entry_tables;
    }

    public boolean hasSourceRefTables() {
        return this.has_source_ref_tables;
    }

    @Override
    public List<String> getEntryJudgeFields(String table) {
        List<String> list = this.entryJudgeFields.get(table);
        if (list != null) {
            return list;
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u6307\u5b9a\uff08%s\uff09\u7684\u5019\u9009\u952e\u3002", (String)"DataCopyParam_54", (String)"isc-iscb-platform-core", (Object[])new Object[0]), table));
    }

    public boolean sourceFromMQ() {
        return "MQ".equals(this.trigger.get("source_protocal"));
    }

    @Override
    public boolean targetToMQ() {
        return this.trigger != null && "MQ".equals(this.trigger.get("target_protocal"));
    }

    @Override
    public boolean targetIsMQS() {
        return this.targetToMQ() && D.x((Object)this.trigger.get("ismqs"));
    }

    @Override
    public boolean sourceIsTable() {
        return this.provider.sourceIsTable();
    }

    @Override
    public boolean sourceIsView() {
        return this.provider.sourceIsView();
    }

    @Override
    public boolean sourceIsEntity() {
        return this.provider.sourceIsEntity();
    }

    @Override
    public boolean sourceIsQuery() {
        return this.provider.sourceIsQuery();
    }

    @Override
    public boolean sourceIsStruct() {
        return this.provider.sourceIsStruct();
    }

    @Override
    public boolean targetIsTable() {
        return this.consumer.targetIsTable();
    }

    @Override
    public boolean targetIsEntity() {
        return this.consumer.targetIsEntity();
    }

    @Override
    public boolean targetIsService() {
        return this.consumer.targetIsService();
    }

    private boolean initBatchMode() {
        if (!this.doCopyOnly()) {
            return false;
        }
        if (this.targetParentField != null) {
            return false;
        }
        if (this.batchSize == 1) {
            return false;
        }
        for (DynamicObject i : this.schema.getDynamicObjectCollection(RELATION_MAPPING)) {
            if (!i.get(MASTER_TABLE_ID).equals(this.consumer.getTargetSchema().getPkValue())) continue;
            return false;
        }
        int actions_size = this.schema_actions_entry.size();
        if (actions_size > 1) {
            return false;
        }
        if (!this.isBatchWriteModeScript() && !this.consumer.targetIsTable()) {
            return false;
        }
        return actions_size == 0 || TableAction.find((String)((DynamicObject)this.schema_actions_entry.get(0)).getString("tar_action_number")) != null;
    }

    public boolean isBatchWriteModeScript() {
        return this.batchSize > 1 && this.target_script != null && this.target_script.getProgram().getContext().get("_tars") != null;
    }

    public void checkMQMode() {
        if (this.trace_all && this.batchSize > 1) {
            throw new IscBizException(ResManager.loadKDString((String)"\u76ee\u6807\u4f20\u8f93\u65b9\u5f0f\u662f\u6d88\u606f\u961f\u5217\u4e14\u76ee\u6807\u6279\u91cf\u5927\u5c0f\u5927\u4e8e1\u65f6\uff0c\u65b9\u6848\u4e2d\u4e0d\u652f\u6301\u4ee5\u4e0b\u5185\u5bb9\uff1a", (String)"DataCopyParam_55", (String)"isc-iscb-platform-core", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"1.\u4fdd\u5b58\u5168\u90e8\u65e5\u5fd7\u3002", (String)"DataCopyParam_56", (String)"isc-iscb-platform-core", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"2.\u8bb0\u5f55\u5355\u636e\u96c6\u6210\u65e5\u5fd7\u3002", (String)"DataCopyParam_57", (String)"isc-iscb-platform-core", (Object[])new Object[0]) + "\n");
        }
    }

    private boolean doCopyOnly() {
        if (this.trace_all) {
            return false;
        }
        if (this.record_oid_mappings) {
            return false;
        }
        if (this.target_data_handler != null) {
            return false;
        }
        if (this.writeBackRuleId > 0L) {
            return false;
        }
        return this.targetParentField == null;
    }

    private boolean initHasSourceEntryTables() {
        Object src = this.provider.getSourceSchema().getPkValue();
        for (DynamicObject i : this.schema.getDynamicObjectCollection(RELATION_MAPPING)) {
            if (!"entry_table".equals(i.get(RELATION_TYPE)) || !i.get(MASTER_TABLE_ID).equals(src)) continue;
            return true;
        }
        return false;
    }

    private boolean initHasSourceRefTables() {
        Object src = this.provider.getSourceSchema().getPkValue();
        for (DynamicObject i : this.schema.getDynamicObjectCollection(RELATION_MAPPING)) {
            if (!"ref_table".equals(i.get(RELATION_TYPE)) || !i.get(MASTER_TABLE_ID).equals(src)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getTargetDataHandler() {
        return this.target_data_handler;
    }

    @Override
    public Script getTargetDataScript() {
        return this.target_script;
    }

    @Override
    public boolean isRollbackOnError() {
        return this.rollbackOnError;
    }

    @Override
    public DynamicObject getExecution() {
        return this.execution;
    }

    @Override
    public Pair<String, String> getTaskNumber() {
        if (this.getExecution() != null) {
            return new Pair((Object)"execution_number", (Object)((String)this.getExecution().get(NUMBER)));
        }
        if (this.getTrigger() != null) {
            return new Pair((Object)"trigger_number", (Object)((String)this.getTrigger().get(NUMBER)));
        }
        return new Pair((Object)"schema_number", (Object)((String)this.getSchema().get(NUMBER)));
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    public DynamicObject getSchema() {
        return this.schema;
    }

    @Override
    public List<Pair<String, String>> getOrderBy() {
        DynamicObjectCollection sort_entries = (DynamicObjectCollection)this.getSchema().get("sort_entries");
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>(sort_entries.size());
        for (DynamicObject dynamicObject : sort_entries) {
            String sort_field = dynamicObject.getString("sort_field");
            String filter_mode = dynamicObject.getString("sort_mode");
            list.add((Pair<String, String>)new Pair((Object)sort_field, (Object)filter_mode));
        }
        return list;
    }

    @Override
    public Map<String, Object> getSourceRequires() {
        return SQLUtil.prepareRequires(this.schema);
    }

    @Override
    public DynamicObject getTrigger() {
        return this.trigger;
    }

    @Override
    public Object getPushedData() {
        return this.pushedData;
    }

    public String getPushedDataLock() {
        return DataCopyParam.getPushedDataLock(this.pushedData);
    }

    public static String getPushedDataLock(Object pushedData) {
        if (pushedData instanceof List) {
            List list = (List)pushedData;
            Object object = pushedData = list.isEmpty() ? null : (Object)list.get(0);
        }
        if (pushedData instanceof Map) {
            String id = D.s(((Map)pushedData).get("$id"));
            return id == null ? null : "/isc/row_lock/" + id;
        }
        return null;
    }

    public DynamicObjectCollection getSchemaActionsEntry() {
        return this.schema_actions_entry;
    }

    @Override
    public Map<String, Object> getFilterParams() {
        DynamicObjectCollection c;
        Map<String, Object> params = this.filter_params;
        if (!CollectionUtils.isEmpty(params)) {
            return params;
        }
        if (this.taskStage != null) {
            c = this.taskStage.getDynamicObjectCollection(PARAMS_ENTRYENTITY);
        } else if (this.execution != null) {
            c = this.execution.getDynamicObjectCollection(PARAMS_ENTRYENTITY);
        } else if (this.trigger != null) {
            c = this.trigger.getDynamicObjectCollection(PARAMS_ENTRYENTITY);
        } else {
            if (this.schema != null) {
                DynamicObjectCollection c2 = this.schema.getDynamicObjectCollection(PARAM_ENTRIES);
                if (c2.size() == 0) {
                    return new HashMap<String, Object>();
                }
                throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848\uff08%s\uff09\u6709\u53c2\u6570\uff0c\u4e0d\u652f\u6301\u5f53\u524d\u573a\u666f\u4e0b\u8c03\u7528\uff01", (String)"DataCopyParam_58", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.schema.get(NUMBER)));
            }
            throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u6ca1\u6709\u542f\u52a8\u65b9\u6848\u6216\u96c6\u6210\u65b9\u6848\uff0c\u7981\u6b62\u8c03\u7528\u672c\u65b9\u6cd5\uff01", (String)"DataCopyParam_29", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        params = new HashMap<String, Object>();
        for (DynamicObject item : c) {
            String name = D.s((Object)item.get("params_name"));
            String value = D.s((Object)item.get("params_value"));
            params.put(name, value);
        }
        return params;
    }

    public Map<String, Object> getFilterParamsForDebug() {
        DynamicObjectCollection c;
        Map<String, Object> params = this.filter_params;
        if (!CollectionUtils.isEmpty(params)) {
            return params;
        }
        if (this.taskStage != null) {
            c = this.taskStage.getDynamicObjectCollection(PARAMS_ENTRYENTITY);
        } else if (this.execution != null) {
            c = this.execution.getDynamicObjectCollection(PARAMS_ENTRYENTITY);
        } else if (this.trigger != null) {
            c = this.trigger.getDynamicObjectCollection(PARAMS_ENTRYENTITY);
        } else {
            return null;
        }
        params = new HashMap<String, Object>();
        for (DynamicObject item : c) {
            String name = D.s((Object)item.get("params_name"));
            String value = D.s((Object)item.get("params_value"));
            params.put(name, value);
        }
        return params;
    }

    @Override
    public Counter getCounter() {
        return this.counter;
    }

    @Override
    public synchronized Object getSsid() {
        if (this.ssid == null) {
            long data_source_id = this.getSourceSystemDataSourceId();
            long dblink_id = DataSource.get(data_source_id).getDbLink();
            DynamicObject dblink = ConnectionConfig.getConfig(dblink_id);
            this.ssid = dblink.get("source_system_id");
            if (this.ssid == null) {
                this.ssid = "";
            }
        }
        return this.ssid;
    }

    public long getSourceDataSourceId() {
        return this.getSourceSystemDataSourceId();
    }

    public long getTargetDataSourceId() {
        return this.getTargetSystemDataSourceId();
    }

    @Override
    public synchronized String getJudgeField() {
        this.initJudgeFields();
        return this.judgeField;
    }

    @Override
    public Pair<String, String> getTaskInfo() {
        String name = this.getSchema().getString("name");
        String number = this.getSchema().getString(NUMBER);
        return new Pair((Object)name, (Object)number);
    }

    @Override
    public synchronized List<String> getJudgeFields() {
        this.initJudgeFields();
        return this.judgeFields;
    }

    public synchronized List<String> getSourceJudgeFields() {
        this.initJudgeFields();
        return this.srcJudgeFields;
    }

    @Override
    public synchronized Collection<String> getTargetFields(String table_name) {
        Set<String> fields;
        if (this.targetFields == null) {
            this.initTargetFields();
        }
        if ((fields = this.targetFields.get(table_name)) == null) {
            return null;
        }
        return Collections.unmodifiableCollection(fields);
    }

    private void initTargetFields() {
        this.targetFields = new HashMap<String, Set<String>>();
        DynamicObjectCollection mapping_collection = (DynamicObjectCollection)this.schema.get(MAPPING_ENTRIES);
        for (DynamicObject obj : mapping_collection) {
            String fixed_value = D.s((Object)obj.get(FIXED_VALUE));
            String src_field = D.s((Object)obj.get(MAPPING_SRC_COLUMN));
            String tar_field = D.s((Object)obj.get(MAPPING_TAR_COLUMN));
            if (fixed_value == null && src_field == null || tar_field == null) continue;
            int i = tar_field.indexOf(46);
            if (i > 0) {
                this.registerTargetField(tar_field.substring(0, i), tar_field.substring(i + 1));
                continue;
            }
            this.registerTargetField("", tar_field);
        }
    }

    private void registerTargetField(String table, String field) {
        Set<String> fields = this.targetFields.get(table);
        if (fields == null) {
            fields = new LinkedHashSet<String>();
            this.targetFields.put(table, fields);
        }
        fields.add(field);
    }

    @Override
    public synchronized ConnectionWrapper getSourceConnection() {
        this.initSource();
        return this.src_connection;
    }

    @Override
    public Table getSourceTable() {
        return this.provider.getSourceTable();
    }

    @Override
    public synchronized ConnectionWrapper getTargetConnection() {
        this.initTarget();
        return this.tar_connection;
    }

    @Override
    public boolean supportsBizBatchAction() {
        if (this.batchSize <= 1) {
            return false;
        }
        if (this.targetParentField != null) {
            return false;
        }
        if (!this.doCopyOnly()) {
            return false;
        }
        if (this.hasDynamicProxyUser()) {
            return false;
        }
        if (this.getTargetActions().size() > 1) {
            return false;
        }
        if (this.event_handlers.containsKey((Object)DataCopyEvent.Type.OnRowFailed) || this.event_handlers.containsKey((Object)DataCopyEvent.Type.OnRowSuccess)) {
            return false;
        }
        if (!this.message_handlers.isEmpty()) {
            return false;
        }
        ConnectionWrapper cn = this.getTargetConnection();
        return cn.getFactory().supportsBizBatchAction(cn);
    }

    @Override
    public boolean supportsFileCopy() {
        return this.supports_file_copy;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    public String getMutex() {
        return this.mutex;
    }

    @Override
    public Table getTargetTable() {
        return this.consumer.getTargetTable();
    }

    private synchronized void initSource() {
        if (this.src_connection == null) {
            long dataSourceId = this.getSourceSystemDataSourceId();
            DataSource dataSource = DataSource.get(dataSourceId);
            ConnectionManager.pushResLicense(IscLicenseUtil.resHasLicense(this.schema));
            try {
                long dbLink = dataSource.getDbLink();
                this.src_connection = ConnectionManager.getConnection(dbLink);
            }
            catch (Exception e) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684\u6570\u636e\u6e90\u3010%1$s(%2$s)\u3011\u662f\u5426\u914d\u7f6e\u6b63\u786e\uff01", (String)"DataCopyParam_59", (String)"isc-iscb-platform-core", (Object[])new Object[0]), dataSource.getConfig().getString("name"), dataSource.getNumber()), (Throwable)e);
            }
            finally {
                ConnectionManager.popResLicense();
            }
        }
    }

    private long getSourceSystemDataSourceId() {
        long dataSourceId = 0L;
        if (this.execution != null && this.execution.getLong("real_source_system_id") != 0L) {
            dataSourceId = this.execution.getLong("real_source_system_id");
        } else if (this.trigger != null && this.trigger.getLong("new_source_system_id") != 0L) {
            dataSourceId = this.trigger.getLong("new_source_system_id");
        } else if (this.schema.getLong(DATA_SOURCE_ID) != 0L) {
            dataSourceId = this.schema.getLong(DATA_SOURCE_ID);
        }
        if (dataSourceId == 0L) {
            throw new IscBizException(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8fde\u63a5\u5931\u8d25\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u6b63\u786e\u7684\u6e90\u7cfb\u7edf", (String)"DataCopyParam_32", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return dataSourceId;
    }

    @Override
    public String getSourceTableName() {
        return this.provider.getSourceTableName();
    }

    private synchronized void initTarget() {
        if (this.tar_connection == null) {
            long dataSourceId = this.getTargetSystemDataSourceId();
            DataSource dataSource = DataSource.get(dataSourceId);
            ConnectionManager.pushResLicense(IscLicenseUtil.resHasLicense(this.schema));
            try {
                long dbLink = dataSource.getDbLink();
                this.tar_connection = ConnectionManager.getConnection(dbLink);
            }
            catch (Exception e) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684\u6570\u636e\u6e90\u3010%1$s(%2$s)\u3011\u662f\u5426\u914d\u7f6e\u6b63\u786e\uff01", (String)"DataCopyParam_59", (String)"isc-iscb-platform-core", (Object[])new Object[0]), dataSource.getConfig().getString("name"), dataSource.getNumber()), (Throwable)e);
            }
            finally {
                ConnectionManager.popResLicense();
            }
        }
    }

    private long getTargetSystemDataSourceId() {
        long dataSourceId = 0L;
        if (this.execution != null && this.execution.getLong("real_target_system_id") != 0L) {
            dataSourceId = this.execution.getLong("real_target_system_id");
        } else if (this.trigger != null && this.trigger.getLong("new_target_system_id") != 0L) {
            dataSourceId = this.trigger.getLong("new_target_system_id");
        } else if (this.schema.getLong(DATA_TARGET_ID) != 0L) {
            dataSourceId = this.schema.getLong(DATA_TARGET_ID);
        }
        if (dataSourceId == 0L) {
            throw new IscBizException(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8fde\u63a5\u5931\u8d25\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u6b63\u786e\u7684\u76ee\u6807\u7cfb\u7edf", (String)"DataCopyParam_33", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return dataSourceId;
    }

    @Override
    public String getTargetTableName() {
        return this.consumer.getTargetTableName();
    }

    private void initJudgeFields() {
        if (this.judgeFields == null) {
            this.selectJudgeFields();
            this.initJudgeField();
            if (this.judgeFields.size() == 0 && !this.targetIsService()) {
                throw new IscBizException(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848\u6ca1\u6709\u6307\u5b9a\u7528\u4e8e\u5224\u65ad\u6570\u636e\u662f\u5426\u5b58\u5728\u6240\u9700\u7684\u5019\u9009\u952e\u3002", (String)"DataCopyParam_34", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            }
            Collections.sort(this.judgeFields);
        }
    }

    public synchronized void setNoJudgeFields() {
        if (this.judgeFields != null) {
            throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u5019\u9009\u952e\u5b57\u6bb5\u5df2\u7ecf\u521d\u59cb\u5316\uff01", (String)"DataCopyParam_35", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        this.judgeFields = Collections.emptyList();
    }

    private void initJudgeField() {
        if (this.judgeField == null && this.judgeFields.size() == 1) {
            this.judgeField = this.judgeFields.get(0);
        }
    }

    private void selectJudgeFields() {
        this.judgeFields = new ArrayList<String>();
        this.srcJudgeFields = new ArrayList<String>();
        DynamicObjectCollection mapping_collection = (DynamicObjectCollection)this.schema.get(MAPPING_ENTRIES);
        for (DynamicObject obj : mapping_collection) {
            String fixed_value = D.s((Object)obj.get(FIXED_VALUE));
            String src_field = D.s((Object)obj.get(MAPPING_SRC_COLUMN));
            String tar_field = D.s((Object)obj.get(MAPPING_TAR_COLUMN));
            if (tar_field == null) continue;
            int i = tar_field.lastIndexOf(46);
            if (i > 0) {
                this.setEntryJudgeField(obj, tar_field, i);
                continue;
            }
            this.setMainJudgeField(obj, fixed_value, tar_field, src_field);
        }
    }

    private void setMainJudgeField(DynamicObject obj, String fixed_value, String tar_field, String src_field) {
        if (D.x((Object)obj.get("candidate_key"))) {
            if (tar_field != null && !this.judgeFields.contains(tar_field)) {
                this.judgeFields.add(tar_field);
            }
            if (src_field != null && !this.srcJudgeFields.contains(src_field)) {
                this.srcJudgeFields.add(src_field);
            }
        }
        if (DataCopyParam.isIdentifierField(fixed_value)) {
            this.judgeField = tar_field;
        }
    }

    private void setEntryJudgeField(DynamicObject obj, String tar_field, int i) {
        if (D.x((Object)obj.get("candidate_key"))) {
            String entry = tar_field.substring(0, i);
            String field = tar_field.substring(i + 1);
            List<String> fields = this.entryJudgeFields.get(entry);
            if (fields == null) {
                fields = new ArrayList<String>(2);
                this.entryJudgeFields.put(entry, fields);
            }
            if (!fields.contains(field)) {
                fields.add(field);
            }
        }
    }

    @Override
    public Map<String, List<String>> getTargetJudgeFields() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        String jf = this.getJudgeField();
        map.put("$", jf != null ? Collections.singletonList(jf) : this.getJudgeFields());
        map.putAll(this.entryJudgeFields);
        return map;
    }

    public static boolean isIdentifierField(String expr) {
        if ("#{md5($keys)}".equals(expr)) {
            return true;
        }
        if ("#{mur($keys)}".equals(expr)) {
            return true;
        }
        if ("#{mur32($keys)}".equals(expr)) {
            return true;
        }
        if ("#{md5s18($keys)}".equals(expr)) {
            return true;
        }
        return expr != null && expr.startsWith("#{boid($keys,");
    }

    public synchronized void dispose() {
        ConnectorUtil.close(this.src_connection);
        ConnectorUtil.close(this.tar_connection);
        ConnectorUtil.close(this.this_connection);
        this.src_connection = null;
        this.tar_connection = null;
        this.this_connection = null;
    }

    public long getWriteBackRuleId() {
        return this.writeBackRuleId;
    }

    @Override
    public DataType getTargetPropertyDataType(String[] path) {
        Map<String, Object> properties = this.getTargetProperties();
        DataType type = null;
        for (String name : path) {
            if (properties == null) {
                return SimpleValueType.INS;
            }
            type = properties.get(name);
            if (type == null) {
                return SimpleValueType.INS;
            }
            properties = type instanceof EntryCollectionType ? ((EntryCollectionType)type).getProperties() : null;
        }
        return type;
    }

    @Override
    public String findTargetEntryPK(String[] path) {
        Table table;
        if (this.targetIsTable()) {
            Table table2 = this.getTargetEntryTable(path[0]);
            return table2.getPrimaryKeyName();
        }
        if (path.length == 1 && (table = this.findTargetEntryTable(path[0])) != null) {
            return table.getPrimaryKeyName();
        }
        DataType type = this.getTargetPropertyDataType(path);
        if (type instanceof EntryCollectionType) {
            return ((EntryCollectionType)type).getPrimaryKey();
        }
        return null;
    }

    @Override
    public SourceDataDecorator getSourceDataDecorator() {
        return this.sdd;
    }

    public int getThreadUBound() {
        if (this.isDebug()) {
            return 1;
        }
        return this.thread_ubound;
    }

    @Override
    public List<Map<String, Object>> prepareFilter() {
        if (this.pushedFilter != null) {
            return (List)Json.copy(this.pushedFilter);
        }
        Map<String, Object> params = this.getFilterParams();
        DynamicObjectCollection filter_entries_schema = (DynamicObjectCollection)this.getSchema().get("filter_entries");
        DynamicObjectCollection filter_entries_trigger = this.trigger != null ? (DynamicObjectCollection)this.getTrigger().get("filter_entries") : new DynamicObjectCollection();
        List<Map<String, Object>> filter1 = this.prepareFilter(params, filter_entries_schema);
        List<Map<String, Object>> filter2 = this.prepareFilter(params, filter_entries_trigger);
        if (filter1.isEmpty()) {
            return filter2;
        }
        if (filter2.isEmpty()) {
            return filter1;
        }
        return this.merge(filter1, filter2);
    }

    private List<Map<String, Object>> merge(List<Map<String, Object>> filter1, List<Map<String, Object>> filter2) {
        this.addLeftBracket(filter1);
        this.addLeftBracket(filter2);
        this.addRightBracket(filter1);
        this.addRightBracket(filter2);
        this.setFilterLink(filter1);
        filter1.addAll(filter2);
        return filter1;
    }

    private void setFilterLink(List<Map<String, Object>> filter1) {
        Map<String, Object> item = filter1.get(filter1.size() - 1);
        item.put(FILTER_LINK, "AND");
    }

    private void addRightBracket(List<Map<String, Object>> filter) {
        Map<String, Object> item = filter.get(filter.size() - 1);
        String s = D.s((Object)item.get(FILTER_RIGHT_BRACKET));
        s = s == null ? ")" : s + ")";
        item.put(FILTER_RIGHT_BRACKET, s);
    }

    private void addLeftBracket(List<Map<String, Object>> filter) {
        Map<String, Object> item = filter.get(0);
        String s = D.s((Object)item.get(FILTER_LEFT_BRACKET));
        s = s == null ? "(" : "(" + s;
        item.put(FILTER_LEFT_BRACKET, s);
    }

    private List<Map<String, Object>> prepareFilter(Map<String, Object> params, DynamicObjectCollection filter_entries) {
        ArrayList<Map<String, Object>> filter = new ArrayList<Map<String, Object>>();
        for (DynamicObject obj : filter_entries) {
            Object filter_column = obj.get(FILTER_COLUMN);
            Object compare = obj.get(FILTER_COMPARE);
            Object value = this.parseFilterValue(params, obj);
            this.checkFilterValue(filter_column, compare, value);
            if (value instanceof ValueRange) {
                this.handleValueRange(filter, obj, filter_column, (ValueRange)value);
                continue;
            }
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put(FILTER_LEFT_BRACKET, obj.get(FILTER_LEFT_BRACKET));
            item.put(FILTER_COLUMN, filter_column);
            item.put(FILTER_COMPARE, compare);
            item.put(FILTER_VALUE, value);
            item.put(FILTER_RIGHT_BRACKET, obj.get(FILTER_RIGHT_BRACKET));
            item.put(FILTER_LINK, obj.get(FILTER_LINK));
            filter.add(item);
        }
        return filter;
    }

    private void handleValueRange(List<Map<String, Object>> filter, DynamicObject obj, Object filter_column, ValueRange<?> value) {
        ValueRange<?> range = value;
        HashMap<String, Object> item = new HashMap<String, Object>();
        String leftBracket = D.s((Object)obj.get(FILTER_LEFT_BRACKET));
        String rightBracket = D.s((Object)obj.get(FILTER_RIGHT_BRACKET));
        item.put(FILTER_LEFT_BRACKET, leftBracket == null ? "(" : "(" + leftBracket);
        item.put(FILTER_COLUMN, filter_column);
        item.put(FILTER_COMPARE, ">=");
        item.put(FILTER_VALUE, range.getLBound());
        item.put(FILTER_LINK, "AND");
        filter.add(item);
        item = new HashMap();
        item.put(FILTER_COLUMN, filter_column);
        item.put(FILTER_COMPARE, "<=");
        item.put(FILTER_VALUE, range.getUBound());
        item.put(FILTER_RIGHT_BRACKET, rightBracket == null ? ")" : rightBracket + ")");
        item.put(FILTER_LINK, obj.get(FILTER_LINK));
        filter.add(item);
    }

    private Object parseFilterValue(Map<String, Object> params, DynamicObject obj) {
        Object value = obj.get("filter_value_fixed");
        value = this.getFilterValue(params, obj, value);
        value = ExprEvaluator.calc(value, this, null, null);
        return value;
    }

    private void checkFilterValue(Object filter_column, Object compare, Object value) {
        if (value == null && !"IS_NULL".equals(compare) && !"IS_NOT_NULL".equals(compare)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6761\u4ef6\u5b57\u6bb5(%s)\u6ca1\u6709\u8bbe\u7f6e\u6bd4\u8f83\u503c\uff01", (String)"DataCopyParam_60", (String)"isc-iscb-platform-core", (Object[])new Object[0]), filter_column));
        }
    }

    private Object getFilterValue(Map<String, Object> params, DynamicObject obj, Object value) {
        if (D.s((Object)value) != null) {
            return value;
        }
        String filter_value_var = obj.getString("filter_value_var");
        return params.get(filter_value_var);
    }

    @Override
    public DynamicObject getPublisherQueue() {
        long id = D.l((Object)this.trigger.get("publisher_queue_id"));
        if (id == 0L) {
            throw new IscBizException(ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u6848\u6ca1\u6709\u914d\u7f6e\u201c\u6d88\u606f\u53d1\u5e03\u4e3b\u9898\u201d\uff01", (String)"DataCopyParam_38", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return PublishTopicSchema.get(id).getConfig();
    }

    @Override
    public List<DynamicObject> getPublisherQueueList() {
        DynamicObjectCollection collection = (DynamicObjectCollection)this.trigger.get("publisher_queues");
        if (collection.size() == 0) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u542f\u52a8\u65b9\u6848\u6ca1\u6709\u914d\u7f6e\u201c\u6d88\u606f\u53d1\u5e03\u4e3b\u9898\u201d", (String)"DataCopyParam_61", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.trigger.get(NUMBER)));
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (DynamicObject object : collection) {
            DynamicObject obj = (DynamicObject)object.get(1);
            long id = D.l((Object)obj.getPkValue());
            list.add(PublishTopicSchema.get(id).getConfig());
        }
        return list;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public int[] getRetryIntervals() {
        return this.retryIntervals;
    }

    public synchronized ConnectionWrapper getThisConnection() {
        if (this.this_connection == null) {
            this.this_connection = new JdbcConnectionWrapper(new SelfConnection(), new SelfConnectionFactory(), null);
        }
        return this.this_connection;
    }

    private void initTaskSize() {
        if (this.trigger != null) {
            int v = D.i((Object)this.trigger.getInt("taskSize"));
            if (v > 0) {
                this.taskSize = Math.max(v, 500);
            }
        } else {
            this.taskSize = 0;
        }
    }

    public int getTaskSize() {
        return this.taskSize;
    }

    public String getSchemaNumber() {
        if (this.schema != null) {
            return this.schema.getString(NUMBER);
        }
        return null;
    }

    public void initMaxErrorLogRecordCount() {
        int logRecordCount;
        this.maxErrorLogRecordCount = this.trigger == null ? Integer.MAX_VALUE : ((logRecordCount = D.i((Object)this.trigger.get("log_record_count"))) <= 0 ? 500 : logRecordCount);
    }

    public int getMaxErrorLogRecordCount() {
        return this.maxErrorLogRecordCount;
    }

    @Override
    public String getDataProducerDesc() {
        DynamicObject t = this.getTrigger();
        if (t != null) {
            return StringUtil.trim((String)("T:" + t.getString(NUMBER)), (int)50);
        }
        DynamicObject s = this.getSchema();
        return StringUtil.trim((String)("S:" + s.getString(NUMBER)), (int)50);
    }

    public void setMaxCount(int maxCount) {
        if (this.maxCount != Integer.MAX_VALUE) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5141\u8bb8\u8bfb\u53d6\u7684\u6700\u5927\u884c\u6570\u5df2\u8bbe\u7f6e\u4e3a\uff08%s\uff09\uff0c\u4e0d\u53ef\u6539\u5199\uff01", (String)"DataCopyParam_62", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.maxCount));
        }
        this.maxCount = maxCount;
    }

    @Override
    public int getMaxCount() {
        return this.maxCount;
    }

    public Pair<TraceType, DynamicObject> getTraceInfo() {
        if (this.getExecution() != null) {
            return new Pair((Object)TraceType.EXE_DCE, (Object)this.getExecution());
        }
        if (this.getTrigger() != null) {
            return new Pair((Object)TraceType.EXE_DCT, (Object)this.getTrigger());
        }
        return new Pair((Object)TraceType.EXE_DCS, (Object)this.getSchema());
    }

    private void setMappingScriptTimeOut(Script script) {
        int scriptTimeout = D.i((Object)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)AppParameterServiceHelper.getAppParam(), (String)"script_timeout"));
        if (scriptTimeout > 0) {
            script.setTimeout(scriptTimeout * 1000);
        }
    }

    private AbstractDataCopyProvider createDataCopyProvider(long src_schema_id) {
        return new AbstractDataCopyProvider(MetaDataSchema.get(src_schema_id)){

            @Override
            public Pair<String, String> getTaskNumber() {
                return DataCopyParam.this.getTaskNumber();
            }

            @Override
            public Counter getCounter() {
                return DataCopyParam.this.getCounter();
            }

            @Override
            public SourceDataDecorator getSourceDataDecorator() {
                return DataCopyParam.this.getSourceDataDecorator();
            }

            @Override
            public Object getPushedData() {
                return DataCopyParam.this.getPushedData();
            }

            @Override
            public Script getReaderScript() {
                return DataCopyParam.this.getReaderScript();
            }

            @Override
            public Map<String, Object> getSourceRequires() {
                return DataCopyParam.this.getSourceRequires();
            }

            @Override
            public Script getSrcDataRetrieveScript() {
                return DataCopyParam.this.getSrcDataRetrieveScript();
            }

            @Override
            public Map<String, Object> getFilterParams() {
                return DataCopyParam.this.getFilterParams();
            }

            @Override
            public List<Map<String, Object>> prepareFilter() {
                return DataCopyParam.this.prepareFilter();
            }

            @Override
            public boolean supportsFileCopy() {
                return DataCopyParam.this.supportsFileCopy();
            }

            @Override
            public String getSourceTsField() {
                return DataCopyParam.this.getSourceTsField();
            }

            @Override
            public boolean hasConfigSourceTsField() {
                return DataCopyParam.this.hasConfigSourceTsField();
            }

            @Override
            public String getExecutionId() {
                return DataCopyParam.this.getExecutionId();
            }

            @Override
            public List<Pair<String, String>> getOrderBy() {
                return DataCopyParam.this.getOrderBy();
            }

            @Override
            public Map<String, Pair<Schema, String>> getSourceRefTables() {
                return DataCopyParam.this.getSourceRefTables();
            }

            @Override
            public Map<String, Triple<Schema, String, String>> getSourceEntryTables() {
                return DataCopyParam.this.getSourceEntryTables();
            }

            @Override
            public ConnectionWrapper getSourceConnection() {
                return DataCopyParam.this.getSourceConnection();
            }

            @Override
            public int getMaxCount() {
                return DataCopyParam.this.getMaxCount();
            }
        };
    }

    private AbstractDataCopyConsumer createDataCopyConsumer(long tar_schema_id) {
        return new AbstractDataCopyConsumer(MetaDataSchema.get(tar_schema_id)){

            @Override
            public Counter getCounter() {
                return DataCopyParam.this.getCounter();
            }

            @Override
            public Map<String, List<String>> getTargetJudgeFields() {
                return DataCopyParam.this.getTargetJudgeFields();
            }

            @Override
            public void saveTargetErrorLog(Throwable error, Map<String, Object> tar) {
                DataCopyParam.this.saveTargetErrorLog(error, tar);
            }

            @Override
            public List<String> getJudgeFields() {
                return DataCopyParam.this.getJudgeFields();
            }

            @Override
            public boolean targetToMQ() {
                return DataCopyParam.this.targetToMQ();
            }

            @Override
            public boolean targetIsMQS() {
                return DataCopyParam.this.targetIsMQS();
            }

            @Override
            public String getDataProducerDesc() {
                return DataCopyParam.this.getDataProducerDesc();
            }

            @Override
            public String getTargetDataHandler() {
                return DataCopyParam.this.getTargetDataHandler();
            }

            @Override
            public Script getTargetDataScript() {
                return DataCopyParam.this.getTargetDataScript();
            }

            @Override
            public boolean isBatchMode() {
                return DataCopyParam.this.isBatchMode();
            }

            @Override
            public boolean isRollbackOnError() {
                return DataCopyParam.this.isRollbackOnError();
            }

            @Override
            public boolean isBreakOnError() {
                return DataCopyParam.this.isBreakOnError();
            }

            @Override
            public Map<String, Pair<Table, String>> getTargetEntryTables() {
                return DataCopyParam.this.getTargetEntryTables();
            }

            @Override
            public boolean supportsBizBatchAction() {
                return DataCopyParam.this.supportsBizBatchAction();
            }

            @Override
            public DynamicObject getPublisherQueue() {
                return DataCopyParam.this.getPublisherQueue();
            }

            @Override
            public List<DynamicObject> getPublisherQueueList() {
                return DataCopyParam.this.getPublisherQueueList();
            }

            @Override
            public ConnectionWrapper getTargetConnection() {
                return DataCopyParam.this.getTargetConnection();
            }

            @Override
            public Collection<String> getTargetFields(String table_name) {
                return DataCopyParam.this.getTargetFields(table_name);
            }

            @Override
            public String getProxyUser(Map<String, Object> data) {
                return DataCopyParam.this.getProxyUser(data);
            }

            @Override
            public List<String> getTargetActions() {
                return DataCopyParam.this.getTargetActions();
            }

            @Override
            public Map<String, Object> getTargetActionParams() {
                return DataCopyParam.this.getTargetActionParams();
            }

            @Override
            public int getBatchSize() {
                return DataCopyParam.this.getBatchSize();
            }

            @Override
            public Pair<String, String> getTaskInfo() {
                return DataCopyParam.this.getTaskInfo();
            }

            @Override
            public Map<String, Object> getFilterParams() {
                return DataCopyParam.this.getFilterParams();
            }
        };
    }

    public DataCopyDebuggableResource getDebuggableResource() {
        DataCopyDebuggableResource res = this.res;
        if (res == null) {
            String id = D.s((Object)this.getSchema().get("id"));
            this.res = res = new DataCopyDebuggableResource(id);
        }
        return res;
    }

    public boolean isDebug() {
        if (this.execution == null) {
            return false;
        }
        return DataCopyDebugger.isDebug(this.execution.getString(NUMBER));
    }

    private void innerRegisterLine() {
        if (this.isDebug()) {
            DataCopyDebugger.registerLine(this, "", "// " + this.schema.get("name"));
            DataCopyInput.registerLine(this);
            DataCopyDebugger.registerLine(this, "", "{");
            DataCopyParam.registerDecoratorLine(this);
            DataCopyInput.registerLine2(this);
            DataCopyAttachment.registerLine(this);
            DataCopyMapping.registerLine(this);
            DataCopyOutput.registerLine(this);
            DataCopyDebugger.registerLine(this, "", "}");
            DataCopyDebugger.registerLine(this, "", ResManager.loadKDString((String)"// \u5728\u201c\u8868\u8fbe\u5f0f\u201d\u8f93\u5165 #vars \u67e5\u8be2\u73af\u5883\u53d8\u91cf\u5217\u8868", (String)"DataCopyParam_64", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }

    public boolean isFree() {
        return this.getSourceConnection().isFree() && this.getTargetConnection().isFree();
    }
}

