/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.platform.core.dc.meta.DataCopyProvider;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.script.misc.StringUtil;

public class DataCopyTsLog {
    private static Log logger = LogFactory.getLog(DataCopyTsLog.class);
    public static final String ENTITY_NAME = "isc_data_ts_log";
    public static final String SYSTEM = "system";
    public static final String REPOSITORY = "repository";
    public static final String OID = "oid";
    public static final String JUDGEFIELDS = "judgefields";
    public static final String TIMESTAMP = "timestamp";
    public static final String TASK = "task";
    public static final String TASK_ID = "task_id";
    public static final String TIME = "time";
    public static final String ID = "id";
    private static final String SELECT_FIELDS = "id,system,system_id,repository,oid,judgefields,timestamp,task,task_id,time";
    private static final int MAX_LENGTH = 100;

    public static long generateTsLogId(long linkId, String tableName, String oid) {
        String str = linkId + tableName + oid;
        return Math.abs(Hash.mur64((byte[])str.getBytes(StandardCharsets.UTF_8)));
    }

    public static DynamicObject queryTsLog(DataCopyProvider param, Map<String, Object> src) {
        String oid = DataCopyTsLog.getOid(param, src);
        long linkId = D.l((Object)param.getSourceConnection().getConfig().getPkValue());
        String sourceTableName = DataCopyTsLog.getTableName(param, oid);
        long tsLogId = DataCopyTsLog.generateTsLogId(linkId, sourceTableName, oid);
        return QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)SELECT_FIELDS, (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)tsLogId)});
    }

    public static void saveTsLog(DataCopyParam param, Map<String, Object> src) {
        if (param.hasConfigSourceTsField()) {
            try {
                String oid = DataCopyTsLog.getOid(param, src);
                long linkId = D.l((Object)param.getSourceConnection().getConfig().getPkValue());
                String sourceTableName = DataCopyTsLog.getTableName(param, oid);
                long tsLogId = DataCopyTsLog.generateTsLogId(linkId, sourceTableName, oid);
                if (!QueryServiceHelper.exists((String)ENTITY_NAME, (Object)tsLogId)) {
                    DataCopyTsLog.insertLog(param, src, oid, linkId, sourceTableName, tsLogId);
                } else {
                    DataCopyTsLog.updateLog(param, src, tsLogId);
                }
            }
            catch (Throwable e) {
                logger.warn("\u6e90\u5355\u6570\u636e: " + src + ",\u4fdd\u5b58\u65f6\u95f4\u6233\u65e5\u5fd7\u51fa\u9519: ", e);
            }
        }
    }

    private static void updateLog(DataCopyParam param, Map<String, Object> src, long tsLogId) {
        DynamicObject tsLog = BusinessDataServiceHelper.loadSingle((Object)tsLogId, (String)ENTITY_NAME);
        tsLog.set(TIMESTAMP, (Object)DataCopyTsLog.calcProperTsValue(src.get(param.getSourceTsField())));
        tsLog.set(TASK, (Object)param.getExecutionId());
        tsLog.set(TIME, (Object)new Timestamp(System.currentTimeMillis()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tsLog});
    }

    public static String calcProperTsValue(Object timestampValue) {
        String timestamp = D.s((Object)timestampValue);
        if (timestamp != null && DataCopyTsLog.needEncode(timestamp)) {
            return Hash.md5((String)timestamp);
        }
        return timestamp;
    }

    private static boolean needEncode(String timestampStr) {
        return timestampStr.length() > 50 || !StringUtil.allAreAsciiChars((String)timestampStr);
    }

    private static DynamicObject insertLog(DataCopyParam param, Map<String, Object> src, String oid, long linkId, String sourceTableName, long tsLogId) {
        DynamicObject tsLog = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
        tsLog.set(ID, (Object)tsLogId);
        tsLog.set(SYSTEM, (Object)linkId);
        tsLog.set(OID, (Object)oid);
        tsLog.set(REPOSITORY, (Object)sourceTableName);
        String judgeFieldsString = DataCopyTsLog.getJudgeFieldsString(param, src);
        tsLog.set(JUDGEFIELDS, (Object)DataCopyTsLog.splitIfExceedLength(judgeFieldsString));
        tsLog.set(TIMESTAMP, (Object)DataCopyTsLog.calcProperTsValue(src.get(param.getSourceTsField())));
        tsLog.set(TASK, (Object)param.getExecutionId());
        tsLog.set(TIME, (Object)new Timestamp(System.currentTimeMillis()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tsLog});
        return tsLog;
    }

    private static String getJudgeFieldsString(DataCopyParam param, Map<String, Object> src) {
        StringBuilder sb = new StringBuilder();
        List<String> judgeFields = param.getSourceJudgeFields();
        for (int i = 0; i < judgeFields.size(); ++i) {
            if (i > 0) {
                sb.append('|');
            }
            sb.append(src.get(judgeFields.get(i)));
        }
        return sb.toString();
    }

    private static String getTableName(DataCopyProvider param, String oid) {
        String sourceTableName = param.getSourceTableName();
        if (sourceTableName == null) {
            sourceTableName = oid;
        }
        return sourceTableName.toUpperCase();
    }

    private static String getOid(DataCopyProvider param, Map<String, Object> src) {
        String srcPK = param.getSourcePrimaryKey();
        if (srcPK == null) {
            throw new IscBizException(ResManager.loadKDString((String)"\u65f6\u95f4\u6233\u65e5\u5fd7\u540c\u6b65\u53ea\u652f\u6301\u914d\u7f6e\u5355\u4e3b\u952e\u7684\u6e90\u5355", (String)"DataCopyTsLog_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        String srcOid = D.s((Object)src.get(srcPK));
        if (srcOid == null) {
            throw new IscBizException(ResManager.loadKDString((String)"\u6e90\u5355\u4e3b\u952e\u5b58\u5728\u7a7a\u503c\uff0c\u4e0d\u652f\u6301\u65f6\u95f4\u6233\u65e5\u5fd7\u540c\u6b65\uff1b\u5982\u679c\u96c6\u6210\u65b9\u6848\u7684\u6e90\u5bf9\u8c61\u4e3a\u89c6\u56fe\u7c7b\u578b\uff0c\u8bf7\u5728\u96c6\u6210\u65b9\u6848\u5b57\u6bb5\u6620\u5c04\u5206\u5f55\u4e2d\u589e\u52a0\u9009\u62e9\u6e90\u4e3b\u952e\u5b57\u6bb5\u3002", (String)"DataCopyTsLog_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return DataCopyTsLog.splitIfExceedLength(srcOid);
    }

    private static String splitIfExceedLength(String str) {
        if (str != null) {
            if (str.length() <= 100) {
                return str;
            }
            return str.substring(0, 100);
        }
        return null;
    }
}

