/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.dc.meta.DataCopyConsumer;
import kd.isc.iscb.platform.core.dc.mq.MQUtil;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueManager;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueServer;
import kd.isc.iscb.platform.core.fn.ext.Functions;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectWriter;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.script.Script;

public class MQueueWriter
implements ObjectWriter<Map<String, Object>> {
    private static final String ACTION = "$action";
    private DynamicObject publisher;
    private DataCopyConsumer param;
    private Script formatScript;
    private MessageQueueServer server;
    private int batchSize;
    private boolean isArray;
    private static ThreadLocal<Map<MQueueWriter, List<Map<String, Object>>>> batchCache = new ThreadLocal();
    private int topicCount;

    MQueueWriter(DataCopyConsumer param, DynamicObject publisher, int topicCount) {
        this.param = param;
        this.publisher = publisher;
        this.topicCount = topicCount;
        this.server = MessageQueueManager.get(publisher.getLong("group_id"));
        this.isArray = this.publisher.getBoolean("multi_line");
        this.batchSize = this.isArray ? param.getBatchSize() : 1;
        this.compileFormatScript();
    }

    public MQueueWriter(DataCopyConsumer param) {
        this(param, param.getPublisherQueue(), 1);
    }

    private void compileFormatScript() {
        String s = D.s((Object)this.publisher.get("format_script_tag"));
        if (s == null) {
            s = D.s((Object)this.publisher.get("format_script"));
        }
        if (s != null) {
            this.formatScript = Script.compile((String)s);
        }
    }

    public void write(Map<String, Object> o) {
        List<Map<String, Object>> batch = this.getBatch();
        batch.add(o);
        if (batch.size() >= this.batchSize) {
            this.flush();
        }
    }

    private void flush() {
        List<Map<String, Object>> batch = this.getBatch();
        if (batch.size() == 0) {
            return;
        }
        try {
            this.presetFailed();
            this.publish(batch);
            this.setSuccess(batch);
        }
        finally {
            batch.clear();
        }
    }

    private void publish(List<Map<String, Object>> batch) {
        String s = this.serialize(batch);
        String data_producer = MQueueWriter.getDataProducer(this.param);
        MQUtil.publish(s, this.server, this.publisher, data_producer);
    }

    public static String getDataProducer(DataCopyConsumer param) {
        return param.getDataProducerDesc();
    }

    private void setSuccess(List<Map<String, Object>> batch) {
        for (Map<String, Object> data : batch) {
            data.put(ACTION, SaveDataType.UNKNOWN);
        }
    }

    private List<Map<String, Object>> getBatch() {
        List<Map<String, Object>> list;
        Map<MQueueWriter, List<Map<String, Object>>> cache = batchCache.get();
        if (cache == null) {
            cache = new HashMap<MQueueWriter, List<Map<String, Object>>>(this.topicCount);
            batchCache.set(cache);
        }
        if ((list = cache.get(this)) == null) {
            list = new ArrayList<Map<String, Object>>();
            cache.put(this, list);
        }
        return list;
    }

    private void presetFailed() {
        List<Map<String, Object>> batch = this.getBatch();
        for (Map<String, Object> data : batch) {
            data.put(ACTION, SaveDataType.FAILED);
        }
    }

    private String serialize(List<Map<String, Object>> batch) {
        if (this.formatScript != null) {
            return this.formatByScript(batch);
        }
        if (this.isArray) {
            return this.formatArray(batch);
        }
        return Json.toString(this.dup(batch.get(0)), (boolean)true);
    }

    private String formatArray(List<Map<String, Object>> batch) {
        ArrayList list = new ArrayList(batch.size());
        for (Map<String, Object> i : batch) {
            list.add(this.dup(i));
        }
        return Json.toString(list, (boolean)true);
    }

    private String formatByScript(List<Map<String, Object>> batch) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("$data", this.isArray ? batch : batch.get(0));
        Object value = this.formatScript.eval(ctx);
        if (value instanceof String) {
            return (String)value;
        }
        return Json.toString((Object)value, (boolean)true);
    }

    private Map<?, ?> dup(Map<String, Object> o) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(o.size() + 10);
        map.putAll(o);
        map.remove(ACTION);
        map.put("$actions", this.param.getTargetActions());
        map.put("$data_handler", this.param.getTargetDataHandler());
        DynamicObject targetSchema = this.param.getTargetSchema();
        if (targetSchema != null) {
            map.put("$meta_type", targetSchema.get("type"));
            map.put("$meta_name", targetSchema.get("full_name"));
        }
        return map;
    }

    public void close() {
        Map<MQueueWriter, List<Map<String, Object>>> cache = batchCache.get();
        if (cache == null) {
            return;
        }
        List<Map<String, Object>> batch = cache.remove(this);
        if (batch.isEmpty()) {
            if (this.topicCount == 1) {
                batchCache.remove();
                if (!cache.isEmpty()) {
                    throw new IscBizException(ResManager.loadKDString((String)"\u8c03\u7528\u8005\u7684\u8c03\u7528\u65b9\u5f0f\u4e0d\u6b63\u786e\uff0c\u5f53\u524d\u662f\u5355\u4e3b\u9898\u6a21\u5f0f\uff0c\u4f46\u5f53\u524d\u7ebf\u7a0b\u5b58\u5728\u591a\u4e2a\u8f93\u51fa\u5b9e\u4f8b\u3002", (String)"MQueueWriter_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
                }
            }
        } else {
            throw new IscBizException(ResManager.loadKDString((String)"\u5173\u95ed\u524d\u5fc5\u987b\u8c03\u7528 commit \u6216 rollback\u3002", (String)"MQueueWriter_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }

    static void disposeForMultiTopicMode() {
        Map<MQueueWriter, List<Map<String, Object>>> cache = batchCache.get();
        batchCache.remove();
        if (!cache.isEmpty()) {
            throw new IscBizException(ResManager.loadKDString((String)"\u8c03\u7528\u8005\u7684\u8c03\u7528\u65b9\u5f0f\u4e0d\u6b63\u786e\uff0c\u5f53\u524d\u662f\u591a\u4e3b\u9898\u6a21\u5f0f\uff0c\u4f46\u90e8\u5206\u8f93\u51fa\u5b9e\u4f8b\u672a\u6b63\u786e\u5173\u95ed\u3002", (String)"MQueueWriter_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }

    public void commit() {
        this.flush();
    }

    public boolean rollback(Throwable cause) {
        List<Map<String, Object>> batch = this.getBatch();
        for (Map<String, Object> tar : batch) {
            this.param.saveTargetErrorLog(cause, tar);
        }
        batch.clear();
        return false;
    }

    static {
        Functions.init();
    }
}

