/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.dc.meta.DataCopyProvider;
import kd.isc.iscb.platform.core.util.PropSetterFactory;
import kd.isc.iscb.platform.core.util.setter.Setter;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.Schema;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class SQLUtil {
    private static final String FIXED_VALUE = "fixed_value";
    private static final String MAPPING_TAR_COLUMN = "mapping_tar_column";
    private static final String ENTITY_ISC_METADATA_SCHEMA = "isc_metadata_schema";
    private static final String FILTER_COLUMN = "filter_column";
    private static final String FILTER_ENTRIES = "filter_entries";
    private static final String MAPPING_SRC_COLUMN = "mapping_src_column";
    private static final String MAPPING_ENTRIES = "mapping_entries";

    public static Map<String, Object> prepareRequires(DynamicObject dataCopySchema) {
        TreeMap<String, Object> requires = new TreeMap<String, Object>();
        SQLUtil.appendRequires(requires, dataCopySchema.getDynamicObjectCollection(MAPPING_ENTRIES), MAPPING_SRC_COLUMN);
        SQLUtil.appendRequires(requires, dataCopySchema.getDynamicObjectCollection(FILTER_ENTRIES), FILTER_COLUMN);
        long sourceObjectId = dataCopySchema.getLong("source_schema_id");
        DynamicObject srcObject = MetaDataSchema.get(sourceObjectId);
        if (srcObject.getString("type").equals("ENTITY")) {
            SQLUtil.handleEntityRequires(dataCopySchema, requires);
        }
        if (dataCopySchema.getBoolean("supports_file_copy")) {
            requires.put("$supports_file_copy", Boolean.TRUE);
        }
        return requires;
    }

    private static void setRequires(Map<String, Object> requires, String src) {
        if (src == null) {
            return;
        }
        if (src.indexOf(46) < 0) {
            requires.putIfAbsent(src, 1);
        } else {
            String[] path = src.split("\\.");
            SQLUtil.addEntryProperty(requires, path);
        }
    }

    public static void appendRequires(Map<String, Object> requires, DynamicObjectCollection filterEntries, String filterColumn) {
        for (DynamicObject obj : filterEntries) {
            String filter_column = D.s((Object)obj.get(filterColumn));
            SQLUtil.setRequires(requires, filter_column);
        }
    }

    public static Map<String, Object> prepareTargetFields(DynamicObject dataCopySchema) {
        TreeMap<String, Object> target = new TreeMap<String, Object>();
        for (DynamicObject obj : dataCopySchema.getDynamicObjectCollection(MAPPING_ENTRIES)) {
            String tar = D.s((Object)obj.get(MAPPING_TAR_COLUMN));
            String src = D.s((Object)obj.get(MAPPING_SRC_COLUMN));
            String fixedValue = D.s((Object)obj.get(FIXED_VALUE));
            if (tar == null || src == null && fixedValue == null) continue;
            if (tar.indexOf(46) < 0) {
                target.put(tar, 1);
                continue;
            }
            String[] path = tar.split("\\.");
            SQLUtil.addEntryProperty(target, path);
        }
        return target;
    }

    private static void handleEntityRequires(DynamicObject dataCopySchema, Map<String, Object> requires) {
        DynamicObjectCollection mappings = dataCopySchema.getDynamicObjectCollection("relation_mapping");
        for (int i = 0; i < mappings.size(); ++i) {
            DynamicObject mapping = (DynamicObject)mappings.get(i);
            long masterTable = mapping.getLong("master_table_id");
            if (masterTable == 0L || masterTable != dataCopySchema.getLong("source_schema_id")) continue;
            if (StringUtil.isEmpty((String)mapping.getString("relation_alias"))) {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u5173\u7cfb\u6620\u5c04\u5206\u5f55\u4e2d\u7684\u7b2c%s\u884c\u672a\u8bbe\u7f6e\u5173\u7cfb\u522b\u540d\uff0c\u8bf7\u68c0\u67e5\u65b9\u6848\u914d\u7f6e!", (String)"SQLUtil_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), i + 1));
            }
            requires.put(mapping.getString("master_ref_field"), 1);
            requires.remove(mapping.getString("relation_alias"));
        }
    }

    public static Map<String, Object> addEntryProperty(Map<String, Object> requires, String[] path) {
        Map entry = requires;
        int j = path.length - 1;
        for (int i = 0; i < j; ++i) {
            String name = path[i];
            HashMap tmp = entry.get(name);
            if (!(tmp instanceof Map)) {
                tmp = new HashMap();
                entry.put(name, tmp);
            }
            entry = tmp;
        }
        entry.put((String)path[path.length - 1], 1);
        return entry;
    }

    public static Set<String> getSelectedFields(Schema table, String alias, DataCopyProvider param) {
        HashSet<String> fieldSet = new HashSet<String>();
        String pk = table.getPrimaryKeyName();
        if (pk != null) {
            fieldSet.add(table.getField(pk).getBinding());
        }
        DynamicObjectCollection mappings = param.getSchema().getDynamicObjectCollection(MAPPING_ENTRIES);
        for (DynamicObject mapping : mappings) {
            String field;
            String src = D.s((Object)mapping.get(MAPPING_SRC_COLUMN));
            if (src == null || !src.startsWith(alias + ".") || (field = src.substring(src.indexOf(46) + 1)).contains(".")) continue;
            Column c = table.findField(field);
            if (c != null) {
                fieldSet.add(c.getBinding());
                continue;
            }
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\uff08%s\uff09\u4e0d\u5b58\u5728\uff01", (String)"GeneralSchema_2", (String)"isc-iscb-util", (Object[])new Object[0]), src));
        }
        return fieldSet;
    }

    public static void checkRelations(DataCopyProvider param, Set<String> fieldSet, String aliasName, String relationType, String tips) {
        if (fieldSet.size() > 0) {
            return;
        }
        String number = "";
        String name = "";
        DynamicObjectCollection relations = param.getSchema().getDynamicObjectCollection("relation_mapping");
        for (DynamicObject relation : relations) {
            DynamicObject data_table;
            String alias = D.s((Object)relation.get("relation_alias"));
            String relation_type = relation.getString("relation_type");
            if (alias == null || !alias.equals(aliasName) || !relationType.equals(relation_type) || (data_table = relation.getDynamicObject("data_table")) == null) continue;
            number = data_table.getString("number");
            name = data_table.getString("name");
        }
        DynamicObject cfg = param.getSourceConnection().getConfig();
        String remark = ConnectionWrapper.generateDbLinkRemark(cfg);
        String errorMsg = ConnectionWrapper.compositeNewMessage(String.format(ResManager.loadKDString((String)"%1$s\u8868 %2$s\uff08%3$s\uff09\u53d6\u6570\u5931\u8d25\uff0c\u8bf7\u6392\u67e5\u662f\u5426\u5b58\u5728\u4ee5\u4e0b\u95ee\u9898: \u96c6\u6210\u65b9\u6848\u201c\u6e90\u5bf9\u8c61\u5b57\u6bb5\u201d\u4e2d\u672a\u914d\u7f6e%4$s\u8868\u53d6\u503c\u5b57\u6bb5\uff0c\u4e14%5$s\u8868\u4e3b\u952e\u4e3a\u7a7a\u3002", (String)"SQLUtil_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]), tips, name, number, tips, tips) + "\n" + String.format(ResManager.loadKDString((String)"\u6ce8\uff1a\u5982\u679c\u4e0d\u9700\u8981\u8fd9\u4e2a%1$s\u8868\uff0c\u8bf7\u4ece\u201c\u9ad8\u7ea7\u8bbe\u7f6e->\u5173\u7cfb\u6620\u5c04\u201d\u5206\u5f55\u4e2d\u5220\u9664\uff1a%2$s\u3002", (String)"SQLUtil_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]), tips, name), remark);
        throw new IscBizException(errorMsg);
    }

    public static String toPlainRequires(String entity, String parent, Map<String, Object> requires) {
        HashMap<String, Object> dbRequires = new HashMap<String, Object>();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        SQLUtil.filterRequires((IDataEntityType)entityType, dbRequires, requires);
        Set<String> set = SQLUtil.innerPlainRequires((DynamicObjectType)entityType, parent, dbRequires);
        return StringUtil.join(set, (String)",");
    }

    public static void filterRequires(IDataEntityType type, Map<String, Object> dbRequires, Map<String, Object> requires) {
        DataEntityPropertyCollection properties = type.getProperties();
        for (String name : requires.keySet()) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)name);
            if (property == null || !SQLUtil.isEntryProp(property) && D.s((Object)property.getAlias()) == null) continue;
            try {
                Setter setter = PropSetterFactory.createSetter(property);
                setter.setRequiresMap(name, dbRequires, requires);
            }
            catch (Exception e) {
                String text = String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u7684\u53d6\u6570\u8bbe\u7f6e\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u539f\u56e0\uff1a%2$s", (String)"SQLUtil_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name, StringUtil.getCascadeMessage((Throwable)e));
                throw new IscBizException(text, (Throwable)e);
            }
        }
    }

    private static boolean isEntryProp(IDataEntityProperty property) {
        return property instanceof EntryProp && D.s((Object)((EntryProp)property).getDynamicCollectionItemPropertyType().getAlias()) != null;
    }

    private static Set<String> innerPlainRequires(DynamicObjectType entityType, String parent, Map<String, Object> requires) {
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<String, Object> entry : requires.entrySet()) {
            String field = entry.getKey();
            String fullField = parent == null ? field : parent + "." + field;
            Object value = entry.getValue();
            DynamicProperty property = entityType.getProperty(field);
            if (property == null) continue;
            if (property instanceof MulBasedataProp) {
                SQLUtil.setMulBaseDataRequires(property, set, fullField, value);
                continue;
            }
            if (property instanceof FlexProp) continue;
            if (value instanceof Map && !(property instanceof MuliLangTextProp)) {
                String name;
                Map childRequires = (Map)value;
                childRequires.put("id", 1);
                DynamicObjectType type = null;
                if (property instanceof EntryProp) {
                    type = ((EntryProp)property).getDynamicCollectionItemPropertyType();
                } else if (property instanceof BasedataProp) {
                    name = ((BasedataProp)property).getDynamicComplexPropertyType().getName();
                    type = MetadataServiceHelper.getDataEntityType((String)name);
                } else if (property instanceof RefBillProp) {
                    name = ((RefBillProp)property).getBillEntityId();
                    type = MetadataServiceHelper.getDataEntityType((String)name);
                } else {
                    type = entityType;
                }
                set.addAll(SQLUtil.innerPlainRequires(type, fullField, childRequires));
                continue;
            }
            set.add(fullField);
        }
        return set;
    }

    private static void setMulBaseDataRequires(DynamicProperty property, Set<String> set, String fullField, Object value) {
        if (value instanceof Map) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u591a\u9009\u57fa\u7840\u8d44\u6599\u5b57\u6bb5%s\u4e0d\u652f\u6301\u53d6\u5f15\u7528\u5c5e\u6027\uff0c\u8bf7\u8c03\u6574\u65b9\u6848\u914d\u7f6e\u3002", (String)"SQLUtil_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]), property.getName()));
        }
        if (property instanceof AttachmentProp) {
            set.add(fullField + ".fpkid");
            set.add(fullField + "." + "fbasedataid");
        } else {
            set.add(fullField + ".pkid");
            set.add(fullField + ".fbasedataid.id");
        }
    }
}

