/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import kd.isc.iscb.util.io.AbstractInputStream;

public class TempByteArrayInputStream
extends AbstractInputStream {
    private InputStream input;

    public TempByteArrayInputStream(AbstractInputStream in, int size) throws Exception {
        this.initByteArrayInputStream(in, size);
    }

    public void markError() {
    }

    public int read() throws IOException {
        return this.input.read();
    }

    private void initByteArrayInputStream(AbstractInputStream in, int size) throws IOException {
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream(size);){
            int len;
            byte[] data = new byte[8192];
            while ((len = in.read(data)) > -1) {
                buffer.write(data, 0, len);
            }
            this.input = new ByteArrayInputStream(buffer.toByteArray());
        }
        catch (Throwable e) {
            in.markError();
            throw e;
        }
    }
}

