/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kd.isc.iscb.platform.core.connector.self.AttachmentUtil;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.platform.core.util.FileUtil;
import kd.isc.iscb.util.io.AbstractInputStream;

public class TempFileInputStream
extends AbstractInputStream {
    private InputStream input;
    private File tempFile;
    private static final int BUFFER_SIZE = 8192;

    TempFileInputStream(AbstractInputStream in, String type) throws Throwable {
        this.initTempFileInputStream(in, type);
    }

    private void initTempFileInputStream(AbstractInputStream in, String type) throws Throwable {
        File file = AttachmentUtil.createTempFile(type);
        BufferedOutputStream buffer = new BufferedOutputStream(new FileOutputStream(file));
        try {
            this.saveToTempFile(in, buffer);
            this.tempFile = file;
        }
        catch (Throwable e) {
            in.markError();
            throw e;
        }
        finally {
            this.close(buffer, file);
        }
        this.input = new BufferedInputStream(new FileInputStream(this.tempFile));
    }

    private void saveToTempFile(AbstractInputStream in, BufferedOutputStream buffer) throws IOException {
        int len;
        int total = 0;
        byte[] data = new byte[8192];
        while ((len = in.read(data)) > -1) {
            if ((total += len) % 0x200000 == 0) {
                SignalManager.checkCancelSignal();
            }
            buffer.write(data, 0, len);
        }
    }

    public void close(OutputStream out, File file) throws Throwable {
        if (out != null) {
            out.close();
        }
        if (this.tempFile == null) {
            FileUtil.delete(file);
        }
    }

    public void markError() {
    }

    public int read() throws IOException {
        return this.input.read();
    }

    public void close() throws IOException {
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        finally {
            if (this.tempFile != null) {
                FileUtil.delete(this.tempFile);
            }
        }
    }
}

