/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e.s;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.dc.e.DataCopyDebugger;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.platform.core.dc.e.SQLUtil;
import kd.isc.iscb.platform.core.dc.e.s.SourceDataDecorator;
import kd.isc.iscb.platform.core.dc.meta.DataCopyProvider;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Schema;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.misc.Triple;

public class EntryTableDataDecorator
implements SourceDataDecorator {
    @Override
    public void registerLine(DataCopyParam dataCopyParam) {
        DataCopyDebugger.registerLine(dataCopyParam, "entries_table_read", ResManager.loadKDString((String)"\u5206\u5f55\u8868\u8bfb\u53d6", (String)"EntryTableDataDecorator_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public void decorate(Map<String, Object> data, DataCopyProvider param) {
        DataCopyDebugger.trap(param, "entries_table_read", data, null);
        String pk = param.getSourcePrimaryKey();
        if (pk == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\uff08%2$s\uff09\u201d\u6e90\u5bf9\u8c61\u6ca1\u6709\u5355\u5b57\u6bb5\u4e3b\u952e\uff0c\u4e0d\u652f\u6301\u5206\u5f55\u8868\u53d6\u6570\u7279\u6027\u3002", (String)"EntryTableDataDecorator_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), param.getSourceSchema().get("name"), param.getSourceSchema().get("number")));
        }
        Object id = data.get(pk);
        if (id == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\uff08%2$s\uff09\u201d\u6e90\u6570\u636e\u6ca1\u6709\u63d0\u4f9b\u4e3b\u952e\u5b57\u6bb5\u503c\uff0c\u8bf7\u9009\u62e9\u6e90\u5bf9\u8c61\u7684\u4e3b\u952e\u5b57\u6bb5\u201c%3$s\u201d\u3002", (String)"EntryTableDataDecorator_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), param.getSourceSchema().get("name"), param.getSourceSchema().get("number"), pk));
        }
        for (Map.Entry<String, Triple<Schema, String, String>> e : param.getSourceEntryTables().entrySet()) {
            Triple<Schema, String, String> p = e.getValue();
            Column master_field = ((Schema)p.getA()).getField((String)p.getB());
            Object master = master_field.toSqlParam(id);
            String sql = this.generateSelect(e, param);
            ObjectReader<DataRow> reader = param.getSourceConnection().executeQuery(sql, Collections.singletonList(master), Collections.singletonList(master_field.getSqlType()));
            List<Map<String, Object>> entries = EntryTableDataDecorator.toList(reader, (Schema)p.getA(), master_field, master);
            List<Map<String, Object>> old = data.put(e.getKey(), entries);
            if (old == null) continue;
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6e90\u6570\u636e\u5c5e\u6027\u540d\uff08%s\uff09\u91cd\u590d\u3002", (String)"EntryTableDataDecorator_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), e.getKey()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Map<String, Object>> toList(ObjectReader<DataRow> reader, Schema schema, Column master_field, Object master) {
        try {
            String pk = schema.getPrimaryKeyName();
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            int totalBytes = 0;
            int maxEntryRecordSize = EntryTableDataDecorator.getMaxEntryRecordSize();
            DataRow row = (DataRow)reader.read();
            while (row != null) {
                Map item = row.toMap();
                item.put("$id", item.get(pk));
                totalBytes = (int)((long)totalBytes + DbUtil.getObjectSize((Object)item));
                EntryTableDataDecorator.checkTotalBytes(totalBytes, schema, maxEntryRecordSize, master_field, master);
                list.add(item);
                row = (DataRow)reader.read();
            }
            ArrayList<Map<String, Object>> arrayList = list;
            return arrayList;
        }
        finally {
            reader.close();
        }
    }

    private static void checkTotalBytes(long totalBytes, Schema schema, int maxEntryRecordSize, Column master_field, Object master) {
        if (totalBytes > (long)maxEntryRecordSize) {
            String tips = String.format(ResManager.loadKDString((String)"\u6839\u636e\u5b57\u6bb5%1$s\uff08\u503c\uff1a%2$s\uff09\u5173\u8054\u67e5\u8be2\u5206\u5f55\u8868\u201c%3$s\u201d\u7684\u7ed3\u679c\u96c6\u8d85\u8fc7\u4e86\u9650\u5236\uff08\u5b57\u8282\u6570\uff1a%4$s\uff09\uff0c\u8bf7\u8c03\u6574\u4e1a\u52a1\u5b9e\u73b0\u4ee5\u51cf\u5c11\u67e5\u8be2\u6570\u636e\u91cf\uff0c\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8c03\u6574\u79df\u6237\u53c2\u6570\u201cISC_ENTRY_QUERY_MAX_SIZE\u201d\u63d0\u9ad8\u4e0a\u9650\u3002", (String)"EntryTableDataDecorator_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), master_field, master, schema.getName(), maxEntryRecordSize);
            throw new IscBizException(tips);
        }
    }

    private static int getMaxEntryRecordSize() {
        int maxSize = D.i((Object)ContextUtil.getTenantProperty("ISC_ENTRY_QUERY_MAX_SIZE"));
        if (maxSize <= 0) {
            return 20000000;
        }
        return maxSize;
    }

    private String generateSelect(Map.Entry<String, Triple<Schema, String, String>> e, DataCopyProvider param) {
        Triple<Schema, String, String> p = e.getValue();
        Schema table = (Schema)p.getA();
        Set<String> fieldSet = SQLUtil.getSelectedFields(table, e.getKey(), param);
        SQLUtil.checkRelations(param, fieldSet, e.getKey(), "entry_table", ResManager.loadKDString((String)"\u5206\u5f55", (String)"EntryTableDataDecorator_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append(StringUtil.join(fieldSet, (String)","));
        sql.append(" FROM ").append(table.getQuotedName());
        String master = table.getField((String)p.getB()).getBinding();
        sql.append(" WHERE ").append(master).append("=?");
        if (p.getC() != null) {
            sql.append(" ORDER BY ").append((String)p.getC());
        }
        return sql.toString();
    }
}

