/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e.s;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.dc.e.DataCopyDebugger;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.platform.core.dc.e.SQLUtil;
import kd.isc.iscb.platform.core.dc.e.s.SourceDataDecorator;
import kd.isc.iscb.platform.core.dc.meta.DataCopyProvider;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.Schema;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;

public class RefTableDataDecorator
implements SourceDataDecorator {
    @Override
    public void registerLine(DataCopyParam dataCopyParam) {
        DataCopyDebugger.registerLine(dataCopyParam, "ref_table_read", ResManager.loadKDString((String)"\u5916\u952e\u8868\u8bfb\u53d6", (String)"RefTableDataDecorator_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public void decorate(Map<String, Object> data, DataCopyProvider param) {
        DataCopyDebugger.trap(param, "ref_table_read", data, null);
        for (Map.Entry<String, Pair<Schema, String>> e : param.getSourceRefTables().entrySet()) {
            Object old;
            Map<String, Object> row = null;
            String ref_field = (String)e.getValue().getValue();
            Object ref = data.get(ref_field);
            if (ref != null) {
                Schema schema = (Schema)e.getValue().getKey();
                String sql = this.generateSelect(e, param);
                Column pk = schema.getField(schema.getPrimaryKeyName());
                ConnectionWrapper cn = param.getSourceConnection();
                List<Object> params = Collections.singletonList(pk.toSqlParam(ref));
                List<Integer> types = Collections.singletonList(pk.getSqlType());
                ObjectReader<DataRow> reader = cn.executeQuery(sql, params, types);
                row = this.readRow(reader, ref, schema.getName());
            }
            if ((old = data.put(e.getKey(), row)) == null) continue;
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6e90\u6570\u636e\u5c5e\u6027\u540d\uff08%s\uff09\u91cd\u590d\u3002", (String)"RefTableDataDecorator_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), e.getKey()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> readRow(ObjectReader<DataRow> reader, Object id, String table) {
        try {
            DataRow row = (DataRow)reader.read();
            if (row != null) {
                Map map = row.toMap();
                return map;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("$error", String.format(ResManager.loadKDString((String)"\u810f\u6570\u636e\uff0cID\uff08%1$s\uff09\u5728\u8868\uff08%2$s\uff09\u4e2d\u4e0d\u5b58\u5728\uff01", (String)"RefTableDataDecorator_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), id, table));
            HashMap<String, Object> hashMap = map;
            return hashMap;
        }
        finally {
            reader.close();
        }
    }

    private String generateSelect(Map.Entry<String, Pair<Schema, String>> e, DataCopyProvider param) {
        Schema table = (Schema)e.getValue().getKey();
        Set<String> fields = SQLUtil.getSelectedFields(table, e.getKey(), param);
        SQLUtil.checkRelations(param, fields, e.getKey(), "ref_table", ResManager.loadKDString((String)"\u5916\u952e", (String)"RefTableDataDecorator_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append(StringUtil.join(fields, (String)","));
        sql.append(" FROM ").append(table.getQuotedName());
        String pk = table.getPrimaryKeyName();
        sql.append(" WHERE ").append(table.getField(pk).getBinding()).append("=?");
        return sql.toString();
    }
}

