/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e.v;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.dc.e.v.Aggregation;
import kd.isc.iscb.platform.core.dc.e.v.a.AdjustLevel;
import kd.isc.iscb.platform.core.dc.e.v.a.Avg;
import kd.isc.iscb.platform.core.dc.e.v.a.Count;
import kd.isc.iscb.platform.core.dc.e.v.a.DateParser;
import kd.isc.iscb.platform.core.dc.e.v.a.DecimalParser;
import kd.isc.iscb.platform.core.dc.e.v.a.Decode;
import kd.isc.iscb.platform.core.dc.e.v.a.DefaultValue;
import kd.isc.iscb.platform.core.dc.e.v.a.Encode;
import kd.isc.iscb.platform.core.dc.e.v.a.If;
import kd.isc.iscb.platform.core.dc.e.v.a.Indexer;
import kd.isc.iscb.platform.core.dc.e.v.a.IntegerParser;
import kd.isc.iscb.platform.core.dc.e.v.a.Join;
import kd.isc.iscb.platform.core.dc.e.v.a.Locator;
import kd.isc.iscb.platform.core.dc.e.v.a.LongParser;
import kd.isc.iscb.platform.core.dc.e.v.a.NullIf;
import kd.isc.iscb.platform.core.dc.e.v.a.RepeatOnEntry;
import kd.isc.iscb.platform.core.dc.e.v.a.Rtrim;
import kd.isc.iscb.platform.core.dc.e.v.a.Split;
import kd.isc.iscb.platform.core.dc.e.v.a.SplitToList;
import kd.isc.iscb.platform.core.dc.e.v.a.StringParser;
import kd.isc.iscb.platform.core.dc.e.v.a.Sum;
import kd.isc.iscb.platform.core.dc.e.v.a.ToEasID;
import kd.isc.iscb.platform.core.dc.e.v.a.ToLongID;
import kd.isc.iscb.platform.core.dc.e.v.a.ToMd5I64;
import kd.isc.iscb.platform.core.dc.e.v.a.ZeroAsNull;

public class AggregationFactory {
    public static Aggregation get(String property, String aggr) {
        if (aggr == null) {
            return null;
        }
        Aggregation impl = AggregationFactory.parse(property, aggr);
        return new AggregationWrapper(aggr, impl);
    }

    private static Aggregation parse(String property, String aggr) {
        if (aggr.contains("::")) {
            String[] array = aggr.split("::");
            Aggregation[] list = new Aggregation[array.length];
            for (int i = 0; i < list.length; ++i) {
                list[i] = AggregationFactory.get(property, array[i]);
            }
            return new CompositeAggregation(list);
        }
        if (aggr.startsWith("[") && aggr.endsWith("]")) {
            if (aggr.indexOf(61) >= 0) {
                return new Locator(property, aggr);
            }
            return new AggregationAdapter(new Indexer(aggr));
        }
        if (aggr.startsWith("repeat_on(")) {
            return new RepeatOnEntry(property, aggr);
        }
        if (aggr.startsWith("if(")) {
            return new If(property, aggr);
        }
        if (aggr.startsWith("null_if(")) {
            return new NullIf(property, aggr);
        }
        if ("sum".equals(aggr)) {
            return new AggregationAdapter(new Sum());
        }
        if ("avg".equals(aggr)) {
            return new AggregationAdapter(new Avg());
        }
        if ("count".equals(aggr)) {
            return new AggregationAdapter(new Count());
        }
        if ("string".equals(aggr)) {
            return new AggregationAdapter(new StringParser());
        }
        if ("int".equals(aggr)) {
            return new AggregationAdapter(new IntegerParser());
        }
        if ("long".equals(aggr)) {
            return new AggregationAdapter(new LongParser());
        }
        if ("decimal".equals(aggr)) {
            return new AggregationAdapter(new DecimalParser());
        }
        if (aggr.startsWith("date(") || aggr.equals("date")) {
            return new AggregationAdapter(new DateParser(aggr));
        }
        if (aggr.startsWith("split(")) {
            return new Split(aggr);
        }
        if (aggr.startsWith("rtrim(")) {
            return new Rtrim(aggr);
        }
        if (aggr.startsWith("join(")) {
            return new AggregationAdapter(new Join(aggr));
        }
        if (aggr.startsWith("to_eas_id(")) {
            return new AggregationAdapter(new ToEasID(aggr, property));
        }
        if (aggr.equals("to_long_id")) {
            return new AggregationAdapter(new ToLongID());
        }
        if (aggr.equals("md5i64")) {
            return new AggregationAdapter(new ToMd5I64());
        }
        if (aggr.equals("level(+)") || aggr.equals("level(-)")) {
            return new AdjustLevel(aggr);
        }
        if (aggr.startsWith("default(")) {
            return new AggregationAdapter(new DefaultValue(aggr));
        }
        if (aggr.equals("encode")) {
            return new AggregationAdapter(new Encode());
        }
        if (aggr.equals("decode")) {
            return new AggregationAdapter(new Decode());
        }
        if (aggr.equals("zero_as_null")) {
            return new ZeroAsNull(property);
        }
        if (aggr.startsWith("split_to_list(")) {
            return new SplitToList(aggr);
        }
        throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301 - %s", (String)"AggregationFactory_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), aggr));
    }

    private static class AggregationAdapter
    implements Aggregation {
        private Aggregation a;

        public AggregationAdapter(Aggregation a) {
            this.a = a;
        }

        @Override
        public Object calc(Object value, Map<String, Object> src) {
            Object[] list;
            if (value == null) {
                if (this.acceptNull()) {
                    return this.a.calc(null, src);
                }
                return null;
            }
            if (value instanceof Object[] && (list = (Object[])value).length > 0 && list[0] instanceof Object[]) {
                Object[] result = new Object[list.length];
                for (int i = 0; i < list.length; ++i) {
                    result[i] = this.calc(list[i], src);
                }
                return result;
            }
            return this.a.calc(value, src);
        }

        @Override
        public Aggregation.RunAt runAt() {
            return this.a.runAt();
        }

        @Override
        public boolean acceptNull() {
            return this.a.acceptNull();
        }
    }

    private static class AggregationWrapper
    implements Aggregation {
        private String expr;
        private Aggregation impl;

        private AggregationWrapper(String expr, Aggregation impl) {
            this.expr = expr;
            this.impl = impl;
        }

        @Override
        public Object calc(Object value, Map<String, Object> src) {
            return this.impl.calc(value, src);
        }

        @Override
        public boolean acceptNull() {
            return this.impl.acceptNull();
        }

        @Override
        public Aggregation.RunAt runAt() {
            return this.impl.runAt();
        }

        public String toString() {
            return this.expr;
        }
    }

    private static class CompositeAggregation
    implements Aggregation {
        private Aggregation[] list;
        private Aggregation.RunAt run_at;

        public CompositeAggregation(Aggregation[] list) {
            this.list = list;
            this.run_at = this.calcRunAt(list);
        }

        private Aggregation.RunAt calcRunAt(Aggregation[] list) {
            int run_at = 0;
            for (Aggregation a : list) {
                run_at |= a.runAt().getValue();
            }
            return Aggregation.RunAt.valueOf(run_at);
        }

        @Override
        public Aggregation.RunAt runAt() {
            return this.run_at;
        }

        @Override
        public boolean acceptNull() {
            for (Aggregation a : this.list) {
                if (!a.acceptNull()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object calc(Object value, Map<String, Object> src) {
            for (Aggregation a : this.list) {
                if (value == null && !a.acceptNull()) continue;
                value = a.calc(value, src);
            }
            return value;
        }
    }
}

