/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e.v;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.platform.core.dc.e.v.Expression;
import kd.isc.iscb.platform.core.dc.e.v.expressions.Boid;
import kd.isc.iscb.platform.core.dc.e.v.expressions.CtxUserId;
import kd.isc.iscb.platform.core.dc.e.v.expressions.ExecutionId;
import kd.isc.iscb.platform.core.dc.e.v.expressions.ExecutionNumber;
import kd.isc.iscb.platform.core.dc.e.v.expressions.Md5Soid;
import kd.isc.iscb.platform.core.dc.e.v.expressions.Md5SsidPlusSoid;
import kd.isc.iscb.platform.core.dc.e.v.expressions.MurSoid;
import kd.isc.iscb.platform.core.dc.e.v.expressions.NewId;
import kd.isc.iscb.platform.core.dc.e.v.expressions.Now;
import kd.isc.iscb.platform.core.dc.e.v.expressions.Null;
import kd.isc.iscb.platform.core.dc.e.v.expressions.Replace;
import kd.isc.iscb.platform.core.dc.e.v.expressions.Rtrim;
import kd.isc.iscb.platform.core.dc.e.v.expressions.ScheduledTime;
import kd.isc.iscb.platform.core.dc.e.v.expressions.SchemaId;
import kd.isc.iscb.platform.core.dc.e.v.expressions.SchemaNumber;
import kd.isc.iscb.platform.core.dc.e.v.expressions.Soid;
import kd.isc.iscb.platform.core.dc.e.v.expressions.Ssid;
import kd.isc.iscb.platform.core.dc.e.v.expressions.SsidPlusSoid;
import kd.isc.iscb.platform.core.dc.e.v.expressions.SuperKey;
import kd.isc.iscb.platform.core.dc.e.v.expressions.Tenant;
import kd.isc.iscb.platform.core.dc.e.v.expressions.TimeStamp;
import kd.isc.iscb.platform.core.dc.e.v.expressions.Today;
import kd.isc.iscb.platform.core.dc.e.v.expressions.TriggerId;
import kd.isc.iscb.platform.core.dc.e.v.expressions.TriggerNumber;
import kd.isc.iscb.platform.core.dc.e.v.expressions.numeric.Dec;
import kd.isc.iscb.platform.core.dc.e.v.expressions.numeric.Div;
import kd.isc.iscb.platform.core.dc.e.v.expressions.numeric.Inc;
import kd.isc.iscb.platform.core.dc.e.v.expressions.numeric.Mul;

public class ExprEngine {
    private static Map<String, Expression> exprs = new LinkedHashMap<String, Expression>();
    private static List<String> keysStartedWith = new ArrayList<String>();
    private static List<String> keysContained = new ArrayList<String>();

    public static Expression getExpression(String expr) {
        Expression expression = ExprEngine.innerGetExpression(expr);
        if (expression != null) {
            return expression;
        }
        throw new IllegalArgumentException(expr);
    }

    private static Expression innerGetExpression(String expr) {
        Expression expression = exprs.get(expr);
        if (expression == null) {
            for (String key : keysContained) {
                if (!expr.contains(key)) continue;
                expression = exprs.get(key);
                break;
            }
        }
        if (expression == null) {
            for (String key : keysStartedWith) {
                if (!expr.startsWith(key)) continue;
                expression = exprs.get(key);
                break;
            }
        }
        return expression;
    }

    static {
        exprs.put("($keys", new SuperKey());
        exprs.put("#{null}", new Null());
        exprs.put("#{now}", new Now());
        exprs.put("#{today}", new Today());
        exprs.put("#{ssid}", new Ssid());
        exprs.put("#{tenant}", new Tenant());
        exprs.put("#{ssid+','+soid}", new SsidPlusSoid());
        exprs.put("#{soid}", new Soid());
        exprs.put("#{md5(ssid+','+soid)}", new Md5SsidPlusSoid());
        exprs.put("#{md5(soid)}", new Md5Soid());
        exprs.put("#{mur(soid)}", new MurSoid());
        exprs.put("#{execution_id}", new ExecutionId());
        exprs.put("#{execution_number}", new ExecutionNumber());
        exprs.put("#{trigger_number}", new TriggerNumber());
        exprs.put("#{trigger_id}", new TriggerId());
        exprs.put("#{schema_id}", new SchemaId());
        exprs.put("#{schema_number}", new SchemaNumber());
        exprs.put("#{scheduled_time}", new ScheduledTime());
        exprs.put("#{ctx_user_id}", new CtxUserId());
        exprs.put("#{new_", new NewId());
        exprs.put("#{now-", new TimeStamp());
        exprs.put("#{replace(", new Replace());
        exprs.put("#{rtrim(", new Rtrim());
        exprs.put("#{boid(", new Boid());
        exprs.put("#{inc(", new Inc());
        exprs.put("#{dec(", new Dec());
        exprs.put("#{mul(", new Mul());
        exprs.put("#{div(", new Div());
        keysStartedWith.add("#{new_");
        keysStartedWith.add("#{now-");
        keysStartedWith.add("#{replace(");
        keysStartedWith.add("#{rtrim(");
        keysStartedWith.add("#{boid(");
        keysStartedWith.add("#{inc(");
        keysStartedWith.add("#{dec(");
        keysStartedWith.add("#{mul(");
        keysStartedWith.add("#{div(");
        keysContained.add("($keys");
    }
}

