/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e.v;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.dc.meta.DataCopyTransformer;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataTypeUtil;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class PropertyAssembler {
    private String property;
    private DataCopyTransformer cfg;
    private String[] path;
    private boolean[] entriesFlag;
    private int index;
    private DataType type;

    public PropertyAssembler(DataCopyTransformer cfg, String property, int index) {
        this.property = property;
        this.cfg = cfg;
        this.index = index;
        this.path = property.split("\\.");
        if (this.path.length == 1 && this.index > 0) {
            throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\uff08%s\uff09\u4e0d\u652f\u6301\u5355\u884c\u62c6\u5206\u591a\u884c\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u8bbe\u7f6e\u4e3a\u76ee\u6807\u5355\u5b57\u6bb5\uff01", (String)"PropertyAssembler_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), property));
        }
        if (property.contains("[]")) {
            this.entriesFlag = new boolean[this.path.length];
            for (int i = 0; i < this.path.length; ++i) {
                String key = this.path[i];
                this.entriesFlag[i] = key.endsWith("[]");
                if (!this.entriesFlag[i]) continue;
                this.path[i] = key.substring(0, key.length() - 2);
            }
        } else {
            this.entriesFlag = null;
        }
    }

    public String getProperty() {
        return this.property;
    }

    public String getField() {
        if (this.path.length == 1) {
            return this.path[0];
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u662f\u4e3b\u8868\u5b57\u6bb5\uff01", (String)"PropertyAssembler_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), StringUtil.join((Object[])this.path)));
    }

    public String[] getPath() {
        return (String[])this.path.clone();
    }

    public String getPath(int index) {
        return this.path[index];
    }

    public int getPathLength() {
        return this.path.length;
    }

    public void set(Map<String, Object> target, Object value) {
        if (this.index <= 0) {
            this.assign(target, 0, value);
        } else {
            this.splitTarget(target, value);
        }
    }

    private void splitTarget(Map<String, Object> target, Object value) {
        ArrayList tmp = target.get(this.path[0]);
        if (tmp instanceof Map) {
            ArrayList list = new ArrayList();
            list.add(tmp);
            target.put(this.path[0], list);
            tmp = list;
        }
        List<Map<String, Object>> targets = this.slice(tmp);
        if (value instanceof Object[]) {
            this.assignList2List(targets, 1, (Object[])value);
        } else {
            this.assignValue2List(targets, 1, value);
        }
    }

    private List<Map<String, Object>> slice(List<Map<String, Object>> list) {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(Math.max(1, list.size() / 2));
        for (Map<String, Object> item : list) {
            if (D.i((Object)item.get("#")) != this.index) continue;
            items.add(item);
        }
        if (items.size() > 0) {
            return items;
        }
        for (Map<String, Object> item : list) {
            if (item.containsKey("#")) continue;
            HashMap<String, Object> e = new HashMap<String, Object>();
            e.put("#", this.index);
            e.putAll(item);
            items.add(e);
        }
        list.addAll(items);
        return items;
    }

    private void assign(Object target, int index, Object value) {
        if (target instanceof List) {
            if (value instanceof Object[]) {
                this.assignList2List((List)target, index, (Object[])value);
            } else {
                this.assignValue2List((List)target, index, value);
            }
        } else if (value instanceof Object[]) {
            if (this.entriesFlag == null || this.entriesFlag[index]) {
                this.assignList2Map((Map)target, index, (Object[])value);
            } else {
                this.assignValue2Map((Map)target, index, value);
            }
        } else {
            this.assignValue2Map((Map)target, index, value);
        }
    }

    private void assignValue2Map(Map<String, Object> target, int index, Object value) {
        if (index == this.path.length - 1) {
            target.put(this.path[index], this.narrow(value));
        } else if (index < this.path.length) {
            HashMap tmp = target.get(this.path[index]);
            if (tmp == null) {
                HashMap map = new HashMap();
                target.put(this.path[index], map);
                tmp = map;
            }
            this.assign(tmp, index + 1, value);
        } else {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u6e90\u5355\u5b57\u6bb5\u503c\u7684\u5c42\u7ea7\u6bd4\u76ee\u6807\u5355\u5b57\u6bb5\uff08%s\uff09\u7684\u5c42\u7ea7\u6df1\uff0c\u8bf7\u68c0\u67e5\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\u3002", (String)"PropertyAssembler_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), StringUtil.join((Object[])this.path)));
        }
    }

    private Object narrow(Object value) {
        if (this.type == null) {
            this.initDataType();
        }
        return this.type.narrow(value);
    }

    private void initDataType() {
        if (this.cfg.targetIsTable()) {
            Table table;
            Column field;
            String column;
            Column field2;
            this.type = this.path.length == 1 ? ((field2 = this.cfg.getTargetTable().findField(this.path[0])) != null ? field2.getDataType() : DataTypeUtil.UNKNOWN_TYPE) : ("$id".equals(column = this.path[1]) || "$pk".equals(column) ? DataTypeUtil.UNKNOWN_TYPE : ((field = (table = this.cfg.getTargetEntryTable(this.path[0])).findField(column)) != null ? field.getDataType() : DataTypeUtil.UNKNOWN_TYPE));
        } else {
            Table table;
            if (this.path.length == 2 && (table = this.cfg.findTargetEntryTable(this.path[0])) != null) {
                String column = this.path[1];
                this.type = "$id".equals(column) || "$pk".equals(column) ? DataTypeUtil.UNKNOWN_TYPE : table.getField(column).getDataType();
                return;
            }
            this.type = this.cfg.getTargetPropertyDataType(this.path);
        }
    }

    private void assignList2Map(Map<String, Object> target, int index, Object[] values) {
        List targets;
        Object t = target.get(this.path[index]);
        int length = values.length;
        if (t == null) {
            targets = new ArrayList(length);
            while (targets.size() < length) {
                LinkedHashMap item = new LinkedHashMap();
                targets.add(item);
            }
            target.put(this.path[index], targets);
        } else if (t instanceof Map) {
            targets = new ArrayList(length);
            Map tmp = (Map)t;
            while (targets.size() < length) {
                LinkedHashMap item = new LinkedHashMap(tmp.size());
                item.putAll(tmp);
                targets.add(item);
            }
            target.put(this.path[index], targets);
        } else {
            targets = (List)t;
        }
        this.assignList2List(targets, index + 1, values);
    }

    private void assignValue2List(List<?> targets, int index, Object value) {
        for (Object target : targets) {
            this.assign(target, index, value);
        }
    }

    private void assignList2List(List<?> targets, int index, Object[] values) {
        if (values.length == 0) {
            return;
        }
        if (targets.size() % values.length != 0) {
            throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u5217\u8868\u957f\u5ea6\u4e0d\u4e00\u81f4\uff1a%1$s(%2$s)", (String)"PropertyAssembler_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), StringUtil.join((Object[])this.path), index));
        }
        int i = 0;
        int j = 0;
        while (i < targets.size()) {
            if (j >= values.length) {
                j = 0;
            }
            this.assign(targets.get(i), index, values[j]);
            ++i;
            ++j;
        }
    }

    public String toString() {
        if (this.index == 0) {
            return StringUtil.join((Object[])this.path, (String)".");
        }
        return StringUtil.join((Object[])this.path, (String)".") + "[" + this.index + "]";
    }
}

