/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e.v.a;

import java.util.ArrayList;
import java.util.Map;
import kd.isc.iscb.platform.core.dc.e.v.Aggregation;

public class AdjustLevel
implements Aggregation {
    private String aggr;

    public AdjustLevel(String aggr) {
        this.aggr = aggr;
    }

    @Override
    public Object calc(Object value, Map<String, Object> src) {
        if (value == null) {
            return null;
        }
        if (value instanceof Object[]) {
            return this.adjust((Object[])value);
        }
        if ("level(+)".equals(this.aggr)) {
            return new Object[]{value};
        }
        return value;
    }

    private Object adjust(Object[] value) {
        int level = this.calcLevel(value);
        if ("level(+)".equals(this.aggr)) {
            return this.extendLevel(value, level + 1);
        }
        return this.reduceLevel(value, level - 1);
    }

    private int calcLevel(Object[] value) {
        int level = 1;
        while (value.length > 0 && value[0] instanceof Object[]) {
            value = (Object[])value[0];
            ++level;
        }
        return level;
    }

    private Object extendLevel(Object[] value, int targetLevel) {
        if (--targetLevel > 1) {
            Object[] list = new Object[value.length];
            for (int i = 0; i < value.length; ++i) {
                list[i] = this.extendLevel((Object[])value[i], targetLevel);
            }
            return list;
        }
        Object[] list = new Object[value.length];
        for (int i = 0; i < value.length; ++i) {
            list[i] = new Object[]{value[i]};
        }
        return list;
    }

    private Object reduceLevel(Object[] value, int targetLevel) {
        if (value.length == 0) {
            return value;
        }
        if (!(value[0] instanceof Object[])) {
            return value;
        }
        if (--targetLevel > 1) {
            Object[] list = new Object[value.length];
            for (int i = 0; i < value.length; ++i) {
                list[i] = this.reduceLevel((Object[])value[i], targetLevel);
            }
            return list;
        }
        ArrayList<Object> list = new ArrayList<Object>(value.length);
        for (Object e : value) {
            for (Object v : (Object[])e) {
                list.add(v);
            }
        }
        return list.toArray();
    }

    @Override
    public Aggregation.RunAt runAt() {
        return Aggregation.RunAt.AFTER_VALUE_CONVERT;
    }
}

