/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e.v.expressions;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import kd.bos.id.IDService;
import kd.isc.iscb.platform.core.dc.e.v.Expression;
import kd.isc.iscb.platform.core.dc.e.v.PropertyAssembler;
import kd.isc.iscb.platform.core.dc.e.v.PropertyEvaluator;
import kd.isc.iscb.platform.core.dc.meta.DataCopyTransformer;
import kd.isc.iscb.util.dt.i.Hex;
import kd.isc.iscb.util.misc.Base64;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.StringUtil;

public class NewId
implements Expression {
    @Override
    public Object eval(String expr, DataCopyTransformer param, Map<String, Object> data, PropertyAssembler a) {
        return this.generateId(expr, data, a);
    }

    private Object generateId(String s, Map<String, Object> data, PropertyAssembler a) {
        String[] path = a.getPath();
        return NewId.generate(data, s, path);
    }

    public static Object generate(Map<String, Object> data, String s, String[] path) {
        Object v = PropertyEvaluator.getValue(data, path);
        if (v instanceof Object[]) {
            Object[] list = (Object[])v;
            for (int i = 0; i < list.length; ++i) {
                list[i] = NewId.newId(s);
            }
            return list;
        }
        return NewId.newId(s);
    }

    private static Object newId(String s) {
        if ("#{new_uuid()}".equals(s)) {
            return UUID.randomUUID().toString();
        }
        if ("#{new_int_id()}".equals(s)) {
            return IDService.get().genLongId();
        }
        if ("#{new_int32_id()}".equals(s)) {
            byte[] bytes = StringUtil.toBytes((UUID)UUID.randomUUID());
            return Integer.MAX_VALUE & Hash.mur32((byte[])bytes);
        }
        if ("#{new_string_id()}".equals(s)) {
            byte[] bytes = StringUtil.toBytes((UUID)UUID.randomUUID());
            return new String(Base64.encode((byte[])bytes), StandardCharsets.UTF_8).substring(2, 20).replace('+', '_');
        }
        if (s.startsWith("#{new_boid(")) {
            byte[] bytes = StringUtil.toBytes((UUID)UUID.randomUUID());
            String type = s.substring(s.indexOf(40) + 1, s.indexOf(41));
            byte[] bostype = Hex.decode((String)type);
            return NewId.compositeBOID(bytes, bostype);
        }
        throw new UnsupportedOperationException(s);
    }

    private static Object compositeBOID(byte[] hash, byte[] bostype) {
        byte[] tmp = new byte[hash.length + bostype.length];
        System.arraycopy(hash, 0, tmp, 0, hash.length);
        System.arraycopy(bostype, 0, tmp, hash.length, bostype.length);
        return new String(Base64.encode((byte[])tmp), StandardCharsets.UTF_8);
    }
}

