/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.e.v.expressions;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.platform.core.dc.e.v.Expression;
import kd.isc.iscb.platform.core.dc.e.v.PropertyAssembler;
import kd.isc.iscb.platform.core.dc.meta.DataCopyTransformer;
import kd.isc.iscb.util.connector.TableUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.i.Hex;
import kd.isc.iscb.util.misc.Base64;
import kd.isc.iscb.util.misc.Hash;

public class SuperKey
implements Expression {
    @Override
    public Object eval(String expr, DataCopyTransformer param, Map<String, Object> data, PropertyAssembler a) {
        return this.generateKey(expr, param, data, a);
    }

    private Object generateKey(String s, DataCopyTransformer param, Map<String, Object> data, PropertyAssembler a) {
        if ("#{md5($keys)}".equals(s)) {
            return this.calcMd5OfKeys(param, data, a);
        }
        if ("#{mur($keys)}".equals(s)) {
            return this.calcMur64OfKeys(param, data, a);
        }
        if ("#{md5s18($keys)}".equals(s)) {
            return this.calcMd5S18OfKeys(param, data, a);
        }
        if ("#{mur32($keys)}".equals(s)) {
            return this.calcMur32OfKeys(param, data, a);
        }
        if (s.startsWith("#{boid($keys,")) {
            return this.calcBOSID(param, data, s, a);
        }
        if (s.startsWith("#{md5i64($keys)}")) {
            return this.calcMd5I64(param, data, a);
        }
        throw new IllegalArgumentException(s);
    }

    private Object calcMd5I64(DataCopyTransformer param, Map<String, Object> tar, PropertyAssembler a) {
        String sb = this.calcKeys(param, tar, a).trim();
        return Hash.md5i64((byte[])sb.getBytes(D.UTF_8));
    }

    private Object calcBOSID(DataCopyTransformer param, Map<String, Object> tar, String expr, PropertyAssembler a) {
        String sb = this.calcKeys(param, tar, a);
        byte[] hash = Hash.md5((byte[])sb.getBytes(D.UTF_8));
        byte[] bostype = Hex.decode((String)expr.substring(expr.indexOf(44) + 1, expr.indexOf(41)));
        return this.compositeBOID(hash, bostype);
    }

    private Object compositeBOID(byte[] hash, byte[] bostype) {
        byte[] tmp = new byte[hash.length + bostype.length];
        System.arraycopy(hash, 0, tmp, 0, hash.length);
        System.arraycopy(bostype, 0, tmp, hash.length, bostype.length);
        return new String(Base64.encode((byte[])tmp), StandardCharsets.UTF_8);
    }

    private Object calcMd5OfKeys(DataCopyTransformer param, Map<String, Object> tar, PropertyAssembler a) {
        String sb = this.calcKeys(param, tar, a);
        return Hash.md5((String)sb);
    }

    private Object calcMur64OfKeys(DataCopyTransformer param, Map<String, Object> tar, PropertyAssembler a) {
        String sb = this.calcKeys(param, tar, a);
        return Math.abs(Hash.mur64((byte[])sb.getBytes(D.UTF_8)));
    }

    private Object calcMd5S18OfKeys(DataCopyTransformer param, Map<String, Object> tar, PropertyAssembler a) {
        String sb = this.calcKeys(param, tar, a);
        return new String(Base64.encode((byte[])Hash.md5((byte[])sb.getBytes(D.UTF_8))), 0, 18, D.UTF_8).replace('+', '-');
    }

    private Object calcMur32OfKeys(DataCopyTransformer param, Map<String, Object> tar, PropertyAssembler a) {
        String sb = this.calcKeys(param, tar, a);
        return Math.abs(Hash.mur32((byte[])sb.getBytes(D.UTF_8)));
    }

    private String calcKeys(DataCopyTransformer param, Map<String, Object> tar, PropertyAssembler a) {
        List<String> judgeFields = this.getJudgeFields(param, a);
        return TableUtil.calcKeys(tar, judgeFields);
    }

    private List<String> getJudgeFields(DataCopyTransformer param, PropertyAssembler a) {
        if (a.getPathLength() == 1) {
            return param.getJudgeFields();
        }
        if (a.getPathLength() == 2) {
            return param.getEntryJudgeFields(a.getPath(0));
        }
        throw new UnsupportedOperationException("TODO-" + a);
    }
}

