/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.constant.ExecutionStatus;
import kd.isc.iscb.platform.core.dc.f.DataFileAction;
import kd.isc.iscb.platform.core.dc.f.DataFileJob;
import kd.isc.iscb.platform.core.task.DaemonTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.io.Counter;

public class DataFileCounterJob
implements DaemonTask {
    private String id = UUID.randomUUID().toString();
    private DataFileJob job;
    public static final int INTERVAL = 5;
    private static Log logger = LogFactory.getLog(DataFileCounterJob.class);

    public DataFileCounterJob(DataFileJob job) {
        this.job = job;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void run() {
        ExecutionStatus status = this.job.getStatus();
        if (status == ExecutionStatus.EXECUTIONING) {
            this.refreshDataToDB();
            ScheduleManager.submit((Task)this, 5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshDataToDB() {
        Counter c = this.job.getCounter();
        if (c != null) {
            boolean bl;
            Connection cn = null;
            try {
                Timestamp now = new Timestamp(System.currentTimeMillis());
                String sql = "UPDATE " + this.job.getAction().getJobTableName() + " SET fmodifytime=?, ftotal_count=?, fsuccess_count=?, ffailed_count=?, fignored_count=?, fdeal_bytes=? WHERE fstate='R' and fid=" + this.job.getJob().getPkValue();
                long deal_bytes = this.job.getAction() == DataFileAction.EXPORT ? c.getReadBytes() : c.getLoadBytes();
                int totalCount = this.job.getAction() == DataFileAction.IMPORT ? -1 : c.getTotalCount();
                List<Object> values = Arrays.asList(now, totalCount, c.getSuccessCount(), c.getFailedCount(), c.getIgnoredCount(), deal_bytes);
                List<Integer> types = Arrays.asList(93, 4, 4, 4, 4, -5);
                cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
                bl = DbUtil.executeUpdate((Connection)cn, (String)sql, values, types) == 1;
            }
            catch (Throwable e) {
                try {
                    logger.warn(e);
                    boolean bl2 = true;
                    return bl2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    DbUtil.close(cn, (boolean)true);
                }
            }
            DbUtil.close((Connection)cn, (boolean)true);
            return bl;
        }
        return false;
    }
}

