/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f;

import java.io.InputStream;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.id.IDService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.bos.util.StringUtils;
import kd.isc.iscb.platform.core.app.AppParameterServiceHelper;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.dc.f.DataFileAction;
import kd.isc.iscb.platform.core.dc.f.DataFileReader;
import kd.isc.iscb.platform.core.dc.f.DataFileSchema;
import kd.isc.iscb.platform.core.dc.f.DataFileType;
import kd.isc.iscb.platform.core.dc.f.DataFileWriter;
import kd.isc.iscb.platform.core.dc.f.ExportJobFileBinding;
import kd.isc.iscb.platform.core.dc.f.FileBinding;
import kd.isc.iscb.platform.core.dc.f.FileDirectReader;
import kd.isc.iscb.platform.core.dc.f.FileDirectWriter;
import kd.isc.iscb.platform.core.dc.f.ImportJobFileIterator;
import kd.isc.iscb.platform.core.dc.f.TemplateDownloader;
import kd.isc.iscb.platform.core.dc.f.e.ExportDataFileSchema;
import kd.isc.iscb.platform.core.dc.f.err.DataFileError;
import kd.isc.iscb.platform.core.dc.f.tag.FileTag;
import kd.isc.iscb.platform.core.util.FileUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ListAsReader;
import kd.isc.iscb.util.io.ObjectWriter;

public class DataFileUtils {
    private static final SecureRandom random = new SecureRandom();

    public static DynamicObject createDataFileJob(DynamicObject trigger, Map<String, Object> params, InitType type, DataFileAction action) {
        return DataFileUtils.createDataFileJob(null, trigger, params, type, action);
    }

    public static DynamicObject createDataFileJob(String jobName, DynamicObject trigger, Map<String, Object> params, InitType type, DataFileAction action) {
        if (DataFileUtils.hasRunningJob(trigger.getPkValue(), action)) {
            return null;
        }
        if (!D.x((Object)trigger.get("enable")) && AppParameterServiceHelper.isEnableControl()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\uff08%s\uff09\u672a\u542f\u7528\uff0c\u7981\u6b62\u6267\u884c\u3002", (String)"DataFileUtils_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), trigger.get("number")));
        }
        DynamicObject job = BusinessDataServiceHelper.newDynamicObject((String)action.getJobFormId());
        long id = IDService.get().genLongId();
        String number = DataCopyTask.generateExecutionNumber(trigger);
        job.set("id", (Object)id);
        job.set("number", (Object)number);
        job.set("name", (Object)DataFileUtils.generateExecutionName(jobName, trigger, type));
        job.set("trigger", (Object)trigger);
        job.set("file_schema", trigger.get("file_schema"));
        job.set("filetype", trigger.getDynamicObject("file_schema").get("filetype"));
        job.set("state", (Object)Character.valueOf('C'));
        job.set("total_count", (Object)-1);
        job.set("ignored_count", (Object)-1);
        job.set("creator", (Object)RequestContext.get().getUserId());
        job.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        if (DataFileAction.EXPORT == action) {
            job.set("params_entryentity", (Object)DataCopyTask.createParams(trigger, job, params));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{job});
        return BusinessDataServiceHelper.loadSingle((Object)job.getPkValue(), (String)action.getJobFormId());
    }

    public static boolean hasRunningJob(Object triggerId, DataFileAction action) {
        QFilter qfilter = new QFilter("trigger", "=", triggerId).and(new QFilter("state", "=", (Object)"R"));
        DynamicObject job = BusinessDataServiceHelper.loadSingle((String)action.getJobFormId(), (String)"id", (QFilter[])new QFilter[]{qfilter});
        return job != null;
    }

    private static String generateExecutionName(String jobName, DynamicObject trigger, InitType type) {
        String name;
        String string = name = jobName == null ? "[" + (Object)((Object)type) + "]" + D.s((Object)trigger.get("name")) : jobName;
        if (name.length() > 50) {
            name = name.substring(0, 48) + "..";
        }
        return name;
    }

    public static String getPrimaryKey(DynamicObject metaData) {
        String pk = null;
        for (DynamicObject item : metaData.getDynamicObjectCollection("prop_entryentity")) {
            if (!item.getBoolean("is_primary_key")) continue;
            String field = D.s((Object)item.get("prop_name"));
            if (pk != null && !field.equals(pk)) continue;
            pk = field;
        }
        return pk;
    }

    public static void bindingAttachments(List<Map<String, String>> url_list, Object jobId) {
        DynamicObject[] attachments = new DynamicObject[url_list.size()];
        for (int i = 0; i < url_list.size(); ++i) {
            Map<String, String> urlMap = url_list.get(i);
            long randId = IDService.get().genLongId();
            String fileType = DataFileUtils.trimStr(urlMap.get("file_type"));
            DynamicObject attachment = DataFileUtils.assignAttachmentValue(randId, urlMap.get("file_name"), fileType, D.l((Object)urlMap.get("file_size")), urlMap.get("upload_url"), ResManager.loadKDString((String)"\u6e90\u6587\u4ef6", (String)"DataFileUtils_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            attachment.set("fbilltype", (Object)"isc_import_file_job");
            attachment.set("fattachmentpanel", (Object)"import_file_pane");
            attachment.set("finterid", jobId);
            attachment.set("fmodifymen", (Object)RequestContext.get().getUserId());
            attachment.set("fmodifytime", (Object)D.t((Object)new Date()));
            attachments[i] = attachment;
        }
        SaveServiceHelper.save((DynamicObject[])attachments);
    }

    private static String trimStr(String type) {
        if (StringUtils.isNotEmpty((String)type) && type.length() > 30) {
            return type.substring(0, 30);
        }
        return type;
    }

    public static DynamicObject assignAttachmentValue(long attachId, String fileName, String fileType, long size, String url, String desc) {
        DynamicObject attachment = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
        attachment.set("id", (Object)attachId);
        attachment.set("fattachmentname", (Object)fileName);
        attachment.set("faliasfilename", (Object)fileName);
        attachment.set("fextname", (Object)fileType);
        attachment.set("fattachmentsize", (Object)size);
        attachment.set("ffileid", (Object)url);
        attachment.set("fnumber", (Object)("rc-upload-" + System.currentTimeMillis() + "-" + random.nextInt(100)));
        attachment.set("fcreatemen", (Object)RequestContext.get().getUserId());
        attachment.set("fcreatetime", (Object)D.t((Object)new Date()));
        attachment.set("fdescription", (Object)desc);
        return attachment;
    }

    public static String uploadFileToServer(InputStream input, String fileName) {
        long randId = IDService.get().genLongId();
        String appId = "iscb";
        String path = FileNameUtils.getAttachmentFileName((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)appId, (String)"isc_import_file_job", (Object)randId, (String)FileUtil.replaceSpeChar(fileName));
        FileItem fileItem = new FileItem(fileName, path, input);
        fileItem.setCreateNewFileWhenExists(true);
        return FileServiceFactory.getAttachmentFileService().upload(fileItem);
    }

    public static String uploadFileToServer(InputStream input, String fileName, String appId, String formId, Object pkId) {
        String path = FileNameUtils.getAttachmentFileName((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)appId, (String)formId, (Object)pkId, (String)FileUtil.replaceSpeChar(fileName));
        FileItem fileItem = new FileItem(fileName, path, input);
        fileItem.setCreateNewFileWhenExists(true);
        return FileServiceFactory.getAttachmentFileService().upload(fileItem);
    }

    @Deprecated
    public static DataFileReader createDataFileReader(DataFileSchema schema, DynamicObject job) throws Exception {
        DynamicObject trigger = schema.getTrigger();
        String fileType = trigger.getDynamicObject("file_schema").getString("filetype");
        ImportJobFileIterator iter = new ImportJobFileIterator(job.getPkValue());
        return DataFileType.buildReader(fileType, iter);
    }

    @Deprecated
    public static DataFileWriter buildDataFileWriter(DataFileSchema schema, Object jobId) throws Exception {
        DynamicObject trigger = schema.getTrigger();
        DynamicObject fileSchema = schema.getFileschema();
        String fileType = fileSchema.getString("filetype");
        String name = fileSchema.getString("name");
        long maxFileSize = fileSchema.getLong("filesize");
        boolean isCompress = trigger.getBoolean("compress");
        ExportJobFileBinding fileBinding = new ExportJobFileBinding(jobId, fileType, name, maxFileSize, isCompress);
        return DataFileType.buildWriter(fileType, schema.getFileschema().get("group_id"), fileBinding, DataFileUtils.buildRequiredFields(fileSchema));
    }

    public static Map<String, Object> buildRequiredFields(DynamicObject fileSchema) {
        LinkedHashMap<String, Object> requires = new LinkedHashMap<String, Object>();
        for (DynamicObject obj : fileSchema.getDynamicObjectCollection("fields")) {
            String src = D.s((Object)obj.get("alias"));
            if (src == null) {
                src = D.s((Object)obj.get("field"));
            }
            if (src.indexOf(46) < 0) {
                requires.putIfAbsent(src, 1);
                continue;
            }
            String[] path = src.split("\\.");
            ExportDataFileSchema.addEntryProperty(requires, path);
        }
        return requires;
    }

    public static void downloadTemplate(IFormView view, DataFileType type, DynamicObject fileSchema) throws Exception {
        FileTag fileTag = new FileTag(fileSchema.getString("group_id"));
        TemplateDownloader binding = new TemplateDownloader(view, DataFileUtils.getName(fileSchema, type));
        DataFileWriter writer = null;
        try {
            writer = type.createWriter((FileBinding)binding, fileTag, DataFileUtils.buildRequiredFieldsForTemplate(fileSchema));
            writer.commit();
        }
        catch (Exception e) {
            try {
                throw DataFileError.DATA_FILE_DOWNLOAD_TEMPLATE_FIAL.wrap((Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(writer);
                throw throwable;
            }
        }
        DbUtil.close((ObjectWriter)writer);
    }

    private static Map<String, Object> buildRequiredFieldsForTemplate(DynamicObject fileSchema) {
        LinkedHashMap<String, Object> requires = new LinkedHashMap<String, Object>();
        for (DynamicObject obj : fileSchema.getDynamicObjectCollection("fields")) {
            String src = D.s((Object)obj.get("alias"));
            if (src == null) {
                src = D.s((Object)obj.get("field"));
            }
            if (src == null) continue;
            if (src.indexOf(46) < 0) {
                requires.putIfAbsent(src, 1);
                continue;
            }
            String[] path = src.split("\\.");
            ExportDataFileSchema.addEntryProperty(requires, path);
        }
        return requires;
    }

    private static String getName(DynamicObject fileSchema, DataFileType type) {
        String name = fileSchema.getString("name");
        String number = fileSchema.getString("number");
        String typeStr = type.name().toLowerCase();
        return String.format(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u6a21\u677f_%1$s_%2$s.%3$s", (String)"DataFileUtils_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name, number, typeStr);
    }

    public static long getMaxFileSize() {
        return DataFileUtils.getSysProperty("ISC_MAX_FILE_SIZE", 0x500000L);
    }

    public static long getMaxDataSize() {
        return DataFileUtils.getSysProperty("ISC_MAX_DATA_SIZE", 0x1400000L);
    }

    private static long getSysProperty(String propName, long defaultVal) {
        long MAX_FILE_SIZE;
        String size = System.getProperty(propName);
        if (size == null) {
            size = System.getenv(propName);
        }
        if ((MAX_FILE_SIZE = D.l((Object)size)) <= 0L) {
            MAX_FILE_SIZE = defaultVal;
        }
        return MAX_FILE_SIZE;
    }

    public static long calcSizeAndCheck(long readBytes, long maxDataSize, Object obj) {
        if ((readBytes += DbUtil.getObjectSize((Object)obj)) > maxDataSize) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u7684\u6570\u636e\u8d85\u51fa\u9650\u5236\uff0c\u6700\u5927\u53ef\u8bfb\u53d6\u6570\u636e\u4e3a%s\u5b57\u8282\uff0c\u53ef\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u4fee\u6539JVM\u7cfb\u7edf\u53c2\u6570ISC_MAX_DATA_SIZE\u7684\u503c\uff08\u5355\u4f4d\uff1a\u5b57\u8282\uff09\uff0c\u4ee5\u8c03\u6574\u6700\u5927\u9650\u5236\u3002", (String)"DataFileUtils_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), maxDataSize));
        }
        return readBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<List<Object>> read(FileDirectReader reader) {
        try {
            long maxDataSize = DataFileUtils.getMaxDataSize();
            long readBytes = 0L;
            ArrayList<List<Object>> res = new ArrayList<List<Object>>();
            List<Object> list = reader.readLine();
            while (list != null) {
                res.add(list);
                readBytes = DataFileUtils.calcSizeAndCheck(readBytes, maxDataSize, list);
                list = reader.readLine();
            }
            ArrayList<List<Object>> arrayList = res;
            return arrayList;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static void write(FileDirectWriter writer, ListAsReader<List<Object>> reader) {
        try {
            List list = (List)reader.read();
            while (list != null) {
                writer.writeLine(list);
                list = (List)reader.read();
            }
            writer.commit();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static enum EntityType {
        ISC_METADATA_SCHEMA,
        ISC_DATA_COPY,
        ISC_DATA_COPY_TRIGGER;

    }

    public static enum InitType {
        TIMER(new MultiLangEnumBridge("\u5b9a\u65f6", "DataFileUtils_0", "isc-iscb-platform-core")),
        MANUAL(new MultiLangEnumBridge("\u4eba\u5de5", "DataFileUtils_1", "isc-iscb-platform-core")),
        FUNC(new MultiLangEnumBridge("\u811a\u672c", "DataFileUtils_2", "isc-iscb-platform-core")),
        MICRO_SERVICE(new MultiLangEnumBridge("\u5fae\u670d\u52a1", "DataFileUtils_3", "isc-iscb-platform-core"));

        private MultiLangEnumBridge description;

        private InitType(MultiLangEnumBridge description) {
            this.description = description;
        }

        public String toString() {
            return this.description.loadKDString();
        }
    }
}

