/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import kd.isc.iscb.platform.core.dc.f.DataFileUtils;
import kd.isc.iscb.platform.core.dc.f.FileBinding;
import kd.isc.iscb.util.script.misc.HttpDownloadFile;

public class GetBytesFromTempFile
implements FileBinding {
    private List<byte[]> files;
    private long maxFileSize;

    public GetBytesFromTempFile(List<byte[]> files) {
        this.files = files;
        this.maxFileSize = DataFileUtils.getMaxFileSize();
    }

    @Override
    public void bind(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);
             ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            HttpDownloadFile.copyStream((InputStream)in, (ByteArrayOutputStream)baos, (long)this.maxFileSize);
            this.files.add(baos.toByteArray());
        }
    }

    @Override
    public long maxFileSize() {
        return this.maxFileSize;
    }
}

