/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.dc.f.FileBinding;
import kd.isc.iscb.util.except.IscBizException;

public class TemplateDownloader
implements FileBinding {
    private static Log logger = LogFactory.getLog(TemplateDownloader.class);
    private IFormView view;
    private String fileName;

    public TemplateDownloader(IFormView view, String fileName) {
        this.view = view;
        this.fileName = fileName;
    }

    @Override
    public void bind(File file) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(this.fileName, (InputStream)in, 1800);
            this.view.openUrl(urls);
        }
        catch (IOException e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4ece%s\u5730\u5740\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff01", (String)"TemplateDownloader_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), file.getAbsolutePath()), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    logger.warn((Throwable)e);
                }
            }
        }
    }

    @Override
    public long maxFileSize() {
        return 0L;
    }
}

