/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f.i;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.constant.ExecutionStatus;
import kd.isc.iscb.platform.core.dc.e.BizBatchException;
import kd.isc.iscb.platform.core.dc.e.DataCopyOutput;
import kd.isc.iscb.platform.core.dc.f.DataFileAction;
import kd.isc.iscb.platform.core.dc.f.DataFileCounterJob;
import kd.isc.iscb.platform.core.dc.f.DataFileJob;
import kd.isc.iscb.platform.core.dc.f.DataFileJobLogger;
import kd.isc.iscb.platform.core.dc.f.DataFileReader;
import kd.isc.iscb.platform.core.dc.f.DataFileType;
import kd.isc.iscb.platform.core.dc.f.SimpleFieldMapping;
import kd.isc.iscb.platform.core.dc.f.i.ImportDataFileFactory;
import kd.isc.iscb.platform.core.dc.f.i.ImportDataFileSchema;
import kd.isc.iscb.platform.core.dc.meta.DataCopyConsumer;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.except.ConnectionException;
import kd.isc.iscb.util.except.HandledException;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.StringUtil;

public class ImportDataFileJob
extends DataFileJob {
    public static final ImportDataFileFactory FACTORY = new ImportDataFileFactory();
    private static final DataFileAction action = DataFileAction.IMPORT;
    private DataFileReader reader;
    private DataCopyConsumer consumer;
    private DataCopyOutput output;
    private SimpleFieldMapping fieldMapping;

    public ImportDataFileJob(String title, Object jobId) {
        super(title, jobId, action);
        ImportDataFileSchema param = new ImportDataFileSchema(this.job, this);
        this.param = param;
        this.consumer = param.getConsumer();
        this.fieldMapping = new SimpleFieldMapping(param.getFileschema(), DataFileAction.IMPORT);
    }

    public ImportDataFileJob(DynamicObject job) {
        super(job, action);
        ImportDataFileSchema param = new ImportDataFileSchema(job, this);
        this.param = param;
        this.consumer = param.getConsumer();
        this.fieldMapping = new SimpleFieldMapping(param.getFileschema(), DataFileAction.IMPORT);
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public void run() {
        SignalManager.registerTask(this.jobId);
        try {
            this.importData();
        }
        finally {
            SignalManager.unregisterTask(this.jobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importData() {
        ScheduleManager.submit((Task)new DataFileCounterJob(this), 5);
        this.status = ExecutionStatus.EXECUTIONING;
        try {
            if (!IscLicenseUtil.getTenantLicenseInfo().hasValidLicense()) {
                IscBizException e = new IscBizException(ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u8bb8\u53ef\u6570\u91cf\u4e3a\u96f6\u6216\u8bb8\u53ef\u5df2\u8fc7\u671f\uff0c\u65e0\u6cd5\u4f7f\u7528\u6570\u636e\u8fc1\u79fb\u529f\u80fd\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u4e3a\u96c6\u6210\u4e91\u6dfb\u52a0\u8bb8\u53ef\u3002", (String)"ImportDataFileJob_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
                e.setStackTrace(new StackTraceElement[0]);
                throw e;
            }
            DataFileJobLogger.saveStartLogForImport(this.job, this.counter, this.consumer);
            LinkedList<Map<String, Object>> buffer = new LinkedList<Map<String, Object>>();
            this.prepare();
            Map src = (Map)this.reader.read();
            while (src != null) {
                Map<String, Object> tar = this.fieldMapping.mapping(src);
                this.write(tar, buffer);
                src = (Map)this.reader.read();
            }
            this.commit(buffer);
            DataFileJobLogger.saveSuccessLog(this.job, this.counter);
            this.status = ExecutionStatus.FINISHED;
        }
        catch (Throwable e) {
            ExecutionStatus executionStatus = this.status = e instanceof TaskCancelException ? ExecutionStatus.UNDONE : ExecutionStatus.FAIL;
            if (this.output != null && this.output.rollback(e)) {
                this.counter.rollback();
            }
            DataFileJobLogger.saveErrorLogForImport(this, e, this.counter);
            if (e instanceof TaskCancelException) {
                throw (TaskCancelException)e;
            }
        }
        finally {
            this.status = ExecutionStatus.FINISHED;
            DbUtil.close((ObjectReader)this.reader);
            if (this.output != null) {
                this.output.dispose();
            }
        }
    }

    protected void prepare() throws Exception {
        if (this.reader == null) {
            this.reader = DataFileType.buildReader(this.param, this.job);
        }
        if (this.output == null) {
            this.output = new DataCopyOutput(this.consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(Map<String, Object> src, List<Map<String, Object>> buffer) {
        Throwable error = null;
        try {
            SignalManager.checkCancelSignal();
            this.output.write(src);
            this.writeSuccessLog(src);
        }
        catch (Throwable e) {
            error = e;
            this.setFailedAction(src, e);
            this.writeFailLog(src, e);
            this.tryThrowError(e);
        }
        finally {
            buffer.add(src);
            this.refreshCounter(buffer, error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void refreshCounter(List<Map<String, Object>> buffer, Throwable err) {
        ArrayList<Object> failed = new ArrayList<Object>(buffer.size());
        try {
            this.refreshCounterAndCollectFailed(buffer, failed);
            if (failed.isEmpty()) return;
        }
        catch (Throwable throwable) {
            if (failed.isEmpty()) throw throwable;
            String message = String.format(ResManager.loadKDString((String)"\u6279\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0: %s", (String)"ImportDataFileJob_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), StringUtil.toString((Throwable)err));
            DataFileJobLogger.writeBatchFailLog(failed, this, message);
            throw throwable;
        }
        String message = String.format(ResManager.loadKDString((String)"\u6279\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0: %s", (String)"ImportDataFileJob_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), StringUtil.toString((Throwable)err));
        DataFileJobLogger.writeBatchFailLog(failed, this, message);
    }

    private void refreshCounterAndCollectFailed(List<Map<String, Object>> buffer, List<Object> failed) {
        Iterator<Map<String, Object>> it = buffer.iterator();
        while (it.hasNext()) {
            Map<String, Object> tar = it.next();
            SaveDataType action = (SaveDataType)tar.get("$action");
            if (tar.containsKey("$error_message")) {
                failed.add(tar);
            }
            if (action == null) continue;
            it.remove();
            this.tarActionHandle(action);
        }
    }

    private void writeFailLog(Map<String, Object> src, Throwable e) {
        if (e instanceof BizBatchException) {
            return;
        }
        DataFileJobLogger.writeFailLog(src, this, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(List<Map<String, Object>> buffer) {
        Throwable error = null;
        try {
            this.output.commit();
        }
        catch (Throwable e) {
            error = e;
            this.writeFailLog(null, e);
            this.tryThrowError(e);
        }
        finally {
            this.refreshCounter(buffer, error);
        }
    }

    private void tryThrowError(Throwable e) {
        if (e instanceof TaskCancelException) {
            throw (TaskCancelException)e;
        }
        if (e instanceof ConnectionException) {
            throw (ConnectionException)e;
        }
        if (this.consumer.isBreakOnError()) {
            if (e instanceof HandledException) {
                throw (HandledException)e;
            }
            throw new HandledException(e);
        }
    }

    private void writeSuccessLog(Map<String, Object> tar) {
        if (((ImportDataFileSchema)this.param).isTraceAll()) {
            DataFileJobLogger.writeSuccessLog(tar, this);
        }
    }

    public DataCopyConsumer getConsumer() {
        return this.consumer;
    }
}

