/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f.script;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.id.IDService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.connector.self.AttachmentUtil;
import kd.isc.iscb.platform.core.dc.f.DataFileUtils;
import kd.isc.iscb.platform.core.dc.f.script.Params;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class FileUtil {
    public static Map<String, Object> uploadAndBindFile(String funcName, Object[] args) {
        Params params = new Params(args);
        String url = FileUtil.uploadFileToServer(funcName, params);
        long id = IDService.get().genLongId();
        FileUtil.bindFile(params, url, id);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("url", url);
        result.put("id", id);
        result.put("uid", params.getUid());
        return result;
    }

    public static void bindFile(Params params, String url, long id) {
        List<String> keys = AttachmentUtil.getAttachmentPanelKeys(params.getEntityName());
        if (keys.contains(params.getField())) {
            FileUtil.bindPanel(params, url, id);
        } else {
            FileUtil.bindField(params, url, id);
        }
    }

    public static void bindPanel(Params params, String url, long id) {
        try {
            FileUtil.attachToPanel(params, url, id);
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6(%1$s)\u7ed1\u5b9a\u9644\u4ef6\u9762\u677f(%2$s)\u5931\u8d25", (String)"FileUtil_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), params.getFilename(), params.getField()), (Throwable)e);
        }
    }

    public static void bindField(Params params, String url, long id) {
        try {
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)params.getPk(), (String)params.getEntityName());
            FileUtil.attachToField(params, url, id);
            FileUtil.setAttachmentRef(bill, id, params.getField());
            ConnectorUtil.save(bill);
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6(%1$s)\u7ed1\u5b9a\u9644\u4ef6\u5b57\u6bb5(%2$s)\u5931\u8d25", (String)"FileUtil_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), params.getFilename(), params.getField()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String uploadFileToServer(String funcName, Params params) {
        try (ByteArrayInputStream in = new ByteArrayInputStream(params.getContent());){
            String string = DataFileUtils.uploadFileToServer(in, params.getFilename());
            return string;
        }
        catch (IOException e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u51fd\u6570%s\u5c06\u5b57\u8282\u6570\u636e\u6301\u4e45\u5316\u5230\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25\u3002", (String)"FileUtil_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), funcName), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String uploadFileToServer(String funcName, byte[] content, String fileName, String appId, String formId, Object pk) {
        try (ByteArrayInputStream in = new ByteArrayInputStream(content);){
            String string = DataFileUtils.uploadFileToServer(in, fileName, appId, formId, pk);
            return string;
        }
        catch (IOException e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u51fd\u6570%s\u5c06\u5b57\u8282\u6570\u636e\u6301\u4e45\u5316\u5230\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25\u3002", (String)"FileUtil_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), funcName), (Throwable)e);
        }
    }

    public static void setAttachmentRef(DynamicObject bill, long attachId, String property) {
        DynamicObjectCollection rows = bill.getDynamicObjectCollection(property);
        BasedataProp bdProp = (BasedataProp)rows.getDynamicObjectType().getProperties().get((Object)"fbasedataid");
        BasedataEntityType refType = (BasedataEntityType)bdProp.getComplexType();
        DynamicObject attach = BusinessDataServiceHelper.loadSingle((Object)attachId, (DynamicObjectType)refType);
        DynamicObject row = new DynamicObject(rows.getDynamicObjectType());
        bdProp.setValue((Object)row, (Object)attach);
        rows.add((Object)row);
    }

    public static void attachToPanel(Params params, String url, long id) {
        DynamicObject attachment = DataFileUtils.assignAttachmentValue(id, params.getFilename(), FileUtil.parseFileType(params.getFilename()), params.getContent().length, url, "");
        attachment.set("fbilltype", (Object)params.getEntityName());
        attachment.set("fattachmentpanel", (Object)params.getField());
        attachment.set("finterid", params.getPk());
        attachment.set("fmodifymen", (Object)RequestContext.get().getCurrUserId());
        attachment.set("fmodifytime", (Object)D.t((Object)new Date()));
        attachment.set("fnumber", (Object)params.getUid());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachment});
    }

    public static void attachToField(Params params, String url, long id) {
        DynamicObject attachment = BusinessDataServiceHelper.newDynamicObject((String)"bd_attachment");
        attachment.set("id", (Object)id);
        attachment.set("name", (Object)params.getFilename());
        attachment.set("status", (Object)"B");
        attachment.set("size", (Object)params.getContent().length);
        attachment.set("url", (Object)url);
        attachment.set("type", (Object)FileUtil.parseFileType(params.getFilename()));
        attachment.set("uid", (Object)params.getUid());
        attachment.set("creator", (Object)RequestContext.get().getCurrUserId());
        attachment.set("createtime", (Object)D.t((Object)new Date()));
        attachment.set("tempfile", (Object)"1");
        attachment.set("number", (Object)UUID.randomUUID().toString());
        attachment.set("description", (Object)"");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachment});
    }

    public static String parseFileType(String fileName) {
        int pos = fileName.lastIndexOf(46);
        if (pos < 0) {
            return "";
        }
        String type = fileName.substring(pos + 1);
        if (StringUtils.isNotEmpty((String)type) && type.length() > 30) {
            return type.substring(0, 30);
        }
        return type;
    }

    public static void checkExists(String entityName, Object pk) {
        if (!QueryServiceHelper.exists((String)entityName, (Object)pk)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8981\u7ed1\u5b9a\u7684\u5355\u636eid\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e %1$s(%2$s)", (String)"FileUtil_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entityName, D.s((Object)pk)));
        }
    }

    public static void checkParams(String funcName, Map<String, Object> map) {
        byte[] content = (byte[])map.get("content");
        if (content == null || content.length == 0) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"%s\u51fd\u6570\u4e0a\u4f20\u9644\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u51fd\u6570\u7684\u5165\u53c2", (String)"FileUtil_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]), funcName));
        }
        if ((long)content.length > DataFileUtils.getMaxFileSize()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u5927\u5c0f\u8d85\u51fa\u9650\u5236\uff0c\u6700\u5927\u53ef\u4e0a\u4f20\u6587\u4ef6\u5927\u5c0f\u4e3a%1$s\u5b57\u8282\uff0c\u5f53\u524d\u6587\u4ef6\u5927\u5c0f%2$s\u5b57\u8282\uff0c\u53ef\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u4fee\u6539JVM\u7cfb\u7edf\u53c2\u6570ISC_MAX_FILE_SIZE\u7684\u503c\uff08\u5355\u4f4d\uff1a\u5b57\u8282\uff09\uff0c\u4ee5\u8c03\u6574\u6700\u5927\u9650\u5236\u3002", (String)"Params_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), DataFileUtils.getMaxFileSize(), content.length));
        }
        String fileName = D.s((Object)map.get("fileName"));
        if (fileName == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"%s\u51fd\u6570\u8c03\u7528\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"FileUtil_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]), funcName));
        }
        String appId = D.s((Object)map.get("appId"));
        if (appId == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"%s\u51fd\u6570\u4e0a\u4f20\u9644\u4ef6appId\u4e0d\u80fd\u4e3a\u7a7a", (String)"FileUtil_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]), funcName));
        }
        String formId = D.s((Object)map.get("formId"));
        if (formId == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"%s\u51fd\u6570\u4e0a\u4f20\u9644\u4ef6formId\u4e0d\u80fd\u4e3a\u7a7a", (String)"FileUtil_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]), funcName));
        }
    }
}

