/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f.script;

import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import javax.script.ScriptContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.IDService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.dc.f.script.EntryParams;
import kd.isc.iscb.platform.core.dc.f.script.FileUtil;
import kd.isc.iscb.platform.core.dc.f.script.UploadAndBindFile;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class UploadAndBindFile3
extends UploadAndBindFile {
    @Override
    public String name() {
        return "uploadAndBindFile3";
    }

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        EntryParams params = new EntryParams(args);
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)params.getPk(), (String)params.getEntityName());
        DynamicObjectCollection rows = bill.getDynamicObjectCollection(params.getEntryname());
        this.checkEntryIsExit(params, rows);
        String url = FileUtil.uploadFileToServer(this.name(), params.getContent(), params.getFilename(), params.getAppid(), params.getFormId(), params.getPk());
        long id = IDService.get().genLongId();
        this.bindField(bill, params, url, id);
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        result.put("url", url);
        result.put("id", id);
        result.put("uid", params.getUid());
        return result;
    }

    private void checkEntryIsExit(EntryParams params, DynamicObjectCollection rows) {
        boolean exit = false;
        for (DynamicObject row : rows) {
            if (!params.getEntrypk().equals(row.getPkValue())) continue;
            exit = true;
            break;
        }
        if (!exit) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0a\u4f20\u9644\u4ef6\u5931\u8d25\uff0cid\u4e3a%1$s\u7684\u5355\u636e%2$s\u4e2d\u4e0d\u5b58\u5728\u5206\u5f55\u4e3b\u952e\u4e3a%3$s\u7684\u5206\u5f55", (String)"UploadAndBindFile3_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), params.getPk(), params.getEntityName(), params.getEntrypk()));
        }
    }

    private void bindField(DynamicObject bill, EntryParams params, String url, long id) {
        try {
            this.attachToField(params, url, id);
            this.setAttachmentRef(bill, id, params);
            ConnectorUtil.save(bill);
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6(%1$s)\u7ed1\u5b9a\u9644\u4ef6\u5b57\u6bb5(%2$s)\u5931\u8d25", (String)"FileUtil_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), params.getFilename(), params.getEntryfield()), (Throwable)e);
        }
    }

    private void setAttachmentRef(DynamicObject bill, long attachId, EntryParams params) {
        DynamicObjectCollection rows = bill.getDynamicObjectCollection(params.getEntryname());
        for (DynamicObject row : rows) {
            if (!params.getEntrypk().equals(row.getPkValue())) continue;
            MulBasedataDynamicObjectCollection collection = (MulBasedataDynamicObjectCollection)row.get(params.getEntryfield());
            DynamicObject obj = collection.addNew();
            obj.set("fbasedataid", (Object)attachId);
            break;
        }
    }

    private void attachToField(EntryParams params, String url, long id) {
        DynamicObject attachment = BusinessDataServiceHelper.newDynamicObject((String)"bd_attachment");
        attachment.set("id", (Object)id);
        attachment.set("name", (Object)params.getFilename());
        attachment.set("status", (Object)"B");
        attachment.set("size", (Object)params.getContent().length);
        attachment.set("url", (Object)url);
        attachment.set("type", (Object)FileUtil.parseFileType(params.getFilename()));
        attachment.set("uid", (Object)params.getUid());
        attachment.set("creator", (Object)RequestContext.get().getCurrUserId());
        attachment.set("createtime", (Object)D.t((Object)new Date()));
        attachment.set("tempfile", (Object)"1");
        attachment.set("number", (Object)UUID.randomUUID().toString());
        attachment.set("description", (Object)"");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachment});
    }
}

