/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f.t.excel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.dc.f.t.excel.ExcelType;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class SheetDataReadHelper {
    private Sheet sheet;
    private int curRowIndex = 0;
    private FieldInfo fieldInfo;
    private Map<String, List<Pair<String, Integer>>> judgeFields;
    private ExcelType excelType;

    public SheetDataReadHelper(Sheet sheet, Map<String, List<String>> judgeFields, ExcelType excelType) {
        this.sheet = sheet;
        this.judgeFields = new HashMap<String, List<Pair<String, Integer>>>();
        this.fieldInfo = new FieldInfo(-1, "", null, new HashMap(), false);
        this.excelType = excelType;
        this.initFieldInfos(judgeFields);
    }

    private void initFieldInfos(Map<String, List<String>> judgeFields) {
        Row header = this.sheet.getRow(this.curRowIndex);
        int index = 0;
        Iterator it = header.cellIterator();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            String value = cell.getStringCellValue();
            if (StringUtil.isEmpty((String)value)) continue;
            this.parseFieldsMap("", value, index++, this.fieldInfo, judgeFields);
        }
    }

    public void parseFieldsMap(String pre, String field, int index, FieldInfo fieldInfo, Map<String, List<String>> judgeFields) {
        int pos = field.indexOf(46);
        if (pos < 0) {
            this.parseSingleField(pre, field, index, fieldInfo, judgeFields);
        } else {
            this.parseEntryAndF7(pre, field, index, fieldInfo, judgeFields, pos);
        }
    }

    private void parseEntryAndF7(String pre, String field, int index, FieldInfo fieldInfo, Map<String, List<String>> judgeFields, int pos) {
        String entry = field.substring(0, pos);
        String tmpPre = StringUtil.isEmpty((String)pre) ? entry : pre + "." + entry;
        FieldInfo childField = (FieldInfo)fieldInfo.entryFields.get(entry);
        if (judgeFields.containsKey(tmpPre)) {
            this.parseEntryField(field, index, fieldInfo, judgeFields, pos, entry, tmpPre, childField);
        } else {
            this.parseF7Field(pre, field, index, fieldInfo, judgeFields, pos, entry, tmpPre, childField);
        }
    }

    private void parseEntryField(String field, int index, FieldInfo fieldInfo, Map<String, List<String>> judgeFields, int pos, String entry, String tmpPre, FieldInfo childField) {
        if (childField == null) {
            childField = new FieldInfo(-1, tmpPre, fieldInfo, new HashMap(), true);
            fieldInfo.entryFields.put(entry, childField);
        }
        this.parseFieldsMap(tmpPre, field.substring(pos + 1), index, childField, judgeFields);
    }

    private void parseF7Field(String pre, String field, int index, FieldInfo fieldInfo, Map<String, List<String>> judgeFields, int pos, String entry, String tmpPre, FieldInfo childField) {
        if (childField == null) {
            childField = new FieldInfo(-1, tmpPre, fieldInfo, new HashMap(), false);
            fieldInfo.entryFields.put(entry, childField);
        }
        List<String> billJudges = judgeFields.get(pre);
        boolean isJudge = billJudges.contains(field);
        String fieldName = field.substring(pos + 1);
        if (childField.entryFields == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5bfc\u5165\u65b9\u6848\u4e2d\u7684\u5b57\u6bb5(%s)\uff0c\u57fa\u7840\u8d44\u6599\u53ea\u652f\u6301\u9009\u62e9\u4e0b\u4e00\u7ea7\u5982\uff08creator.number\uff09\uff0c\uff08creator.name.zh_CN\u591a\u8bed\u8a00\u9664\u5916\uff09\u82e5\u9009\u62e9\u4e86\u5177\u4f53\u5b57\u6bb5\uff0c\u5982creator.number\uff0c\u4e0d\u53ef\u518d\u9009\u62e9creator\uff0c\u9700\u6539\u6210creator.id\u6216\u6839\u636e\u60c5\u51b5\u79fb\u9664creator", (String)"SheetDataReadHelper_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), field));
        }
        this.parseFieldsMap(pre, fieldName, index, (FieldInfo)fieldInfo.entryFields.get(entry), judgeFields);
        if (isJudge) {
            this.setJudgeField(index, pre, field);
        }
    }

    private void parseSingleField(String pre, String field, int index, FieldInfo fieldInfo, Map<String, List<String>> judgeFields) {
        List<String> billJudges = judgeFields.get(pre);
        boolean isJudges = billJudges.contains(field);
        fieldInfo.entryFields.put(field, new FieldInfo(index, pre, fieldInfo));
        if (isJudges) {
            this.setJudgeField(index, pre, field);
        }
    }

    public void setJudgeField(int index, String pre, String field) {
        List<Pair<String, Integer>> list = this.judgeFields.get(pre);
        if (list == null) {
            list = new ArrayList<Pair<String, Integer>>();
            this.judgeFields.put(pre, list);
        }
        list.add((Pair<String, Integer>)new Pair((Object)field, (Object)index));
    }

    public Map<String, Object> read() {
        Row row;
        HashMap<String, Object> data = new HashMap<String, Object>();
        if ((row = this.sheet.getRow(++this.curRowIndex)) == null) {
            return null;
        }
        this.helpRead(row, this.fieldInfo, data);
        return data;
    }

    private int helpRead(Row row, FieldInfo fieldInfo, Map<String, Object> data) {
        int index = row.getRowNum();
        for (Map.Entry fieldEntry : fieldInfo.entryFields.entrySet()) {
            FieldInfo childFieldInfo = (FieldInfo)fieldEntry.getValue();
            if (childFieldInfo.isEntry) {
                if (this.hasNotNullValue(row, childFieldInfo)) {
                    int tmpIndex = this.readEntryField(row, (String)fieldEntry.getKey(), childFieldInfo, data);
                    index = Math.max(tmpIndex, index);
                    continue;
                }
                this.dealEmptyEntry(data, childFieldInfo);
                continue;
            }
            if (childFieldInfo.entryFields != null) {
                this.readF7Field(row, (String)fieldEntry.getKey(), childFieldInfo, data);
                continue;
            }
            this.readSingleValue(row, (String)fieldEntry.getKey(), childFieldInfo, data);
        }
        return index;
    }

    private void dealEmptyEntry(Map<String, Object> data, FieldInfo childFieldInfo) {
        String tmp = childFieldInfo.preFix;
        if (tmp.contains(".")) {
            data.put(tmp.substring(tmp.lastIndexOf(46) + 1), new ArrayList());
        } else {
            data.put(tmp, new ArrayList());
        }
    }

    private void readF7Field(Row row, String key, FieldInfo fieldInfo, Map<String, Object> data) {
        HashMap obj = data.get(key);
        if (obj == null) {
            obj = new HashMap();
            data.put(key, obj);
        } else if (!(obj instanceof Map)) {
            return;
        }
        this.readF7Data(key, fieldInfo.entryFields, row, data);
    }

    private void readF7Data(String key, Map<String, FieldInfo> fields, Row row, Map<String, Object> data) {
        Map tmpData = (Map)data.get(key);
        for (Map.Entry<String, FieldInfo> entry : fields.entrySet()) {
            key = entry.getKey();
            tmpData.putIfAbsent(key, new HashMap());
            if (entry.getValue().entryFields != null) {
                this.readF7Data(key, entry.getValue().entryFields, row, tmpData);
                continue;
            }
            this.readSingleValue(row, key, entry.getValue(), tmpData);
        }
    }

    private int readEntryField(Row row, String key, FieldInfo fieldInfo, Map<String, Object> data) {
        ArrayList obj = data.get(key);
        if (obj == null) {
            obj = new ArrayList();
            data.put(key, obj);
        } else if (!(obj instanceof List)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u5b57\u6bb5\u540d\u548c\u5206\u5f55\u540d: %s \uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SheetDataReadHelper_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), key));
        }
        List list = obj;
        HashMap<String, Object> map = new HashMap<String, Object>();
        list.add(map);
        int index = this.helpRead(row, fieldInfo, map);
        boolean hasNextEntry = this.hasNextEntry(index + 1, fieldInfo);
        if (hasNextEntry) {
            Row nextRow = this.sheet.getRow(index + 1);
            this.curRowIndex = Math.max(this.curRowIndex, index + 1);
            return this.readEntryField(nextRow, key, fieldInfo, data);
        }
        return index;
    }

    private boolean hasNextEntry(int index, FieldInfo entryInfo) {
        Row row = this.sheet.getRow(index);
        if (row == null) {
            return false;
        }
        boolean hasNotNullValue = this.hasNotNullValue(row, entryInfo);
        if (hasNotNullValue) {
            FieldInfo parentField = entryInfo.pre;
            boolean parentHasNextValue = this.hasNotNullValue(row, parentField);
            return !parentHasNextValue;
        }
        return false;
    }

    private boolean hasNotNullValue(Row row, FieldInfo entryInfo) {
        String entryName = entryInfo.preFix;
        List<Pair<String, Integer>> judges = this.judgeFields.get(entryName);
        if (judges == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55 %s \u6ca1\u6709\u5019\u9009\u952e\u3002", (String)"SheetDataReadHelper_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entryName));
        }
        boolean hasNotNullValue = false;
        for (Pair<String, Integer> pair : judges) {
            Cell cell = row.getCell(((Integer)pair.getB()).intValue());
            if (cell == null || cell.getStringCellValue() == null) continue;
            hasNotNullValue = true;
            break;
        }
        return hasNotNullValue;
    }

    private void readSingleValue(Row row, String key, FieldInfo fieldInfo, Map<String, Object> data) {
        Cell cell = row.getCell(fieldInfo.index);
        data.put(key, this.excelType.getValue(cell));
    }

    static class FieldInfo {
        private int index;
        private String preFix;
        private boolean isEntry;
        private FieldInfo pre;
        private Map<String, FieldInfo> entryFields;

        private FieldInfo(int index, String preFix, FieldInfo pre, Map<String, FieldInfo> entryFields, boolean isEntry) {
            this.index = index;
            this.preFix = preFix;
            this.pre = pre;
            this.isEntry = isEntry;
            this.entryFields = entryFields;
        }

        private FieldInfo(int index, String preFix, FieldInfo pre) {
            this.index = index;
            this.preFix = preFix;
            this.pre = pre;
        }
    }
}

