/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f.t.excel;

import java.util.Collection;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.dc.f.err.DataFileJobFailException;
import kd.isc.iscb.platform.core.dc.f.t.excel.ExcelFileWriter;
import kd.isc.iscb.util.except.IscBizException;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class SheetDataWriteHelper {
    private Sheet sheet;
    private Map<String, Object> targetFields;
    private int curRowIndex = 0;

    public SheetDataWriteHelper(Sheet sheet, Map<String, Object> targetFields) {
        this.sheet = sheet;
        this.targetFields = targetFields;
    }

    public int write(Map<String, Object> data) {
        this.helpWrite(data, "", this.targetFields, ++this.curRowIndex, "");
        return this.curRowIndex;
    }

    private String getFullName(String fullName) {
        return fullName.length() == 0 ? "" : fullName.substring(1);
    }

    private int helpWrite(Object value, String key, Object fieldMap, int rowIndex, String fullName) {
        if (value instanceof Map) {
            if (fieldMap instanceof Map) {
                return this.writeMap((Map)value, (Map)fieldMap, rowIndex, fullName);
            }
            throw new DataFileJobFailException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5 \u201c%s\u201d \u914d\u7f6e\u9519\u8bef\uff0cExcel\u4e0d\u652f\u6301\u5bfc\u51faMap\u7ed3\u6784\u7684\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u5176\u4e0b\u5c42\u4e0d\u80fd\u518d\u62c6\u5206\u7684\u5b57\u6bb5\uff0c\u591a\u8bed\u8a00\u5b57\u6bb5\u5e94\u9009\u62e9\u5177\u4f53\u8bed\u8a00\u5bfc\u51fa\uff0c\u5982 modifier.name.zh_CN", (String)"SheetDataWriteHelper_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.getFullName(fullName)));
        }
        if (value instanceof Collection) {
            if (fieldMap instanceof Integer) {
                return this.writeSingleField(key, value, fieldMap, rowIndex);
            }
            int tmpCurRowIndex = this.writeEntry((Collection)value, (Map)fieldMap, rowIndex, fullName);
            this.curRowIndex = Math.max(this.curRowIndex, tmpCurRowIndex);
            return tmpCurRowIndex;
        }
        if (fieldMap instanceof Map) {
            fullName = this.getFullName(fullName);
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5 \u201c%1$s\u201d \u914d\u7f6e\u9519\u8bef\uff0c\u82e5\u9009\u62e9\u4e86\u5bfc\u51facreator.number,\u4e0d\u5e94\u518d\u9009\u62e9creator,\u5e94\u9009\u62e9creator.id\u3002\u8bf7\u68c0\u67e5\u5bfc\u51fa\u65b9\u6848\u4e2d\u5b57\u6bb5\u201c%2$s\u201d\u662f\u5426\u4e3a\u57fa\u7840\u8d44\u6599\uff0c\u800c\u5bfc\u51fa\u65b9\u6848\u4e2d\u53c8\u5305\u542b\u8be5\u57fa\u7840\u8d44\u6599.\u5176\u4ed6\u5b57\u6bb5\u3002\u8bf7\u8c03\u6574\u5bfc\u51fa\u5b57\u6bb5\u201c%3$s\u201d\u4e3a\u201c%4$s.id\u201d\uff0c\u907f\u514d\u5728\u5bfc\u51fa\u7684\u57fa\u7840\u8d44\u6599\u4e3a\u7a7a\u65f6\u5bfc\u81f4\u5076\u53d1\u51fa\u9519", (String)"SheetDataWriteHelper_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), fullName, fullName, fullName, fullName));
        }
        return this.writeSingleField(key, value, fieldMap, rowIndex);
    }

    private int writeMap(Map<String, Object> value, Map<String, Object> fieldMap, int rowIndex, String fullName) {
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            this.helpWrite(entry.getValue(), entry.getKey(), fieldMap.get(entry.getKey()), rowIndex, fullName + "." + entry.getKey());
        }
        return rowIndex;
    }

    private int writeEntry(Collection<?> value, Map<String, Object> fieldMap, int rowIndex, String fullName) {
        int nextRowIndex = rowIndex;
        for (Object data : value) {
            Map map = (Map)data;
            for (Map.Entry entry : map.entrySet()) {
                Object entryValue = entry.getValue();
                int tmpRowIndex = this.helpWrite(entryValue, (String)entry.getKey(), fieldMap.get(entry.getKey()), rowIndex, fullName + "." + (String)entry.getKey());
                nextRowIndex = Math.max(nextRowIndex, tmpRowIndex);
            }
            rowIndex = ++nextRowIndex;
        }
        return --nextRowIndex;
    }

    private int writeSingleField(String key, Object value, Object fieldMap, int rowIndex) {
        Integer fieldCellIndex = (Integer)fieldMap;
        Row row = this.createRowIfNoExist(rowIndex);
        if (fieldCellIndex != null) {
            row.createCell(fieldCellIndex.intValue()).setCellValue(ExcelFileWriter.toString(key, value));
        }
        return rowIndex;
    }

    private Row createRowIfNoExist(int rowIndex) {
        if (this.sheet.getLastRowNum() < rowIndex) {
            return this.sheet.createRow(rowIndex);
        }
        return this.sheet.getRow(rowIndex);
    }
}

