/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.f.t.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import kd.isc.iscb.platform.core.connector.self.AttachmentUtil;
import kd.isc.iscb.platform.core.dc.f.DataFileWriter;
import kd.isc.iscb.platform.core.dc.f.FileBinding;
import kd.isc.iscb.platform.core.dc.f.err.DataFileError;
import kd.isc.iscb.platform.core.dc.f.tag.FileTag;
import kd.isc.iscb.platform.core.util.FileUtil;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class JsonFileWriter
extends DataFileWriter {
    private BufferedOutputStream out;
    private File tempFile;
    private FileTag fileTag;

    public JsonFileWriter(FileBinding binding, FileTag fileTag) throws Exception {
        super(binding);
        this.fileTag = fileTag;
        this.prepare();
    }

    public void write(Map<String, Object> o) {
        try {
            this.out.write(JSON.toJSONString(o, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.UseISO8601DateFormat, SerializerFeature.WriteMapNullValue}).getBytes(StandardCharsets.UTF_8));
            this.out.write(13);
            this.out.write(10);
            o.put("$action", SaveDataType.UNKNOWN);
            this.checkAndSwap();
        }
        catch (Exception e) {
            throw DataFileError.DATA_FILE_WRITER_FAILRUE.wrap((Throwable)e);
        }
    }

    public void commit() {
        try {
            DbUtil.close((OutputStream)this.out);
            super.commit(this.tempFile);
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
    }

    public boolean rollback(Throwable cause) {
        return false;
    }

    public void close() {
        DbUtil.close((OutputStream)this.out);
        FileUtil.delete(this.tempFile);
    }

    private void checkAndSwap() throws Exception {
        if (this.tempFile.length() >= this.getBinding().maxFileSize()) {
            DbUtil.close((OutputStream)this.out);
            super.commit(this.tempFile);
            FileUtil.delete(this.tempFile);
            this.prepare();
        }
    }

    private void prepare() throws Exception {
        this.tempFile = this.createFile();
        this.out = new BufferedOutputStream(new FileOutputStream(this.tempFile));
        this.addTag();
    }

    private void addTag() {
        try {
            this.out.write(JSON.toJSONString(this.fileTag.getTagMap()).getBytes(D.UTF_8));
            this.out.write(13);
            this.out.write(10);
        }
        catch (IOException e) {
            throw DataFileError.DATA_FILE_TAG_APPEND_ERR.wrap((Throwable)e);
        }
    }

    protected File createFile() {
        return AttachmentUtil.createTempFile("json");
    }
}

