/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.meta;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.dc.meta.MetaUtil;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public abstract class AbstractDataRepository {
    private DynamicObject meta;
    private volatile Table table;

    protected AbstractDataRepository(DynamicObject meta) {
        this.meta = meta;
    }

    protected abstract ConnectionWrapper getConnection();

    public final DynamicObject getMeta() {
        return this.meta;
    }

    public final boolean isTable() {
        return this.meta.get("type").equals("TABLE");
    }

    public final Table getTable() {
        Table table = this.table;
        if (table == null) {
            table = this.initTable();
        }
        return table;
    }

    private synchronized Table initTable() {
        Table table = this.table;
        if (table == null) {
            if (this.isTable()) {
                String tableName = this.getTableName();
                ConnectionWrapper cn = this.getConnection();
                this.table = table = ConnectionManager.getTable(cn, tableName);
            } else {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61\uff08%s\uff09\u4e0d\u662f\u6570\u636e\u8868\uff01", (String)"AbstractDataRepository_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.meta.getString("number")));
            }
        }
        return table;
    }

    public final String getTableName() {
        return D.s((Object)this.meta.get("table_name"));
    }

    public final boolean isView() {
        return this.meta.get("type").equals("VIEW");
    }

    public final boolean isEntity() {
        return this.meta.get("type").equals("ENTITY");
    }

    public final boolean isQuery() {
        return this.meta.get("type").equals("QUERY");
    }

    public final boolean isService() {
        return this.meta.get("type").equals("SERVICE");
    }

    public final boolean isStruct() {
        return this.meta.get("type").equals("STRUCT");
    }

    public final String getPrimaryKey() {
        return MetaUtil.getPrimaryKey(this.meta);
    }
}

